<?php
$loginmsg = "";
$extracss = " style=\"display:none;\"";
if(isset($_REQUEST['r']))
{
	$loginmsg = filter_var($_REQUEST['r'], FILTER_SANITIZE_STRING);
	if($loginmsg == "timeout")
	{
		$loginmsg = "session timed out";
		doAuditLog(AUDIT_SESSION_TIMEOUT, "Session timedout for " . getUserName());
	}
	else if($loginmsg == "badsession")
		$loginmsg = "invalid session or session timed out";
	$extracss = "";
}
if(isset($_REQUEST['redir']))
{
	$redir = $_REQUEST['redir'];
	if(isValidApp($redir))
		$_SESSION['redir'] = $redir;
}
?>
<div id="content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-12">
				<p class="text-center"><a href="menu.php"><img id="loginlogo" src="lib/css/images/logo-small.png" class="img-responsive logo" alt="Watch My Domains SED v3"></a></p>
			</div>
		</div>
		<div class="row lgbox">
			<div class="col-sm-1"></div>
			<div class="col-sm-10 loginbg text-center">
				<div class="loginbox">
					<input type="text" id="ui-user" class="form-control" placeholder="Username" required autofocus>
					<input type="password" id="ui-password" class="form-control" placeholder="Password" required>
					<hr>
					<a id="login-submit" class="btn btn-primary btn-block" type="submit">Sign in</a>
					<div class="loginmsg"<?php echo $extracss; ?>>
						<br>
						<p class="text-danger bg-danger" id="login-message" style="margin-bottom:0;">
						<?php echo $loginmsg; ?>
						</p>
					</div>
				</div>
			</div>
			<div class="col-sm-1"></div>
		</div>
		<br>
		<div class="row">
			<div class="col-xs-12">
				<p class="text-center">
				Watch My Domains Server Edition
				<?php
					if(function_exists('get_version'))
					{
						echo '&nbsp;' . get_version() . '.&nbsp;';
						echo '<br>Build: ' . get_build_date();
					}
				?>
				</p>
			</div>
		</div>
	</div>
</div>
