<?php
###############################################################################
# domain.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

function get_domain_domain_table_columns()
{
	return array(

	"sid", 							"bigint(20)", 			"NOT NULL AUTO_INCREMENT",
	"domain", 						"varchar(255)", 		"CHARACTER SET utf8 COLLATE utf8_bin NOT NULL",
	"registry_expiry", 				"date", 				"DEFAULT NULL",
	"registrar_expiry", 			"date", 				"DEFAULT NULL",
	"created_on", 					"date", 				"DEFAULT NULL",
	"last_update", 					"datetime", 			"DEFAULT NULL",
	"registrar", 					"varchar(150)", 		"DEFAULT NULL",
	"status", 						"varchar(255)", 		"DEFAULT NULL",
	"availability", 				"varchar(64)", 			"DEFAULT NULL",
	"domain_id", 					"varchar(64)", 			"DEFAULT NULL",
	"whois_server", 				"varchar(64)", 			"DEFAULT NULL",
	"ip", 							"varchar(16)", 			"DEFAULT NULL",
	"ns1", 							"varchar(64)", 			"DEFAULT NULL",
	"ns2", 							"varchar(64)", 			"DEFAULT NULL",
	"ns3", 							"varchar(64)", 			"DEFAULT NULL",
	"ns4", 							"varchar(64)", 			"DEFAULT NULL",
	"ns5", 							"varchar(64)", 			"DEFAULT NULL",
	"ns6", 							"varchar(64)", 			"DEFAULT NULL",
	"ns7",							"varchar(64)", 			"DEFAULT NULL",
	"ns8", 							"varchar(64)", 			"DEFAULT NULL",
	"mx1", 							"varchar(64)", 			"DEFAULT NULL",
	"mx2", 							"varchar(64)", 			"DEFAULT NULL",
	"mx3", 							"varchar(64)", 			"DEFAULT NULL",
	"mxip1",	 					"varchar(16)", 			"DEFAULT NULL",
	"mxip2", 						"varchar(16)", 			"DEFAULT NULL",
	"mxip3", 						"varchar(16)", 			"DEFAULT NULL",
	"admin_email", 					"varchar(120)",			"DEFAULT NULL",
	"tech_email", 					"varchar(120)", 		"DEFAULT NULL",
	"billing_email", 				"varchar(120)", 		"DEFAULT NULL",
	"registrant_email", 			"varchar(120)", 		"DEFAULT NULL",
	"owner", 						"varchar(210)", 		"DEFAULT NULL",
	"organization", 				"varchar(120)", 		"DEFAULT NULL",
	"address", 						"varchar(255)", 		"DEFAULT NULL",
	"owner_country", 				"varchar(64)", 			"DEFAULT NULL",
	"admin_phone", 					"varchar(64)", 			"DEFAULT NULL",
	"notes_a", 						"varchar(255)", 		"DEFAULT NULL",
	"notes_b", 						"varchar(255)", 		"DEFAULT NULL",
	"notes_c", 						"varchar(255)", 		"DEFAULT NULL",
	"notes_d", 						"varchar(255)", 		"DEFAULT NULL",
	"us_tm_records", 				"bigint(20)", 			"DEFAULT NULL",
	"ping_time", 					"bigint(20)", 			"DEFAULT NULL",
	"home_page_status", 			"varchar(120)", 		"DEFAULT NULL",
	"home_page_modified", 			"datetime", 			"DEFAULT NULL",
	"home_page_size", 				"varchar(64)", 			"DEFAULT NULL",
	"redirect_url", 				"varchar(120)", 		"DEFAULT NULL",
	"redirect_last_url", 			"varchar(120)", 		"DEFAULT NULL",
	"home_page_url", 				"varchar(120)", 		"DEFAULT NULL",
	"home_page_title", 				"varchar(180)", 		"DEFAULT NULL",
	"home_page_header", 			"varchar(255)", 		"DEFAULT NULL",
	"home_page_token", 				"varchar(255)", 		"DEFAULT NULL",
	"page_token_found", 			"tinyint(1)", 			"unsigned DEFAULT NULL",
	"google_pr", 					"bigint(20)", 			"DEFAULT NULL",
	"google_links", 				"bigint(20)", 			"DEFAULT NULL",
	"alexa_rank", 					"bigint(20)", 			"DEFAULT NULL",
	"alexa_reach", 					"bigint(20)", 			"DEFAULT NULL",
	"alexa_links", 					"bigint(20)", 			"DEFAULT NULL",
	"yahoo_links", 					"bigint(20)", 			"DEFAULT NULL",
	"bing_links", 					"bigint(20)", 			"DEFAULT NULL",
	"se_link_count", 				"bigint(20)", 			"DEFAULT NULL",
	"write_protect", 				"tinyint(1)", 			"unsigned DEFAULT NULL",
	"edited", 						"tinyint(1)", 			"unsigned DEFAULT NULL",
	"disable_alerts", 				"tinyint(1)", 			"unsigned DEFAULT NULL",
	"lookedup", 					"datetime", 			"DEFAULT NULL",
	"ip_checked_at", 				"datetime", 			"DEFAULT NULL",
	"us_tm_checked_at", 			"datetime", 			"DEFAULT NULL",
	"ping_checked_at", 				"datetime", 			"DEFAULT NULL",
	"home_page_checked_at", 		"datetime", 			"DEFAULT NULL",
	"mx_checked_at", 				"datetime", 			"DEFAULT NULL",
	"manual_edited_at", 			"datetime", 			"DEFAULT NULL",
	"google_pr_checked_at", 		"datetime", 			"DEFAULT NULL",
	"alexa_checked_at", 			"datetime", 			"DEFAULT NULL",
	"google_sitepop_checked_at",	"datetime", 			"DEFAULT NULL",
	"yahoo_sitepop_checked_at", 	"datetime", 			"DEFAULT NULL",
	"bing_sitepop_checked_at", 		"datetime", 			"DEFAULT NULL",
	"registry_whois", 				"longtext",				"DEFAULT NULL",
	"registrar_whois", 				"longtext", 			"DEFAULT NULL",
	"ip_whois", 					"longtext", 			"DEFAULT NULL",
	"homepage_html", 				"longtext",				"DEFAULT NULL",
	"added_on", 					"datetime", 			"DEFAULT NULL",
	"ascii_domain", 				"varchar(255)", 		"DEFAULT NULL",
	"r_h_disp", 					"tinyint(1)", 			"unsigned DEFAULT NULL",
	"ssl_checked_at", 				"datetime", 			"DEFAULT NULL",
	"dns_checked_at", 				"datetime", 			"DEFAULT NULL",
	"google_index_count", 			"bigint(20)", 			"DEFAULT NULL",
	"google_index_checked_at", 		"datetime", 			"DEFAULT NULL",
	"bing_index_count", 			"bigint(20)", 			"DEFAULT NULL",
	"bing_index_checked_at", 		"datetime", 			"DEFAULT NULL",
	"yahoo_index_count", 			"bigint(20)", 			"DEFAULT NULL",
	"yahoo_index_checked_at", 		"datetime", 			"DEFAULT NULL",
	"ip_org_name",  				"varchar(255)", 		"DEFAULT NULL",
	"ip_net_name",  				"varchar(255)", 		"DEFAULT NULL",
	"ip_rtech_name",  				"varchar(255)", 		"DEFAULT NULL",
	"ip_asname",  					"varchar(255)", 		"DEFAULT NULL",
	"ip_asnumber",  				"varchar(16)", 			"DEFAULT NULL",
	"ip_whois_at", 					"datetime", 			"DEFAULT NULL"
	);
}

###############################################################################

function get_db_resettable_domain_whois_columns()
{
	return array(

	'registry_expiry', 'registrar_expiry',
	'created_on', 'last_update', 'registrar', 
	'status', 'availability',
	'ns1', 'ns2', 'ns3', 'ns4', 'ns5', 'ns6', 'ns7', 'ns8', 
	'owner', 'organization', 'address', 'owner_country',
	'admin_email', 'tech_email', 'billing_email', 'registrant_email', 'r_h_disp'

	);
}

###############################################################################

function get_domain_settings_columns()
{
	return array(

	"id", 							"bigint(20)", 			"NOT NULL AUTO_INCREMENT",
	"name", 						"varchar(255)", 		"NOT NULL DEFAULT ''",
	"value", 						"varchar(255)", 		"NOT NULL DEFAULT ''"

	);
}

###############################################################################

function get_domain_display_columns()
{
	return array(

	"id", 							"int(11)", 				"NOT NULL AUTO_INCREMENT",
	"name", 						"varchar(128)", 		"NOT NULL DEFAULT ''",
	"entry", 						"text", 				"DEFAULT NULL"

	);
}

###############################################################################

function get_domain_categorytable_columns()
{
	return array(

	"CategoryID", 					"int(11)", 				"NOT NULL AUTO_INCREMENT",
	"CategoryName", 				"varchar(64)", 			"NOT NULL",
	"Description", 					"text", 				"DEFAULT NULL",
	"SortOrder", 					"int(11)", 				"DEFAULT NULL"

	);
}

###############################################################################

function get_domain_catconntable_columns()
{
	return array(

	"id", 							"int(11)", 				"NOT NULL AUTO_INCREMENT",
	"CategoryID",					"int(11)", 				"NOT NULL",
	"sid", 							"bigint(20)", 			"NOT NULL"
	 
	 );
}

###############################################################################

function get_domain_autoquerytable_columns()
{
	return array(

	"id", 							"int(11)", 				"NOT NULL AUTO_INCREMENT",
	"Name", 						"varchar(64)", 			"NOT NULL",
	"Description", 					"text", 				"DEFAULT NULL",
	"Query", 						"text", 				"NOT NULL",
	"SortOrder", 					"int(11)", 				"DEFAULT NULL"

	);
}

###############################################################################

function get_domain_luq_columns()
{
	return array(

	"id",							"bigint(20)",			"NOT NULL AUTO_INCREMENT",
	"sid",							"bigint(20)",			"NOT NULL",
	"subid",						"bigint(20)", 			"DEFAULT NULL",
	"type",							"int(20)",				"NOT NULL DEFAULT '0'",
	"status",						"tinyint(4)", 			"NOT NULL DEFAULT '0'",
	"created_on",					"datetime", 			"DEFAULT NULL",
	"last_update",					"datetime", 			"DEFAULT NULL",
	"server",						"varchar(255)", 		"DEFAULT NULL"

	);
}

###############################################################################

function get_domain_tlds_colums()
{
	return array (

	"tld", 							"varchar(20)", 			"NOT NULL DEFAULT ''",
	"server", 						"varchar(255)", 		"NOT NULL DEFAULT ''"

	);
}

###############################################################################

function get_domain_whoisserver_columns()
{
	return array (

	"server", 						"varchar(255)", 		"NOT NULL DEFAULT ''",
	"query", 						"varchar(255)", 		"DEFAULT NULL",
	"port", 						"int(4)", 				"DEFAULT NULL",
	"searchtoken", 					"varchar(128)", 		"NOT NULL DEFAULT ''",
	"bannedtext", 					"varchar(128)", 		"DEFAULT NULL",
	"stop_lookups", 				"tinyint(1)", 			"unsigned DEFAULT NULL",
	"dateformat", 					"varchar(8)", 			"DEFAULT NULL",
	"maxconnections", 				"int(4)", 				"DEFAULT NULL",
	"conninterval", 				"int(4)", 				"DEFAULT NULL",
	"cleantoken_1", 				"varchar(128)", 		"DEFAULT NULL",
	"cleantoken_2", 				"varchar(128)", 		"DEFAULT NULL",
	"xlate", 						"longtext", 			"DEFAULT NULL",
	"last_connect_at", 				"datetime", 			"DEFAULT NULL",
	"proxy", 						"varchar(255)", 		"DEFAULT NULL"

	);
}

###############################################################################

function get_domain_last_lookups_table_columns()
{
	return array (

	"id", 							"int(11)",				"NOT NULL AUTO_INCREMENT",
	"name", 						"varchar(24)",			"NOT NULL DEFAULT ''",
	"description", 					"varchar(128)",			"DEFAULT NULL",
	"server",						"varchar(255)", 		"NOT NULL DEFAULT ''",
	"last_connect_at", 				"datetime",				"DEFAULT NULL",
	"stop_lookups", 				"tinyint(1)", 			"unsigned DEFAULT NULL"

	);
}

###############################################################################

function get_domain_subdomain_table_columns()
{
	return array (

	"hid", 							"bigint(20)", 			"NOT NULL AUTO_INCREMENT",
	"sid", 							"bigint(20)", 			"NOT NULL",
	"ip", 							"varchar(16)", 			"DEFAULT NULL",
	"subdomain", 					"varchar(255)", 		"CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT ''",
	"ssl_valid_from", 				"datetime", 			"DEFAULT NULL",
	"ssl_valid_to", 				"datetime", 			"DEFAULT NULL",
	"ssl_issued_to", 				"varchar(255)", 		"DEFAULT NULL",
	"ssl_issued_by", 				"varchar(255)", 		"DEFAULT NULL",
	"subject_key_id",				"varchar(128)", 		"DEFAULT NULL",
	"subject_alt_name", 			"text", 				"DEFAULT NULL",
	"notes_a", 						"varchar(255)", 		"DEFAULT NULL",
	"notes_b", 						"varchar(255)", 		"DEFAULT NULL",
	"notes_c",						"varchar(255)", 		"DEFAULT NULL",
	"notes_d", 						"varchar(255)", 		"DEFAULT NULL",
	//"ssl_checked_at", 			"datetime", 			"DEFAULT NULL",
	//"ip_checked_at", 				"datetime", 			"DEFAULT NULL",
	"added_on", 					"datetime", 			"DEFAULT NULL",
	"edited", 						"tinyint(1)",			"unsigned DEFAULT NULL",
	"auto_added", 					"tinyint(1)", 			"unsigned DEFAULT NULL",
	"manual_edited_at", 			"datetime", 			"DEFAULT NULL",
	"record_type", 					"varchar(32)", 			"DEFAULT NULL",
	"record_value", 				"varchar(255)", 		"DEFAULT NULL",
	"ttl", 							"int(11)", 				"DEFAULT NULL",
	"r_h_disp", 					"tinyint(1)", 			"unsigned DEFAULT NULL",
	"ptr", 							"varchar(255)", 		"NOT NULL DEFAULT ''"

	);
}

###############################################################################

function get_domain_custom_fields_table_columns()
{
	return array (

	"id",							"int(11)", 				"NOT NULL AUTO_INCREMENT",
	"name",							"varchar(128)",			"NOT NULL",
	"ftype",						"varchar(128)",			"NOT NULL DEFAULT 'VARCHAR(255)'",
	"fdefault",						"varchar(64)", 			"DEFAULT 'DEFAULT NULL'"

	);
}

###############################################################################

function get_domain_registrar_alias_table_columns()
{
	return array (

	"name", 						"varchar(255)", 		"NOT NULL DEFAULT ''",
	"alias", 						"varchar(128)", 		"NOT NULL DEFAULT ''"

	);
}

###############################################################################

function get_domain_data_history_table_columns()
{
	return array (

	"id",							"int(11)",				"NOT NULL AUTO_INCREMENT",
	"domain",						"varchar(255)",			"CHARACTER SET utf8 COLLATE utf8_bin NOT NULL",
	"fvalue",						"bigint(20)",			"NOT NULL",
	"ftype",						"int(10)",				"NOT NULL",
	"lookedup_at",					"datetime", 			"NOT NULL",
	"tvalue", 						"longtext", 			"DEFAULT NULL"
	);
}

###############################################################################

function get_domain_installed_servers_table_columns()
{
	return array (

	"id", 							"int(11)",				"NOT NULL AUTO_INCREMENT",
	"name",							"varchar(255)",			"NOT NULL DEFAULT ''",
	"hostname", 					"varchar(255)", 		"NOT NULL DEFAULT ''",
	"cnfname", 						"varchar(128)", 		"DEFAULT NULL",
	"description", 					"varchar(128)", 		"DEFAULT NULL",
	"address", 						"varchar(64)", 			"NOT NULL DEFAULT ''",
	"stop_lookups", 				"tinyint(1)", 			"unsigned DEFAULT NULL",
	"last_connect_at", 				"varchar(64)", 			"DEFAULT NULL",
	"last_lookup_at", 				"varchar(64)", 			"DEFAULT NULL",
	"baseurl", 						"varchar(255)", 		"NOT NULL DEFAULT ''",
	"queue_index", 					"int(11)", 				"DEFAULT NULL",
	"ver_index", 					"int(11)", 				"DEFAULT NULL"

	);
}

###############################################################################

function get_domain_auditlog_columns()
{
	return array(

	"id", 							"bigint(20)", 			"NOT NULL AUTO_INCREMENT",
	"action", 						"int(10)", 				"NOT NULL",
	"uid",							"int(11)",				"NOT NULL",
	"description", 					"text", 				"DEFAULT NULL",
	"timeat",						"datetime", 			"NOT NULL",
	"remote",						"varchar(64)", 			"DEFAULT NULL"
	
	);
}

###############################################################################

function get_second_level_tld_columns()
{
	return array(
	"id", 							"bigint(20)", 			"NOT NULL AUTO_INCREMENT",
	"tld", 							"varchar(255)", 		"CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT ''"
	);
}

###############################################################################

function get_registrar_api_columns()
{
	return array(
	"id", 						"bigint(20)", 			"NOT NULL AUTO_INCREMENT",
	"registrar", 				"varchar(128)", 		"NOT NULL",
	"label", 					"varchar(128)", 		"NOT NULL",
	"type", 					"varchar(32)", 			"NOT NULL DEFAULT 'user'", // user,fixed
	"dtype", 					"varchar(32)", 			"NOT NULL DEFAULT 'text'", // text, number
	"value", 					"varchar(255)", 		"DEFAULT NULL", // user,fixed
	);
}

###############################################################################

function getRegistrarAPIDefaults()
{
return array(
// (`registrar`,`label`,`type`,`dtype`,`value`) VALUES 
'Dynadot','API Access Key','user','text','',
'Dynadot','Profile Name','fixed','text','Dynadot',
'Dynadot','URL','fixed','text','https://api.dynadot.com/api3.xml',
'Dynadot','Default Whois Server','fixed','text','whois.dynadot.com',

'GoDaddy','API Access Key','user','text','',
'GoDaddy','API Secret Key','user','text','',
'GoDaddy','Profile Name','fixed','text','GoDaddy',
'GoDaddy','URL','fixed','text','https://api.godaddy.com/v1/domains/',
'GoDaddy','Default Whois Server','fixed','text','whois.godaddy.com'
);

}

###############################################################################

function getCategoryDefaultSQL()
{
	$categoryDefaultSQL = "(`CategoryName`) VALUES ('Keyword Domains'),('Parked Domains'),('Personal Domains'),('Business Domains'),('Bookmarked Domains'),('High Traffic Domains'),('Low Traffic Domains'),('Important Domains'),('Desired Domains')";
	return $categoryDefaultSQL;
}

###############################################################################

function getAutoqueryDefaultSQL()
{
$autoqueryDefaultSQL = <<<EOT
(`Name`, `Description`, `Query`) VALUES
('All Domains', NULL, ''),
('Unknown Domains (No Whois Lookup Yet)', NULL, 'FROM [domains] a WHERE (a.lookedup IS NULL OR a.lookedup = ''0000-00-00'')'),

('Domains with Empty Status', NULL, 'FROM [domains] a WHERE (a.status IS NULL OR a.status = '''')'),

('Different Registrar/Registry Expiry', NULL, 'FROM [domains] a WHERE (a.registry_expiry <> a.registrar_expiry)'),

('Registry Expiry Date Not Set', NULL, 'FROM [domains] a WHERE (a.registry_expiry IS NULL OR a.registry_expiry = ''0000-00-00'')'),
('Registrar Expiry Date Not Set', NULL, 'FROM [domains] a WHERE (a.registrar_expiry IS NULL OR a.registrar_expiry = ''0000-00-00'')'),
('COM or NET domains with Empty Registrar Expiry Date', NULL, 'FROM [domains] a WHERE (a.domain LIKE ''%.com'' OR a.domain LIKE ''%.net'') AND (a.registrar_expiry IS NULL OR a.registrar_expiry = ''0000-00-00'')'),

('About to Expire (Registrar) in 30 Days', NULL, 'FROM [domains] a WHERE (a.registrar_expiry < [TODAY+30] AND a.registrar_expiry IS NOT NULL AND a.registrar_expiry <> ''0000-00-00'')'),
('About To Expire (Registry) in 30 Days', NULL, 'FROM [domains] a WHERE (a.registry_expiry < [TODAY+30] AND  a.registry_expiry IS NOT NULL and a.registry_expiry <> ''0000-00-00'')'),

('Past Registry Expiry Date', NULL, 'FROM [domains] a WHERE a.registry_expiry < [TODAY]'),

('Past Registrar Expiry Date', NULL, 'FROM [domains] a WHERE a.registrar_expiry < [TODAY]'),

('Added the within the last day', NULL, 'FROM [domains] a WHERE a.added_on > [TODAY-1]'),
('Added the within the last 5 days', NULL, 'FROM [domains] a WHERE a.added_on > [TODAY-5]'),
('Added the within the last 30 days', NULL, 'FROM [domains] a WHERE a.added_on > [TODAY-30]'),

('Domains with a Hyphen', NULL, 'FROM [domains] a WHERE a.domain LIKE ''%-%'''),
('International Domains', NULL, 'FROM [domains] a WHERE a.ascii_domain LIKE ''xn--%'''),
('Domains with No Category', NULL, 'FROM [domains] a LEFT JOIN [catconn] b ON a.sid = b.sid WHERE b.sid IS null'),

('Domains with an IP', NULL, 'FROM [domains] a WHERE a.ip IS NOT NULL AND a.ip NOT LIKE ''%error%'' AND a.ip <> '''''),
('Domains with No IP', NULL, 'FROM [domains] a WHERE a.ip IS  NULL OR a.ip = '''' OR a.ip = ''-'' OR a.ip = ''error'''),
('Available Domains', NULL, 'FROM [domains] a WHERE a.status LIKE ''%available%'' OR a.status = ''not registered'''),

('Domains with HTTP/1.1 200 Home Page', NULL, 'FROM [domains] a WHERE a.home_page_status LIKE ''%/1.1 200%'''),
('Domains with HTTP/1.1 301 Home Page', NULL, 'FROM [domains] a WHERE a.home_page_status LIKE ''%/1.1 301%'''),
('Domains with HTTP/1.1 302 Home Page', NULL, 'FROM [domains] a WHERE a.home_page_status LIKE ''%/1.1 302%'''),
('Domains with HTTP/1.1 403 Home Page', NULL, 'FROM [domains] a WHERE a.home_page_status LIKE ''%/1.1 403%'''),
('Domains with HTTP/1.1 404 Home Page', NULL, 'FROM [domains] a WHERE a.home_page_status LIKE ''%/1.1 404%'''),
('Domains with HTTP/1.1 500 Home Page', NULL, 'FROM [domains] a WHERE a.home_page_status LIKE ''%/1.1 500%''');
EOT;

return $autoqueryDefaultSQL;
}

###############################################################################

function getWhoisServerTableDefaultSQL()
{
$whoisServerTableDefaultSQL = <<<EOT
(`server`, `query`, `port`, `searchtoken`, `dateformat`, `maxconnections`, `conninterval`, `cleantoken_1`, `cleantoken_2`, `xlate`) VALUES
('whois.ja.net', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, 'Registered For{nl}=>organization\r\nDomain Owner{nl}=>owner\r\nRegistered By{nl}=>registrar\r\nServers{ml}=>name server\r\nRenewal date{nl}=>registrar_expiry\r\nEntry updated{nl}=>last_update\r\nEntry created{nl}=>created_on\r\nRegistrant Address{ml}=>address\r\n'),
('whois.crsnic.net', 'domain', NULL, '', NULL, NULL, NULL, NULL, NULL, NULL),
('whois.nic.de', '-T dn', NULL, '', 'mmdd', NULL, NULL, NULL, NULL, '[Zone-C]@@Changed=>last_update\r\nNserver=>name server\r\n[Zone-C]@@Address:=>address\r\n[Zone-C]@@Name:=>owner\r\n[Zone-C]@@Organisation:=>organization\r\n[Zone-C]@@PostalCode:=>address\r\n[Zone-C]@@City:=>address\r\n[Zone-C]@@CountryCode:=>owner_country\r\n[Zone-C]@@Email:=>admin_email\r\n'),
('whois.jprs.jp', '{D} /e', NULL, '', NULL, NULL, NULL, NULL, NULL, '[Registrant]=>owner\r\n[Name Server]=>name server\r\n[Created on]=>created_on\r\n[Expires on]=>expiry_date\r\n[Status]=>status\r\n[Last Updated]=>last_update\r\n[Email]=>admin_email\r\n[Postal Address]=>address\r\n[Phone]=>admin_phone\r\n[Fax]=>admin_fax\r\n'),
('whois.ripn.net', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, 'created=>created_on\r\nLast updated on=>last_update\r\npaid-till=>registry_expiry\r\nstate=>status\r\nnserver=>name server\r\n'),
('whois.nic.uk', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, 'Registrant''s address{ml}=>address\r\nRegistrant:{nl}=>owner\r\nRegistrar:{nl}=>registrar\r\nRegistration status:{nl}=>status\r\nRegistered on=>created_on\r\nLast updated=>last_update\r\nRenewal date=>expiry_date\r\nExpiry date=>expiry_date\r\nName servers:{ml}=>name server\r\n\r\n'),
('whois.cira.ca', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, ''),
('whois.godaddy.com', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL),
('whois.tcinet.ru', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, '[*]=>*\r\nstate:=>status\r\nregistrar:=>registrar'),
('whois.nic.xxx', NULL, NULL, 'NOT FOUND', NULL, NULL, NULL, NULL, NULL, NULL),
('whois.ausregistry.net.au', NULL, NULL, '', NULL, NULL, 183, NULL, NULL, NULL),
('whois.nic.io',NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, 'Owner=>owner\r\nNS 1=>name server\r\nNS 2=>name server\r\nNS 3=>name server\r\nNS 4=>name server\r\nExpiry :=>registry_expiry\r\nStatus :=>status'),
('whois.nic.ac',NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, 'Owner=>owner\r\nNS 1=>name server\r\nNS 2=>name server\r\nNS 3=>name server\r\nNS 4=>name server\r\nExpiry :=>registry_expiry\r\nStatus :=>status'),
('whois.nic.sh',NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, 'Owner=>owner\r\nNS 1=>name server\r\nNS 2=>name server\r\nNS 3=>name server\r\nNS 4=>name server\r\nExpiry :=>registry_expiry\r\nStatus :=>status'),
('whois.nic.asia', NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, '[*]=>*\r\nRegistrant Address:=>address\r\nRegistrant Address2:=>address\r\nRegistrant Address3:=>address\r\nRegistrant City:=>address\r\nRegistrant State/Province:=>address\r\nRegistrant Country/Economy:=>address\r\nRegistrant Postal Code:=>address\r\nNameservers:=>name server\r\nRegistrant Country/Economy:=>owner_country\r\n\r\n');
EOT;
return $whoisServerTableDefaultSQL;
}

###############################################################################

function getTldTableDefaultSQL()
{
$tldTableDefaultSQL = <<<EOT
(`tld`, `server`) VALUES
('com', 'whois.crsnic.net'), 
('net', 'whois.crsnic.net'), 
('org', 'whois.publicinterestregistry.net'), 
('edu', 'whois.crsnic.net'), 
('uk', 'whois.nic.uk'), 
('au', 'whois.ausregistry.net.au'), 
('in', 'whois.registry.in'), 
('info', 'whois.afilias.net'), 
('biz', 'whois.neulevel.biz'), 
('aero', 'whois.aero'), 
('coop', 'whois.nic.coop'), 
('name', 'whois.nic.name'), 
('ws', 'whois.website.ws'), 
('nl', 'whois.sidn.nl'), 
('nu', 'whois.nic.nu'), 
('de', 'whois.nic.de'), 
('ca', 'whois.cira.ca'), 
('nz', 'whois.domainz.net.nz'), 
('us', 'whois.nic.us'), 
('fr', 'whois.nic.fr'), 
('tw', 'whois.twnic.net.tw'), 
('tv', 'whois.nic.tv'), 
('ch', 'whois.nic.ch'), 
('eu', 'whois.eu'), 
('it', 'whois.nic.it'), 
('cn', 'whois.cnnic.net.cn'), 
('mobi', 'whois.dotmobiregistry.net'), 
('cc', 'whois.nic.cc'),
('asia', 'whois.nic.asia'),
('pro', 'whois.afilias.net'),
('hk', 'whois.hknic.net.hk'),
('me', 'whois.nic.me'),
('be', 'whois.dns.be'),
('se', 'whois.nic.se'),
('ie', 'whois.iedr.ie'),
('ae', 'whois.aeda.net.ae'),
('kr', 'whois.nic.or.kr'),
('tel', 'whois.nic.tel'),
('gov.uk', 'whois.ja.net'),
('mx', 'mx.whois-servers.net'),
('co', 'whois.nic.co'),
('jp', 'whois.jprs.jp'),
('xxx', 'whois.nic.xxx'),
('su', 'whois.tcinet.ru'),
('рф', 'whois.tcinet.ru'),
('uk.com', 'whois.centralnic.net'),
('uk.net', 'whois.centralnic.net'),
('gb.com', 'whois.centralnic.net'),
('us.com', 'whois.centralnic.net'),
('ventures', 'whois.donuts.co'),
('singles', 'whois.donuts.co'),
('bike', 'whois.donuts.co'),
('holdings', 'whois.donuts.co'),
('plumbing', 'whois.donuts.co'),
('guru', 'whois.donuts.co'),
('clothing', 'whois.donuts.co'),
('camera', 'whois.donuts.co'),
('equipment', 'whois.donuts.co'),
('estate', 'whois.donuts.co'),
('gallery', 'whois.donuts.co'),
('graphics', 'whois.donuts.co'),
('lighting', 'whois.donuts.co'),
('photography', 'whois.donuts.co'),
('contractors', 'whois.donuts.co'),
('land', 'whois.donuts.co'),
('technology', 'whois.donuts.co'),
('construction', 'whois.donuts.co'),
('directory', 'whois.donuts.co'),
('kitchen', 'whois.donuts.co'),
('today', 'whois.donuts.co'),
('diamonds', 'whois.donuts.co'),
('enterprises', 'whois.donuts.co'),
('tips', 'whois.donuts.co'),
('voyage', 'whois.donuts.co'),
('shoes', 'whois.donuts.co'),
('careers', 'whois.donuts.co'),
('photos', 'whois.donuts.co'),
('recipes', 'whois.donuts.co'),
('limo', 'whois.donuts.co'),
('domains', 'whois.donuts.co'),
('cab', 'whois.donuts.co'),
('company', 'whois.donuts.co'),
('computer', 'whois.donuts.co'),
('center', 'whois.donuts.co'),
('systems', 'whois.donuts.co'),
('academy', 'whois.donuts.co'),
('management', 'whois.donuts.co'),
('training', 'whois.donuts.co'),
('solutions', 'whois.donuts.co'),
('support', 'whois.donuts.co'),
('builders', 'whois.donuts.co'),
('email', 'whois.donuts.co'),
('education', 'whois.donuts.co'),
('institute', 'whois.donuts.co'),
('repair', 'whois.donuts.co'),
('camp', 'whois.donuts.co'),
('glass', 'whois.donuts.co'),
('solar', 'whois.donuts.co'),
('coffee', 'whois.donuts.co'),
('international', 'whois.donuts.co'),
('house', 'whois.donuts.co'),
('florist', 'whois.donuts.co'),
('holiday', 'whois.donuts.co'),
('marketing', 'whois.donuts.co'),
('viajes', 'whois.donuts.co'),
('farm', 'whois.donuts.co'),
('codes', 'whois.donuts.co'),
('cheap', 'whois.donuts.co'),
('zone', 'whois.donuts.co'),
('agency', 'whois.donuts.co'),
('bargains', 'whois.donuts.co'),
('boutique', 'whois.donuts.co'),
('tienda', 'whois.donuts.co'),
('watch', 'whois.donuts.co'),
('works', 'whois.donuts.co'),
('cool', 'whois.donuts.co'),
('expert', 'whois.donuts.co'),
('club', 'whois.nic.club'),
('photo', 'whois.uniregistry.net'),
('gift', 'whois.uniregistry.net'),
('guitars', 'whois.uniregistry.net'),
('pics', 'whois.uniregistry.net'),
('link', 'whois.uniregistry.net'),
('sexy', 'whois.uniregistry.net'),
('tattoo', 'whois.uniregistry.net'),
('reviews', 'whois.unitedtld.com'),
('ms', 'whois.nic.ms'),
('uno', 'whois.nic.uno'),
('buzz', 'whois.nic.buzz'),
('berlin', 'whois.nic.berlin'),
('ru', 'whois.ripn.net'),
('il', 'whois.isoc.org.il'),
('fi', 'whois.fi'),
('dk', 'whois.dk-hostmaster.dk'),
('no', 'whois.norid.no'),
('ro', 'whois.rotld.ro'),
('at', 'whois.nic.at'),
('engineer', 'whois.rightside.co'),
('attorney', 'whois.rightside.co'),
('dentist', 'whois.rightside.co'),
('degree', 'whois.rightside.co'),
('lawyer', 'whois.rightside.co'),
('market', 'whois.rightside.co'),
('mortgage', 'whois.rightside.co'),
('vet', 'whois.rightside.co'),
('republican', 'whois.rightside.co'),
('navy', 'whois.rightside.co'),
('website', 'whois.nic.website'),
('space', 'whois.nic.space'),
('host', 'whois.centralnic.com'),
('press', 'whois.centralnic.com'),
('democrat', 'whois.unitedtld.com'),
('xyz', 'whois.nic.xyz');
EOT;

return $tldTableDefaultSQL;
}

###############################################################################

?>
