<?php
###############################################################################
# config-sample.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

require_once("phpmailer/class.phpmailer.php");

###############################################################################
 
class SEDMailer extends PHPMailer
{
    public function __construct()
    {
		global $config_data;
		$language = getConfigData('interface_language', null);
		$this->SetLanguage($language);
		if(strcasecmp($config_data['email_send_method'], "smtp") == 0)
		{
			$this->IsSMTP();                                      
			$this->Host       = $config_data['email_smtp_server'];
			$this->SMTPAuth   = $config_data['email_smtp_user'] == '' ? false : true;     
			$this->SMTPSecure = $config_data['email_smtp_secure'];
			$this->Port       = $config_data['email_smtp_port'];
			$this->Username   = $config_data['email_smtp_user'];
			$this->Password   = getSMTPAuth();
		}
		else if(strcasecmp($config_data['email_send_method'], "qmail") == 0)
			$this->IsQmail();
		else if(strcasecmp($config_data['email_send_method'], "sendmail") == 0)
			$this->IsSendmail();
		else if(strcasecmp($config_data['email_send_method'], "default") == 0)
			$this->IsMail();
		
		$this->CharSet   = 'UTF-8';
		$this->WordWrap  = $config_data['email_word_wrap'];
		$this->From      = $config_data['email_from_address'];
		$this->FromName  = $config_data['email_from_name'];
		
		if($config_data['email_reply_address'] != "" && $config_data['email_reply_name'] != "")
			$this->AddReplyTo($config_data['email_reply_address'], $config_data['email_reply_name']);
    }
}

###############################################################################

function send_email($htmlmsg, $subject, $recipients)
{
	global $config_data;
	
	$ishtml = false;
	if(preg_match('/^'.preg_quote("<html>")."/", $htmlmsg))
		$ishtml = true;
	
	$status  = "";
	$retstat = true;
	
	if($htmlmsg != "")
	{
		$mail = new SEDMailer();

		$mail->IsHTML($ishtml);                                  
		foreach($recipients as $toemail => $toname)
			$mail->AddAddress($toemail, $toname);
		$mail->Subject = $subject;
		$mail->MsgHTML(trim($htmlmsg));
		$mail->CharSet   = 'UTF-8';
		$mail->WordWrap  = $config_data['email_word_wrap'];

		if(!$mail->Send())
		{
		   $status = "fail: " . $mail->ErrorInfo;
		   $retstat = false;
		}
		
		$mail->ClearAddresses();
		$mail->ClearAttachments();
		$mail->IsHTML(false);
	}
	
	return $retstat == true ? $retstat : $status;
}

###############################################################################
?>