<?php
###############################################################################
# ssl.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

function openssl_to_timestamp ($in) 
{
	$year  = substr($in, 0, 2); /* NOTE: Yes, this returns a two digit year */
	$month = substr($in, 2, 2);
	$day   = substr($in, 4, 2);
	$hour  = substr($in, 6, 2);
	$min   = substr($in, 8, 2);
	$sec   = substr($in, 10, 2);
	return gmmktime($hour, $min, $sec, $month, $day, $year);
}

###############################################################################

function get_all_ssl_records($domain, $spit_out=false)
{
	$pdo = init_db();
	if($pdo === false)
		return false;
	
	$sid = $pdo->getSingleEntry($pdo->getDomainTableName(), "domain", $domain, "sid"); 
	if($sid !== false)
	{
		$idresults = $pdo->getTableData($pdo->getSubdomainTableName(), "subdomain,hid,record_type,ssl_issued_by,ip", "where sid=$sid");
		if($idresults !== false)
		{
			foreach($idresults as $row)
			{
				$host = $row['subdomain'];
				$hid  = $row['hid'];
				$type = $row['record_type'];
				$sslby = $row['ssl_issued_by'];
				if($host == "@" && $type == "A")
					get_ssl_records("", $domain, $hid, $spit_out);
				else if($host != "" && $host != "@" && ($type != "MX" && $type != "TXT" && $type != "NS"))
					get_ssl_records($host, $domain, $hid, $spit_out);
			}
		}
	}
}

###############################################################################

function get_ssl_records($host, $domain, $hid, $spit_out=false)
{
	$subdomain = $host;
	if($subdomain == "@")
		$subdomain = "";
		
	$data_array = Array();
	if($host != "@")
	{
		$hostname = idn_convert_to_host_name($domain, $subdomain);
		
		$get = @stream_context_create(array("ssl" => array("capture_peer_cert" => TRUE, "verify_peer"=>false, "verify_peer_name"=>true)));
		$read = @stream_socket_client("ssl://" . $hostname . ":443", $errno, $errstr, 30, STREAM_CLIENT_CONNECT, $get);
		if($read != false)
		{
			$cert = stream_context_get_params($read);
			$certd = $cert["options"]["ssl"]["peer_certificate"];
			$parsed = openssl_x509_parse($cert["options"]["ssl"]["peer_certificate"]);
			if($spit_out)
				debugPrintArray($parsed['extensions']);
			
			if(isset($parsed['validFrom']))
				$data_array['ssl_valid_from'] = date("Y-m-d H:i:s", openssl_to_timestamp($parsed['validFrom']));
			if(isset($parsed['validTo']))
				$data_array['ssl_valid_to'] = date("Y-m-d H:i:s",openssl_to_timestamp($parsed['validTo']));
			if(isset($parsed['subject']['CN']))
				$data_array['ssl_issued_to'] = $parsed['subject']['CN'];
			if(isset($parsed['issuer']['CN']))
				$data_array['ssl_issued_by'] = $parsed['issuer']['CN'];
			if(isset($parsed['extensions']['subjectKeyIdentifier']))
				$data_array['subject_key_id'] = $parsed['extensions']['subjectKeyIdentifier'];
			if(isset($parsed['extensions']['subjectAltName']))
				$data_array['subject_alt_name'] = $parsed['extensions']['subjectAltName'];
		}
		else {
			if($errno == 0)
				$errstr = "Socket Initialization";
			$data_array['ssl_issued_to'] = "Error: [{$errno}] {$errstr}";
			if($spit_out)
				echo "$hostname " . $data_array['ssl_issued_to'] . "<br>";
		}
	}
	
	if(count($data_array))
	{
		$data_array['id' ] = $hid;
		if(function_exists("sedf_after_ssl_record_check"))
			sedf_after_ssl_record_check($domain, $host, $data_array, $spit_out);
		update_subdomain_table($data_array, $host, $domain);
		$domain_data['ssl_checked_at'] = date("Y-m-d H:i:s");
		update_domain_table($domain_data, $domain);
		
		if($spit_out)
			debugPrintArray($data_array);
	}
}

###############################################################################
?>
