<?php
###############################################################################
# http.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

function get_and_parse_homepage($domain, $subdomain="www", $spit_out=false)
{
	$pdo = init_db();
	if($pdo === false)
		return false;
	
	$redirs = getConfigData('home_page_max_redirs', null);
	if($redirs < 0 || $redirs > 10)
		$redirs = 0;
	
	$host = idn_convert_to_host_name($domain, $subdomain);
	
	$url  = $host;
	$page_token = trim($pdo->getSingleEntry($pdo->getDomainTableName(), "domain", $domain, "home_page_token"));
	if($page_token != "")
	{
		$pos = strpos($page_token, ";;;;");
		if($pos !== false)
		{
			$path = substr($page_token, 0, $pos);
			$page_token = substr($page_token, $pos+4);
			$url .= "/" . $path;
		}
	}
	if($spit_out)
	{
		debugEcho($url, "URL");
		debugEcho($page_token, "Page Token");
	}
	
	$header = "";
	$body = "";
	$furl = "";
	get_http_header_body($url, $header, $body);
	$headers = explode("\n", $header);
	$rurl = get_redirect_url_from_header($headers);
	if(function_exists('curl_version') && $redirs)
	{
		$rcount = 0;
		if($rurl != "")
		{
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $rurl);
			curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.1; pl; rv:1.9) Gecko/2008052906 Firefox/3.0");
			curl_setopt($ch, CURLOPT_HEADER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_MAXREDIRS, $redirs);
			$output = curl_exec($ch);
			$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			$furl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
			curl_close($ch);
			if($http_status == 200)
				$body = $output;
		}
	}
	if(is_array($headers))
	{
		$data_array['home_page_status'] = $headers[0];
		$data_array['home_page_url'] = "http://" . $url;
		$data_array['redirect_url'] = $rurl;
		if(strtolower($rurl) == strtolower($furl))
			$furl = "";
		$data_array['redirect_last_url'] = mb_substr($furl, 0, 119);
		$data_array['home_page_header'] = mb_substr($header, 0, 254);
		$data_array['home_page_title'] = trim(get_string_between($body, "<title>", "</title>", false));
		$data_array['home_page_size'] = mb_strlen($body);
		
		$data_array['page_token_found'] = NULL;
		if($page_token != "")
		{
			$match = stristr($body, $page_token);
			if($match !== false)
				$data_array['page_token_found'] = 1;
			else
				$data_array['page_token_found'] = 0;
		}
		if(function_exists("sedf_process_html_page"))
		{
			sedf_process_html_page($domain, $body, $data_array, $pdo);
		}
	}
	$data_array['home_page_checked_at'] = date("Y-m-d H:i:s");
	
	if(is_array($data_array))
	{
		update_domain_table($data_array, $domain);
		if($spit_out)
			debug_out_domain_data($data_array);
	}
}

###############################################################################

function get_http_header_body($url, &$header, &$body)
{
	$content = "";
	
	if(strpos($url, "http://") === false && strpos($url, "https://") === false)
		$url = "http://" . $url;
	$host = parse_url($url, PHP_URL_HOST);
	$path = parse_url($url, PHP_URL_PATH);
	$fp = fsockopen($host, 80, $errno, $errstr, 20);
	if ($fp) 
	{
		$out = "GET /$path HTTP/1.1\r\n";
		$out .= "Host: " . $host . "\r\n";
		$out .= "Connection: Close\r\n\r\n";
		fwrite($fp, $out);
		while (!feof($fp)) 
		{
			$content .= fgets($fp, 128);
		}
		fclose($fp);
	}
		
	$hunks = explode("\r\n\r\n",trim($content));
	if (is_array($hunks) && count($hunks) >= 1) 
	{
		$header  = $hunks[0];
		$hunks[0] = "";
		$body    = implode("\r\n", $hunks);
		return true;
	}
	return false;
}

###############################################################################

function get_redirect_url_from_header($headers) 
{ 
	$url = "";
    $array = $headers; 
    $count = count($array); 
    for ($i=0; $i < $count; $i++) 
    { 
		$pos = strpos($array[$i], "ocation:");
        if($pos !== false) 
                $url = trim(substr($array[$i], $pos+8));  
    } 
    return $url; 
} 

###############################################################################

function get_ping_response($domain, $subdomain="www")
{
	$host = idn_convert_to_host_name($domain, $subdomain);
	$url  = $host;
	
    $starttime = microtime(true);
    $file      = fsockopen ($url, 80, $errno, $errstr, 10);
    $stoptime  = microtime(true);
    $status    = 0;
    if (!$file) $status = -1;  // Site is down
    else 
	{
        fclose($file);
        $status = ($stoptime - $starttime) * 1000;
        $status = floor($status);
    }
	
	$data_array['ping_time'] = $status;
	$data_array['ping_checked_at'] = date("Y-m-d H:i:s");
	if(is_array($data_array))
		update_domain_table($data_array, $domain);
    return $status;
}

###############################################################################
?>
