<?php
###############################################################################
# googlepr.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

function ConvertStrToInt($Str, $Check, $Magic)
{
    $Int32Unit = 4294967296;  // 2^32
    $length = strlen($Str);
    for ($i = 0; $i < $length; $i++) 
	{
        $Check *= $Magic; 	
        if ($Check >= $Int32Unit) 
            $Check = ($Check - $Int32Unit * (int) ($Check / $Int32Unit));
        $Check += ord($Str{$i}); 
    }
    return $Check;
}

###############################################################################

function HashURL($String)
{
    $Check1 = ConvertStrToInt($String, 0x1505, 0x21);
    $Check2 = ConvertStrToInt($String, 0, 0x1003F);

    $Check1 >>= 2; 	
    $Check1 = (($Check1 >> 4) & 0x3FFFFC0 ) | ($Check1 & 0x3F);
    $Check1 = (($Check1 >> 4) & 0x3FFC00 ) | ($Check1 & 0x3FF);
    $Check1 = (($Check1 >> 4) & 0x3C000 ) | ($Check1 & 0x3FFF);	
	
    $T1 = (((($Check1 & 0x3C0) << 4) | ($Check1 & 0x3C)) <<2 ) | ($Check2 & 0xF0F );
    $T2 = (((($Check1 & 0xFFFFC000) << 4) | ($Check1 & 0x3C00)) << 0xA) | ($Check2 & 0xF0F0000 );
	
    return ($T1 | $T2);
}

###############################################################################

function CheckHash($Hashnum)
{
    $CheckByte = 0;
    $Flag = false;

    $HashStr = sprintf('%u', $Hashnum) ;
    $length = strlen($HashStr);
	
    for ($i = $length - 1;  $i >= 0;  $i --) 
	{
        $Re = $HashStr{$i};
        if ($Flag) {              
            $Re += $Re;     
            $Re = (int)($Re / 10) + ($Re % 10);
        }
        $CheckByte += $Re;
        $Flag = !$Flag;	
    }

    $CheckByte %= 10;
    if (0 !== $CheckByte) {
        $CheckByte = 10 - $CheckByte;
        if ($Flag) {
            if (1 === ($CheckByte % 2)) {
                $CheckByte += 9;
            }
            $CheckByte >>= 1;
        }
    }

    return '7'.$CheckByte.$HashStr;
}

###############################################################################

function getPageRank($url)
{
	$pagerank = -1;
	$ch = CheckHash(HashURL($url)); 
	$fp = fsockopen("toolbarqueries.google.com", 80, $errno, $errstr, 30);
	if($fp)
	{
		$out = "GET /tbr?client=navclient-auto&ch=" . $ch .  "&features=Rank&q=info:" . $url . " HTTP/1.1\r\n";
		$out .= "User-Agent: Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\r\n";
		$out .= "Host: toolbarqueries.google.com\r\n";
		$out .= "Connection: Close\r\n\r\n";
		fwrite($fp, $out);
		while (!feof($fp))
		{
			$data = fgets($fp, 128);
			$pos = strpos($data, "Rank_");
			if($pos === false)
			{
			}
			else
				$pagerank = substr($data, $pos + 9);
		}
		fclose($fp);
	}
	return $pagerank;
}

###############################################################################

function get_google_pr($domain, $subdomain="www")
{
	$host = idn_convert_to_host_name($domain, $subdomain);
	
	$url  = "http://" . $host;
	
	$pr = getPageRank($url);
	
	$data_array['google_pr_checked_at'] = date("Y-m-d H:i:s");
	$data_array['google_pr'] = $pr;
	if(is_array($data_array))
		update_domain_table($data_array, $domain);
	if(isDataHistoryEnabled("gpr"))
	{
		$pdo = init_db();
		if($pdo !== false)
			$pdo->updateDataHistory($domain,intval(LOOKUP_GOOGLE_PR), $pr);
	}
}

###############################################################################
?>
