<?php
###############################################################################
# dns.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

function do_ip_lookup($domain, $subdomain="www")
{
	$host = idn_convert_to_host_name($domain, $subdomain);
	
	$iplong = -1;
	$ip = gethostbyname($host);
	if($ip != $host)
	{
		$data_array['ip'] = $ip;
		$iplong = ip2long($ip);
		do_ip_asn_lookup($ip, $data_array);
	}
	else
		$data_array['ip'] = "error";
	$data_array['ip_checked_at'] = date("Y-m-d H:i:s");
	update_domain_table($data_array, $domain);
	if(isDataHistoryEnabled("ip"))
	{
		$pdo = init_db();
		if($pdo !== false)
			$pdo->updateDataHistory($domain,intval(LOOKUP_IP_ADDRESS), $iplong);
	}
		
	$do_dns_record_lookup = getConfigdata('do_dns_record_lookup', null);
	if($do_dns_record_lookup)
		do_root_dns_record_check($domain);
}

###############################################################################

function get_dns_record_for_type($hostname, $type, &$ip)
{
	$data_array = Array();
	$r = dns_get_record($hostname, $type);
	if(is_array($r))
	{
		foreach($r as $record)
		{
			if(isset($record['host']))
			{
				if($record['host'] == $hostname)
				{
					if(isset($record['ttl']))
						$data_array['ttl'] = $record['ttl'];
					if(isset($record['type']))
					{
						$data_array['record_type'] = $record['type'];
						if($record['type'] == "CNAME")
						{
							if(isset($record['target']))
								$data_array['record_value'] = $record['target'];
						}
						if($record['type'] == "A")
						{
							if(isset($record['ip']))
							{
								$data_array['record_value'] = $record['ip'];
								$data_array['ip'] = $record['ip'];
							}
						}
					}
					break;
				}
				if($record['type'] == "A" && $type = DNS_A)
				{
					if(isset($record['ip']))
						$ip = $record['ip'];
				}
			}
		}
	}
	return $data_array;
}
 
###############################################################################

function do_subdomain_lookup($domain, $spit_out=false)
{
	$pdo = init_db();
	if($pdo !== false)
	{
		$do_subdomain_ext_lookup = getConfigdata('do_subdomain_ext_lookup', null);
		if($do_subdomain_ext_lookup)
			doSubdomainExtendedLookup($domain, $spit_out);
		
		$sid = $pdo->getSingleEntry($pdo->getDomainTableName(), "domain", $domain, "sid"); 
		if($sid !== false && $sid > 0)
		{
			$sdinfo = $pdo->getTableData($pdo->getSubdomainTableName(), "hid,subdomain,record_type,record_value,ip", "where sid = $sid");
			if($sdinfo !== false && is_array($sdinfo)) 
			{
				foreach($sdinfo as $sdi)
				{
					$host = $sdi['subdomain'];
					$type = $sdi['record_type'];
					$target = $sdi['record_value'];
					$ip = $sdi['ip'];
					$hid = $sdi['hid'];
					do_hostname_dns_lookup($host, $domain, $type, $target, $ip, $hid, $spit_out);
				}
				return true;
			}
		}
	}
	return false;
}

###############################################################################

function do_hostname_dns_lookup($host, $domain, $type, $target, $ip, $hid, $spit_out=false)
{
	if(($type == "TXT") || (mb_strlen($host) > 1 && $type == "MX"))
		return;

	$subdomain = $host;
	$hostname = "";
	if($subdomain == "@")
	{
		if($type == "NS")
			$hostname = idn_convert_to_host_name($target, "");
		else if($type == "MX")
		{
			$parts = explode(" ", $target);
			if(count($parts) == 2)
				$hostname = idn_convert_to_host_name($parts[1], "");
		}
		else
			$subdomain = "";
	}
		
	$data_array = Array();
	if(($host != "" && $host != "@") || $type == "NS" || $type == "MX")
	{
		if($type != "NS" && $type != "MX")
			$hostname = idn_convert_to_host_name($domain, $subdomain);
		
		$ipa = "";
		$ipc = "";
		$r = get_dns_record_for_type($hostname, DNS_A, $ipa);
		if(!count($r))
		{
			$r = get_dns_record_for_type($hostname, DNS_CNAME, $ipc);
		}
		if(count($r))
		{
			if($ipa != "")
				$r['ip'] = $ipa;
			if(isset($r['ip']))
			{
				$data_array['ip'] = $r['ip'];
				$revptr = gethostbyaddr($r['ip']);
				if($revptr != $r['ip'])
					$data_array['ptr'] = $revptr;
			}
			if(isset($r['record_type']) && $host != "@")
				$data_array['record_type'] = $r['record_type'];
			if(isset($r['record_value']) && $host != "@")
				$data_array['record_value'] = $r['record_value'];
			if(isset($r['ttl']) && $host != "@")
				$data_array['ttl'] = $r['ttl'];
		}
		if($spit_out)
			debugPrintArray($r);
	}
	else if(($host == "" || $host == "@") && ($type == "A" || $type == "") && ($ip != "" && $ip != "error"))
	{
		$revptr = gethostbyaddr($ip);
		if($revptr != $ip)
			$data_array['ptr'] = $revptr;
	}
	if(count($data_array))
	{
		$data_array['id' ] = $hid;
		update_subdomain_table($data_array, $host, $domain);
		
		$domain_data['dns_checked_at'] = date("Y-m-d H:i:s");
		update_domain_table($domain_data, $domain);
		
		if($spit_out)
			debugPrintArray($data_array);
	}
}

###############################################################################

function doSubdomainExtendedLookup($domain, $spit_out=false)
{
	$pdo = init_db();
	if($pdo === false)
		return false;
	
	$sid = $pdo->getSingleEntry($pdo->getDomainTableName(), "domain", $domain, "sid"); 
	$added = 0;
	if($sid !== false && $sid > 0)
	{
		$sdinfo = $pdo->getTableData($pdo->getSubdomainTableName(), "hid,subdomain,record_type,record_value,ip", "where sid = $sid AND (auto_added = 0 OR auto_added IS NULL)");
		if($sdinfo !== false && is_array($sdinfo)) 
		{
			foreach($sdinfo as $sdi)
			{
				$host = $sdi['subdomain'];
				if(mb_strlen($host) > 1)
				{
					$delcl = "subdomain=? AND sid=? AND (record_type='MX' OR record_type='TXT') AND auto_added=1";
					if($pdo->deleteFromTable($pdo->getSubdomainTableName(), $delcl, array($host,$sid)) !== false)
					{
						$hostname = "$host.$domain";
						if($spit_out)
							debugEcho($hostname);
						$rmx = dns_get_record($hostname, DNS_MX);
						$rtxt = dns_get_record($hostname, DNS_TXT);
						$rdata = array_merge($rmx, $rtxt);
						foreach($rdata as $r)
						{
							$data_array = array();
							$data_array['subdomain'] = $host;
							if(isset($r['type']))
							{
								if($r['type'] == "MX")
								{
									if(isset($r['pri']) && isset($r['target']))
									{
										$data_array['record_value'] = $r['pri'] . " " . $r['target'];
									
										$ipa = "";
										$ipc = "";
										$ri = get_dns_record_for_type($r['target'], DNS_A, $ipa);
										if(!count($ri))
											$ri = get_dns_record_for_type($r['target'], DNS_CNAME, $ipc);
										if(count($ri))
										{
											if($ipa != "")
												$ri['ip'] = $ipa;
											if(isset($ri['ip']))
											{
												$data_array['ip'] = $ri['ip'];
												$revptr = gethostbyaddr($ri['ip']);
												if($revptr != $ri['ip'])
													$data_array['ptr'] = $revptr;
											}
										}
									}
								}
								else if($r['type'] == "TXT")
								{
									if(isset($r['txt']))
										$data_array['record_value'] = substr($r['txt'], 0, 254);
								}
								if(isset($r['ttl']))
									$data_array['ttl'] = $r['ttl'];
								
								$data_array['auto_added'] = 1;
								$data_array['record_type'] = $r['type'];
							}
							
							$data_array['added_on'] = date("Y-m-d H:i:s");
							$data_array['sid'] = $sid;
							if($spit_out)
								debugPrintArray($data_array);
							$hid = $pdo->insertIntoTable($pdo->getSubdomainTableName(), $data_array, "hid");
							if($hid !== false)
								$added++;
							unset($data_array);
						}
					}
				}
			}
		}
	}
	return $added;
}

###############################################################################

function do_root_dns_record_check($domain, $spit_out=false)
{
	$pdo = init_db();
	if($pdo === false)
		return false;
	
	$sid = $pdo->getSingleEntry($pdo->getDomainTableName(), "domain", $domain, "sid"); 
	if($sid === false || $sid == 0)
		return false;
	
	$hostname = idn_convert_to_host_name($domain, "");
	
	$rns = dns_get_record($hostname, DNS_NS);
	$ra = dns_get_record($hostname, DNS_A);
	$rmx = dns_get_record($hostname, DNS_MX);
	$rtxt = dns_get_record($hostname, DNS_TXT);
	if(function_exists("sedf_after_dns_record_check"))
	{
		sedf_after_dns_record_check($domain,$rns, "ns", $spit_out);
		sedf_after_dns_record_check($domain,$ra, "a", $spit_out);
		sedf_after_dns_record_check($domain,$rmx, "mx", $spit_out);
		sedf_after_dns_record_check($domain,$rtxt, "txt", $spit_out);
	}
	$r = array_merge($ra, $rns);
	$r = array_merge($r, $rmx);
	$r = array_merge($r, $rtxt);
	
	if(is_array($r))
	{
		$result = $pdo->deleteFromTable($pdo->getSubdomainTableName(), "auto_added=? AND sid=?", array(1, $sid));
		
		$index = 0;
		foreach($r as $record)
		{
			$data_array = Array();
			$type = "";
			$target = "";
			$ttl = "";
			$pri = "";
			$ip = "";
			$host = "";
			if(isset($record['type']))
				$type = $record['type'];
			if(isset($record['ttl']))
				$ttl = $record['ttl'];
			if(isset($record['pri']))
				$pri = $record['pri'];
			if(isset($record['target']))
				$target = $record['target'];
			if(isset($record['ip']))
				$ip = $record['ip'];
			if(isset($record['host']))
				$host = $record['host'];
			if(isset($record['txt']))
			{
				$txtval = $record['txt'];
				if(mb_strlen($txtval) > 254)
					$txtval = substr($txtval, 0, 254);
			}
			if($type == "NS" || $type == "MX" || $type == "CNAME" || $type == "A" || $type == "TXT")
			{
				$data_array['auto_added'] = 1;
				$data_array['record_type'] = $type;
				$data_array['ttl'] = $ttl;
				if($type == "NS" || $type == "MX")
				{
					if($type == "MX")
						$data_array['record_value'] = $pri . " " . $target;
					else
						$data_array['record_value'] = $target;
				}
				else if($type == "A")
				{
					$data_array['ip'] = $ip;
					$data_array['record_value'] = $ip;
				}
				else if($type == "CNAME")
					$data_array['record_value'] = $target;
				else if($type == "TXT")
					$data_array['record_value'] = $txtval;
					
				$sddata = array('subdomain'=>'@', 'added_on'=>date("Y-m-d H:i:s"), 'sid'=>$sid);
				$hid = $pdo->insertIntoTable($pdo->getSubdomainTableName(), $sddata, "hid");
				if($hid > 0 && $hid !== false)
				{
					$data_array['id'] = $hid;
					update_subdomain_table($data_array, "@", $domain);
				}
				if($spit_out)
				{
					echo "<pre>";
					print_r($data_array);
				}
			}	
			unset($data_array);
		}
				
		if($spit_out)
			print_r($r);
	}
}

###############################################################################

function do_ip_asn_lookup($ip, &$data_array)
{
	$blocks = explode('.', trim($ip));
	if(is_array($blocks))
	{
		if(count($blocks) == 4)
		{
			$host = $blocks[3] . "." . $blocks[2] . "." . $blocks[1] . "." . $blocks[0] . ".origin.asn.cymru.com";
			$result = dns_get_record($host , DNS_TXT);
			if(isset($result[0]['txt']))
			{
				$entries = $result[0]['txt']; 
				$blocks = explode('|', $entries);
				if(is_array($blocks))
				{
					$asnum = "AS" . trim($blocks[0]);
					$data_array['ip_asnumber'] = $asnum;
					$result = dns_get_record($asnum . ".asn.cymru.com", DNS_TXT);
					if(isset($result[0]['txt']))
					{
						$blocks = explode("|", $result[0]['txt']); 
						$count = count($blocks);
						$asname = trim($blocks[$count-1]);
						$dashpos = strpos($asname, " - ");
						if($dashpos > 0)
						{
							$asname = substr($asname, 0, $dashpos);
						}
						$data_array['ip_asname'] = $asname;
					}	
				}
			}
		}
	}
}

###############################################################################
?>
