<?php
#########################################################################################
# idn.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
#########################################################################################

require_once('idna_convert.class.php');

#########################################################################################

function idn_convert($domain)
{
	$IDN = new idna_convert(array('idn_version' => 2008));
	return strtolower($IDN->encode($domain)); 
}

#########################################################################################

function idn_reconvert($ascii_domain)
{
	$IDN = new idna_convert(array('idn_version' => 2008));
	return $IDN->decode($ascii_domain); 
}

#########################################################################################

function idn_convert_to_host_name($domain, $subdomain)
{
	$ascii_domain    = idn_convert($domain);
	$ascii_subdomain = idn_convert($subdomain);
	return ($subdomain == "" ? "" : ($ascii_subdomain . ".")) . $ascii_domain; 
}

#########################################################################################

