<?php
#########################################################################################################
#  version-check-sample.php
#
#  Copyright (C) Softnik Technologies. All rights reserved.
#
#  Sample PHP script that compares the versions of master installation and local installation and 
#  triggers a shell script if the local version is older.
#
#  Useful in Professional Edition installations that have a master DB server and a number of secondary
#  servers. You can edit and use this script to auto-update the secondary installations.
#
#########################################################################################################

# Please edit below if you move this script to a different folder.

require_once(dirname(__FILE__) . "/../basic.php");
require_once(dirname(__FILE__) . "/../config.check.php");
require_once(dirname(__FILE__) . "/../version.php");
require_once(dirname(__FILE__) . "/../pdo/dbinit.php");

#########################################################################################################
# Parse command line if running in CLI

if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

#########################################################################################################

loginIfRequired(true); // Admin privileges required.

#########################################################################################################

$pdo = init_db(false);
if($pdo === false)
{
	echo "<p>Unable to connect to database</p>";
	exit;
}

#########################################################################################################

$this_version = get_build_index();
$master_version = $pdo->getSingleEntry($pdo->getInstalledServersTableName(), "name", "master", "ver_index");

if(is_cli())
{
	echo "This Version: $this_version.\n";
	echo "Master Version: $master_version.\n";
}
else
{
	echo "<p>This Version: $this_version.</p>";
	echo "<p>Master Version: $master_version.</p>";
}

if($master_version !== false && $master_version > $this_version)
	shell_exec("script_path_to_run");   # Example:  shell_exec("/usr/home/wmdsed/update.sh");

#########################################################################################################
?>
