<?php
#########################################################################################################
#
# Some useful functions for reports
#
#########################################################################################################

function colorCodeExpiryRows($rowhtml, $rowdata)
{
	if(isset($rowdata['expiry_days']))
	{
		$expiry_days = $rowdata['expiry_days'];
		if($expiry_days < 0)
			return "<tr class=\"lesszero\">$rowhtml</tr>\n";
		else if($expiry_days < 30)
			return "<tr class=\"less30\">$rowhtml</tr>\n";
		else if($expiry_days < 45)
			return "<tr class=\"less45\">$rowhtml</tr>\n";
		else if($expiry_days < 60)
			return "<tr class=\"less60\">$rowhtml</tr>\n";
		else if($expiry_days < 90)
			return "<tr class=\"less90\">$rowhtml</tr>\n";
	}
	return "<tr>$rowhtml</tr>\n";
}

#########################################################################################################

function saveReportFile($savefolder, $reportprefix, &$savepath, $message)
{
	if(strstr($savefolder, DIRECTORY_SEPARATOR) === false)
	{
		$basefolder = get_install_folder_path();
		$basefolder .= $savefolder;
		$savefolder = $basefolder;
	}
	if(substr($savefolder, -1) != DIRECTORY_SEPARATOR)
		$savefolder .= DIRECTORY_SEPARATOR;
	$savepath = $savefolder . "$reportprefix-" . date("Y-m-d") . ".htm";  
	$findex = 1;
	while(is_file($savepath) && $findex < 20)
	{
		$savepath = $savefolder . "$reportprefix-" . date("Y-m-d") . "-$findex" . ".htm";  
		$findex++;
	}
	if(file_put_contents($savepath, $message) === false)
		return false;
	return true;
}

###############################################################################

function getSimpleFooterForReports($subject)
{
	return "<p class=\"footer\"><a href=\"" . get_install_url_path() . "\" target=\"_blank\">$subject</a> " . get_version() . ", Build: " . get_build_date() . "</p>";
}

###############################################################################
?>