<?php
#########################################################################################################
#  custom-processing-sample.php
#
#  Various code for custom processing and display of data.
#
#  Copyright (C) Softnik Technologies. All rights reserved.
#
#  Remember to copy and or rename this file before making changes. This will protect your modifications 
#  from getting over-written. The best place to keep custom scripts is the 'lib/php/custom/' folder.
#
#  Include the path to your version of this file at the end of config.php
#  For example,
#  require_once('lib/php/custom/custom-processing.php');
#########################################################################################################
#
# Code for custom formatting the details tab (sedf_format_domain_details)
#
# Input ($domaindata) is an array containing the data for each domain column.
# $pdo is the database instance. Use it to access additional data from the DB
#
# The output is the HTML you wish to display in the 'Details' tab.
#
# Use this if you want to display only selected columns, show the data in a  different sort order or 
# wish to display data in a completely different visual format. You can even display additional data 
# by accessing the database and then adding the information to the output.

function sedf_format_domain_details($domaindata, $pdo)
{
	$customcolumns = $pdo->getCustomColumns();
	$retdata = "<table class=\"dataviewtable\">\n";
	
	# Sort column names (alpha)
	ksort($domaindata);
	
	foreach($domaindata as $column => $info)
	{
		if($column != 'registry_whois' && $column != 'registrar_whois' && $column != 'ip_whois' && $column != 'whois_history')
		{
			if($pdo->getColumnLabelAndWidthForDomain($column, $label, $width) === false)
				$label = getLabelFromFieldName($column);
			if(in_array($column, $customcolumns) === true)
				$label = "$label &#9732";
					
			$retdata .= "<tr><td class=\"column\">$label</td><td class=\"value\"><div class=\"dtabv dtabv-$column\">$info</div></td></tr>\n";
			# Define .dtabv and .dtabv-{column} in your custom CSS 
			# file to style the individual columns in the table.
		}
	}		
	$retdata .= "</table>\n";
	return $retdata;
}

#########################################################################################################

#
#
# Code for custom processing the home page HTML (sedf_process_html_page)
#
# $domain is the domain name. $htmltext is the web page content
# $data_array is an array containg the already extracted data. For example, 
# $data_array['home_page_status'], $data_array['home_page_title'], etc.
# $pdo is the database instance. Use it to access additional data from the DB

function sedf_process_html_page($domain, $htmltext, &$data_array, $pdo)
{
	# Parse the $htmltext and insert any data into $data_array. For example, if you have a custom column
	# called 'wordpress_version' you can insert that into $data_array['wordpress_version'] after
	# parsing the $htmltext.
	
	# Example: Parse for Google Site Verification code. This is just a simple example and
	# will work only if the meta tag is inserted in a specific way. If you are implementing it
	# some extra code will be required to cover all cases.
	
	# A custom column called google_site_verification should be created for this data to appear
	# in the domain table.
	
	$data_array['google_site_verification'] = get_string_between($htmltext, "<meta name=\"google-site-verification\" content=\"", "\">", false);
}

#########################################################################################################

?>
