<?php
#########################################################################################################
#  custom-dns-monitor-sample.php
#
#  Copyright (C) Softnik Technologies. All rights reserved.
#
#  Use this for monitoring DNS record changes.
#  Remember to copy and or rename this file before making changes. This will protect your modifications 
#  from getting over-written. The best place to keep custom scripts is the 'lib/php/custom/' folder.
#
#  If you want an email alert, edit the recipient details and set $doemail to true.
#
#  Include the path to your version of this file at the end of config.php
#  For example,
#  require_once('lib/php/custom/custom-dns-monitor.php');
#########################################################################################################

function sedf_after_dns_record_check($domain, &$data_array, $recordtype, $spit_out=false)
{
	// Edit the Email Recipients
	$doemail = false;
	if($doemail)
		$recipients = array('person1@example.com' => 'Person One');
	else
		$recipients = array();
	
	$pdo = init_db();
	if($pdo !== false)
	{
		$sid = $pdo->getSingleEntry($pdo->getDomainTableName(), "domain", $domain, "sid"); 
		$old_data = $pdo->getTableData($pdo->getSubdomainTableName(), "record_value", "WHERE auto_added=? AND sid=? AND record_type=? AND subdomain='@'", array(1, $sid, $recordtype));
		$new_data = array();
		foreach($data_array as $dnsdata)
		{
			if(isset($dnsdata['ip']) && strtolower($recordtype) == "a")
				$new_data[] = $dnsdata['ip'];
			else if(isset($dnsdata['txt']) && strtolower($recordtype) == "txt")
				$new_data[] = $dnsdata['txt'];
			else if(isset($dnsdata['target']) && strtolower($recordtype) == "mx")
			{
				$mx = $dnsdata['target'];
				if(isset($dnsdata['pri']))
					$mx = $dnsdata['pri'] . " " . $mx; 
				$new_data[] = $mx;
			}
			else if(isset($dnsdata['target']))
				$new_data[] = $dnsdata['target'];
		}
		$logs = sedf_data_array_monitor($pdo, $domain, $old_data, $new_data, strtoupper($recordtype), $recipients);
		if($spit_out)
		{
			smartEcho($domain . ", " . $recordtype, "Domain & Type");
			printArray($old_data);
			printArray($new_data);
			if(count($logs))
				printArray($logs);
			else
				smartEcho("No Alerts");
			smartEcho("<hr>");
		}
	}
}

#########################################################################################################

function sedf_data_array_monitor($pdo, $domain, $old_data, $new_data, $recordtype, $recipients)
{
	$logs = array();
	$todelete = array();
	foreach($old_data as $value)
	{
		if(in_array($value, $new_data))
			$todelete[] = $value;
	}
	$new_data = array_values(array_filter(array_diff($new_data, $todelete)));
	$old_data = array_values(array_filter(array_diff($old_data, $todelete)));
	if(count($old_data))
		$logs[] = "DNSAlert: $recordtype Record(s) " . implode($old_data, ",") . " deleted for $domain";
	if(count($new_data))
		$logs[] = "DNSAlert: $recordtype Record(s) " . implode($new_data, ",") . " added for $domain";
	if(count($logs))
	{
		foreach($logs as $log)
			$pdo->logAuditEntry(AUDIT_DNS_ROOT_RECORD_CHANGE, $log);
		if(count($recipients))
		{
			$message = "<html>\n";
			$message .= "<p>" . date("d-M-Y h:i:s") . "</p>\n";
			foreach($logs as $log)
				$message .= "<p>$log</p>\n";
			$message .= "</html>";
			$emailsubject = "DNS Records Alert";
			require_once(dirname(__FILE__) . "/../mailer.inc.php");
			$estatus = send_email($message, $emailsubject, $recipients);
			if($estatus === false)
			{
				$emailto = "";
				foreach($recipients as $e=>$n)
					$emailto .= $e + ", ";
				$emailto = trim($emailto, ",");
				$pdo->logAuditEntry(AUDIT_EMAIL_ATTEMPT_FAILED, "Unable to email $emailto");
			}
		}
	}
	return $logs;
}

#########################################################################################################
?>
