<?php
#########################################################################################################
#  category-report-sample.php
#
#  Copyright (C) Softnik Technologies. All rights reserved.
#
#  Use this for generating email alerts.
#  You can use this in your crontab to generate daily/weekly/monthly domain expiry reports.
#  Remember to copy and or rename this file before making changes. This will protect your modifications 
#  from getting over-written. The best place to keep custom scripts is the 'lib/php/custom/' folder.
#
#  Before using this
#  -----------------
#  The script will require that you login if you have password protected the application. However this
#  will be a problem when running this script as a cronjob from a remote server. To fix this we 
#  use the 'CLI Authorization Key'. The 'CLI Authorization Key' is a unique string / password you set  
#  from the 'Application Settings > Authentication' tab.
#  After you have specified the key, use it in your cron entry as follows.
#
#  wget http://server/path/category-report.php?key=xxxxxx
#
#  The CLI key is not required if you are running this as a PHP command line application.
#
#  You can set your email preferences in 'Application Settings > Email' tab.
#########################################################################################################

# Specify email address, columns to show, etc.

$recipients = array(
   'person1@example.com' => 'Person One',
   # Add more if you want to...
);

$emailsubject = "Domain Category Report";

$sendemail    = false;  
$screendump   = true;   
 
$categoryname = "Business Domains";	# The category to report on

$savefolder   = ""; 		# Specify a "writable" folder path if you want to save the report to disk.
$reportprefix = "expiry";   # File name prefix added to the report.

$columns      = "domain,registry_expiry,registrar_expiry,lookedup,status";

$showdays     = true;   	# Show days left for expiry (in addition to actual dates)
$expirydays   = 90;
$sorton       = "registry_expiry";	# Default column for sorting.

$htmlheadfile = "reports-htmlhead-sample.htm";

$header       = "$emailsubject ($categoryname)";

$footer       = "";			# may contain simple HTML

#########################################################################################################
# You probably won't need to edit below this line, unless you want to modify the data display formating.
#########################################################################################################

require_once(dirname(__FILE__) . "/../basic.php");
require_once(dirname(__FILE__) . "/../config.check.php");
require_once(dirname(__FILE__) . "/../version.php");
require_once(dirname(__FILE__) . "/../mailer.inc.php");
require_once(dirname(__FILE__) . "/../pdo/dbinit.php");
require_once(dirname(__FILE__) . "/reports.helper.php");

#########################################################################################################
# Parse command line if running in CLI

if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

#########################################################################################################

loginIfRequired(true);

#########################################################################################################

$pdo = init_db(false);
if($pdo === false)
{
	echo "<p>Unable to connect to database</p>";
	exit;
}

#########################################################################################################

$required = array("registrar_expiry", "registry_expiry", "domain");
$cattabname = $pdo->getCategoryTableName();
$categoryid = $pdo->getSingleEntry($cattabname, "CategoryName", $categoryname, "CategoryID");
$domtable   = $pdo->getDomainTableName();
$cattable   = $pdo->getCategoryIDToDomainIDTableName();

if($categoryid === false)
{
	echo "No such category ($categoryname)";
	exit;
}

#########################################################################################################

# First make sure that the required columns are present
$colarray = explode(",", strtolower($columns));
foreach($required as $entry)
{
	if(!in_array($entry, $colarray))
		array_unshift($colarray, $entry);
}
$validcolumns = $pdo->getAllColumnNames($pdo->getDomainTableName());

# Get the corresponding on-screen label for each column and also remove incorrect columns.
$select = "";
$fields = array();
$labels = array();
foreach($colarray as $c)
{
	if(in_array($c, $validcolumns))
	{
		$select .= " $c,";
		$fields[] = $c;
		if($pdo->getColumnLabelAndWidthForDomain($c, $label, $width) !== false)
			$labels[] = $label;
		else
			$labels[] = getLabelFromFieldName($c);
	}
}
$select = trim($select, " ,");

$query = "SELECT DISTINCT a.sid,$select FROM $domtable a, $cattable b WHERE (b.CategoryID = $categoryid AND b.sid = a.sid) ORDER BY $sorton ASC";

# execute the query.
$dinfo = array();
try
{
	$stmt = $pdo->db_connect_handle->prepare($query);
	$stmt->execute($data);
	$tdata = $stmt->fetchAll($fmode);
	if(is_array($tdata))
	{
		$dinfo = array('data'=>$tdata, 'columns'=>$labels, 'fields'=>$fields);
	}
}
catch (PDOException $e) 
{
	$pdo->setError($e->getMessage());
}
		
if(count($dinfo))
{
	if($showdays)
	{
		$dinfo['data'] = $pdo->insertDaysToExpireIntoArray($dinfo['data']);
		$dinfo['columns'][] = "Days";
		$dinfo['fields'][] = "expiry_days";
		$sorton = "expiry_days";
	}
	$tablehtml = $pdo->convertToTable($dinfo, $sorton, "domaintable", "colorCodeExpiryRows");
	
	$message  = "<html>\n" . file_get_contents(get_install_folder_path() . "lib/php/custom/" . $htmlheadfile);
	$message .= "<h1 class=\"header\">$header</h1>\n";
	$message .= $tablehtml;
	if($footer == "")
		$footer = getSimpleFooterForReports($emailsubject);
	$message .= $footer . "\n" . "</body>\n</html>\n";
	
	if($screendump)
		echo($message);
	else
		echo "<p>On-screen display is disabled in the script. Open in a text editor and enable if you want to see the report on screen.</p>";
	
	if($sendemail)
	{
		$estatus = send_email($message, $emailsubject, $recipients);
		if($estatus !== true)
			echo "<p>Email was not sent.</p>";
		else
			echo "<p>Email was sent.</p>";
	}
	else
		echo "<p class=\"infomsg\">Emailing is disabled in the script. Open in a text editor and enable the email option.</p>";
	
	#########################################################################################################

	if($savefolder != "")
	{
		if(!saveReportFile($savefolder, $reportprefix, $filename, $message))
			echo "<p>File was not saved.</p>";
		else
			echo "<p>File saved to $filename.</p>";
	}
}

#########################################################################################################

?>
