<?php
###############################################################################
# loadconfig.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

if(isset($_REQUEST['debug']))
{
	ini_set("display_errors", "1");
	error_reporting(E_ALL);
}
else
	error_reporting( E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED & ~E_WARNING);

ini_set("auto_detect_line_endings", true);

###############################################################################

session_start();

###############################################################################

function isProConfigFile()
{
	$proConfigFile = get_install_folder_path() . "lib/php/config/loadconfig.inc.php";
	if(file_exists($proConfigFile))
		return true;
	else
		return false;
}

###############################################################################

$proConfigFile = get_install_folder_path() . "lib/php/config/loadconfig.inc.php";
$stdConfigFile = get_install_folder_path() . "lib/php/config/loadconfig.8353.php";
$ioncubeVersionSourceInUse = "";

###############################################################################

setStdConfigFile();

###############################################################################

function setStdConfigFile()
{
	global $stdConfigFile;
	$phpver = phpversion();
	if(substr($phpver, 0, 2) == "7.")
	{
		if(intval(substr($phpver,2,1)) >= 1)
			$stdConfigFile = get_install_folder_path() . "lib/php/config/loadconfig.10071.php";
		else
			$stdConfigFile = get_install_folder_path() . "lib/php/config/loadconfig.9056.php";
	}
}

###############################################################################

if(file_exists($proConfigFile))
	require_once($proConfigFile);
else
{
	if(isIonCubeAvailable())
	{
		require_once($stdConfigFile);
		if(isset($_REQUEST['debug']))
		{
			$ivs = $stdConfigFile;
			$ivs = str_replace(".php", "", $ivs);
			$pos = strpos($ivs, "loadconfig.");
			if($pos !== false)
			{
				$ivs = substr($ivs, $pos+11);
				if(strlen($ivs) == 4)
					$ioncubeVersionSourceInUse = "Encoder: " . substr($ivs, 0, 1) . "." . substr($ivs, 1, 1) . ", PHP Source: " . substr($ivs, 2, 1) . "." . substr($ivs, 3, 1);
			}
		}
	}
	else
	{
		$thisapp = $_SERVER['PHP_SELF'];
		if(stristr($thisapp, "verify.php") === false)
			warn_and_quit_on_problems(true);
	}
}

###############################################################################
# This will check only ionCube and DB connection.

function warn_and_quit_on_problems($onlyioncube=false)
{
	$allok = true;
	$msg  = "<h3>We have a problem!</h3><hr>";
	
	if(!$onlyioncube)
	{
		if(init_db() === false)
		{
			$msg .= "<p>Unable to connect to database!</p><p>" . wmDomainDatabase::$last_init_error . "</p>";
			$allok = false;
		}
	}
	
	$sedpro = isProConfigFile();
	if($sedpro == false)
	{
		if(extension_loaded('ionCube Loader')) 
		{
			$ion_status = ioncube_loader_version_array();
			$ion_version = $ion_status['version'];
			if(($ion_status['major'] < 4) || ($ion_status['major'] == 4 && $ion_status['minor'] < 6))
			{
				$msg .= "<p>ionCube Loader v$ion_version installed, but Loader v4.6 or greater is required for demo and standard version installations.</p>";
				$allok = false;
			}
		}
		else
		{
			$msg .= "<p>ionCube Loader v4.6 or greater is required for demo and standard version installations. It was not found!</p>";
			$allok = false;
		}
	}
		
	if($allok == false)
	{
		if(is_cli())
			$msg .= "Please verify your installation. (run php /path/to/install/folder/verify.php)";
		else
			$msg .= "<hr><p><a class=\"btn btn-danger\" href=\"verify.php\">Verify your installation</a></p>";
		show_message($msg);
		exit;
	}
}

###############################################################################

function isIonCubeAvailable()
{
	if(extension_loaded('ionCube Loader')) 
	{
		$ion_status = ioncube_loader_version_array();
		$ion_version = $ion_status['version'];
		if($ion_status['major'] < 4)
			return false;
		return true;
	}
	else
		return false;
}


###############################################################################

function ioncube_loader_version_array () 
{
	// ioncube_loader_iversion is the newer function, use it if it is available.
	if ( function_exists('ioncube_loader_iversion') ) 
	{
		$ioncube_loader_iversion = ioncube_loader_iversion();
		if($ioncube_loader_iversion >= 100000)
		{
			// MMmmrr
			$ioncube_loader_version_major = (int)substr($ioncube_loader_iversion,0,2);
			$ioncube_loader_version_minor = (int)substr($ioncube_loader_iversion,2,2);
			$ioncube_loader_version_revision = (int)substr($ioncube_loader_iversion,4,2);
			$ioncube_loader_version = "$ioncube_loader_version_major.$ioncube_loader_version_minor.$ioncube_loader_version_revision";
		}
		else
		{
			// Mmmrr
			$ioncube_loader_version_major = (int)substr($ioncube_loader_iversion,0,1);
			$ioncube_loader_version_minor = (int)substr($ioncube_loader_iversion,1,2);
			$ioncube_loader_version_revision = (int)substr($ioncube_loader_iversion,3,2);
			$ioncube_loader_version = "$ioncube_loader_version_major.$ioncube_loader_version_minor.$ioncube_loader_version_revision";
		}
	} 
	else 
	{
		$ioncube_loader_version = ioncube_loader_version();
		$ioncube_loader_version_major = (int)substr($ioncube_loader_version,0,1);
		$ioncube_loader_version_minor = (int)substr($ioncube_loader_version,2,1);
	}
	return array('version'=>$ioncube_loader_version, 'major'=>$ioncube_loader_version_major, 'minor'=>$ioncube_loader_version_minor);
}

###############################################################################
?>