<?php
###############################################################################
# displaygroups.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

function initDisplayGroups()
{
	$dcfg = get_default_columns_for_groups();
	
	$pdo = init_db(false);
	if($pdo !== false)
	{
		$columns = $pdo->getDisplayColumns();
		if($columns !== false)
		{
			foreach($dcfg as $group => $entry)
			{
				$do_init = false;
				if(isset($columns[$group]) == false)
					$do_init = true;
				else if($columns[$group] == '')
					$do_init = true;
				if($do_init)
					$pdo->setDisplayColumns($group, $entry);
			}
		}
	}
}

###############################################################################

function getJSForAllDisplayGroups()
{	
	$columnjs = "";
	$date_format = get_config_data("cell_date_format");
	if($date_format === false)
		$date_format = "d-M-Y";
	
	$pdo = init_db(false);
	if($pdo !== false)
	{
		$dgroups = $pdo->getDisplayColumns();
		if($dgroups !== false)
		{
			foreach($dgroups as $group => $columns)
			{
				$columns = "r_h_disp;domain;" . $columns;
				$columnjs .= "\tvar $group = [\n";
				$columnjs .= getJSForDisplayGroup($columns, $date_format);
				$columnjs .= "\t];\n";
			}
			$columns = get_config_data('dns_subgrid_columns', null);
			$columns = "subdomain;" . $columns;
			$columnjs .= "\tvar subdomaingrid_columns_array = [\n";
			$columnjs .= getSubdomainColModel($columns, $date_format);
			$columnjs .= "\t];\n";
			$columns = get_config_data('ssl_subgrid_columns', null);
			$columns = "subdomain;" . $columns;
			$columnjs .= "\tvar sslgrid_columns_array = [\n";
			$columnjs .= getSubdomainColModel($columns, $date_format);
			$columnjs .= "\t];\n";
		}
	}
	return $columnjs;
}

###############################################################################

function getJSForSubdomainManager()
{	
	$columnjs = "";
	$date_format = get_config_data("cell_date_format");
	if($date_format === false)
		$date_format = "d-M-Y";
	
	$pdo = init_db(false);
	if($pdo !== false)
	{
		$columns = get_config_data('sub_domain_columns', null);
		$columns = "r_h_disp;subdomain;sid;" . $columns;
        $columnjs .= "\tvar subdomgrid_columns_array = [\n";
        $columnjs .= getSubdomainColModel($columns, $date_format);
        $columnjs .= "\t];\n";
	}
	return $columnjs;
}

###############################################################################

function getSubdomainColModel($entry, $dateformat)
{
	$datacolumns = "";
	$pdo = init_db(false);
	if($pdo !== false)
	{
		$builtInFields = $pdo->getDefaultColumnNames($pdo->getSubdomainTableName());
		$parts = explode(";", $entry);
		$j = 0;
		foreach($parts as $part)
		{
			$columns[0] = $part; // Label
			$columns[1] = mb_strtolower(trim($part)); // Field Name
			$columns[1] = str_replace(" ","_", $columns[1]);
			$columns[2] = $pdo->getDefaultWidthForSubdomainColumn($columns[1]);
			$columns[0] = getLabelFromFieldName($columns[0]);
			$status = $pdo->getColumnLabelAndWidthForSubdomain($columns[1], $columns[0], $columns[2]);
			if(count($columns) == 3 && $columns[1] != "")
			{
				$classname = strtolower($columns[1]);
				$classname = str_replace("_","-", $classname) . "-cell";
				
				if(strtolower($columns[1]) == "subdomain")
					$append = ",editable:true,editoptions:{readonly:true,size:35}";
				else if(strtolower($columns[1]) == "hostname")
					$append = ",editable:false,sortable:false,search:false";
				else if(strtolower($columns[1]) == "domain")
					$append = ",editable:false,sortable:true,search:true";
				else if(strtolower($columns[1]) == "edited")
					$append = ",editable:false,sortable:true,search:true";
				else if(strtolower($columns[1]) == "sid")
					$append = ",hidden:true";
				else if(strtolower($columns[1]) == "r_h_disp")
				{
					$append = ",editable:false,search:false,hidden:false,fixed:true,sortable:true,formatter:'highlightFormatter'";
					$columns[0] = "!";
					$columns[2] = 20;
				}
				else
				{
					$append = "";
					$ft = $pdo->getFieldType($pdo->getSubdomainTableName(), $columns[1]);
					if($ft !== false)
					{
						if(stristr($ft, "datetime") !== false && $columns[1] != "last_update")
						{
							if(in_array($columns[1], $builtInFields))
								$append = ",sorttype:\"date\", editable:'hidden', formatter:'date', formatoptions:{srcformat:\"Y-m-d H:i:s\",newformat:\"$dateformat H:i:s\"}";
							else
								$append = ",sorttype:\"date\", editable:true, formatter:'date', formatoptions:{srcformat:\"Y-m-d H:i:s\",newformat:\"$dateformat H:i:s\"}";
						}
						else if(stristr($ft, "date") !== false)
							$append = ",sorttype:\"date\", editable:true, formatter:'date', formatoptions:{srcformat:\"Y-m-d\",newformat:\"$dateformat\"}";
						else if(stristr($ft, "varchar") !== false)
							$append = ",editable:true,editoptions:{size:35}";
						else
							$append = ",editable:true,editoptions:{size:20}";
					}
				}
				
				$append .= ", classes:\"dtcell $classname\"";
					
				$datacolumns .= "\t\t{label:";
				$datacolumns .= "'" . addslashes($columns[0]) . "',";
				$datacolumns .= "name:'" . $columns[1] . "',";
				$datacolumns .= "width:'" . $columns[2] . "'";
				$datacolumns .= $append;
				$datacolumns .= "}";
				if($j != (count($parts)-1))
					$datacolumns .= ",";
				$datacolumns .= "\n";
				$j++;
			}
		}
	}
	return $datacolumns;
}

###############################################################################

function getJSForDisplayGroup($entry, $dateformat)
{
	$datacolumns = "";
	
	$pdo = init_db(false);
	if($pdo !== false)
	{
		$builtInFields = $pdo->getDefaultColumnNames($pdo->getDomainTableName());
		$parts = explode(";", $entry);
		$j = 0;
		foreach($parts as $part)
		{
			$columns[0] = $part; // Label
			$columns[1] = strtolower(trim($part)); // Field Name
			$columns[1] = str_replace(" ","_", $columns[1]);
			# Avoid these two because they are dead
			if($columns[1] == "google_pr" || $columns[1] == "alexa_links")
				continue;
			$columns[2] = $pdo->getDefaultWidthForDomainColumn($columns[1]);
			$columns[0] = getLabelFromFieldName($columns[0]);
			$status = $pdo->getColumnLabelAndWidthForDomain($columns[1], $columns[0], $columns[2]);
			if(count($columns) == 3 && $columns[1] != "")
			{
				$classname = strtolower($columns[1]);
				$classname = str_replace("_","-", $classname) . "-cell";
				
				if(strtolower($columns[1]) == "domain")
					$append = ",editable:true,editoptions:{readonly:true,size:35}";
				else if(strtolower($columns[1]) == "r_h_disp")
				{
					$append = ",editable:false,search:false,hidden:false,fixed:true,sortable:true,formatter:'highlightFormatter'";
					$columns[0] = "!";
					$columns[2] = 20;
				}
				else if(strtolower($columns[1]) == "page_token_found")
				{
					$append = ",editable:false,align:'center',search:false,formatter:'booleanFormatter'";
					$columns[2] = 40;
				}
				else if(strtolower($columns[1]) == "edited")
					$append = ",editable:false";
				else if(strtolower($columns[1]) == "registrar")
					$append = ",editable:true,editoptions:{size:35},formatter:'registrarFormatter'";
				else if(strtolower($columns[1]) == "availability")
				{
					$append = ",editable:false,align:'center',search:false,formatter:'domAvailFormatter'";
					$columns[2] = 40;
				}
				else if(strtolower($columns[1]) == "ascii_domain")
					$append = ",editable:false";
				else
				{
					$append = "";
					$ft = $pdo->getFieldType($pdo->getDomainTableName(), $columns[1]);
					if($ft !== false)
					{
						if(stristr($ft, "datetime") !== false && $columns[1] != "last_update")
						{
							if(in_array($columns[1], $builtInFields))
								$append = ",sorttype:\"date\", editable:'hidden', formatter:'date', formatoptions:{srcformat:\"Y-m-d H:i:s\",newformat:\"$dateformat H:i:s\"}";
							else
								$append = ",sorttype:\"date\", editable:true, formatter:'date', formatoptions:{srcformat:\"Y-m-d H:i:s\",newformat:\"$dateformat H:i:s\"}";
						}
						else if(stristr($ft, "date") !== false)
							$append = ",sorttype:\"date\", editable:true, formatter:'date', formatoptions:{srcformat:\"Y-m-d\",newformat:\"$dateformat\"}";
						else if(stristr($ft, "varchar") !== false)
							$append = ",editable:true,editoptions:{size:35}";
						else
							$append = ",editable:true,editoptions:{size:20}";
					}
				}
				
				$append .= ", classes:\"dtcell $classname\"";
					
				$datacolumns .= "\t\t{label:";
				$datacolumns .= "'" . addslashes($columns[0]) . "',";
				$datacolumns .= "name:'" . $columns[1] . "',";
				$datacolumns .= "width:'" . $columns[2] . "'";
				$datacolumns .= $append;
				$datacolumns .= "}";
				if($j != (count($parts)-1))
					$datacolumns .= ",";
				$datacolumns .= "\n";
				$j++;
			}
		}
	}
	return $datacolumns;
}

###############################################################################
?>
