<?php

$newtld_array = array(
	'ventures' => 'whois.donuts.co',
	'singles' => 'whois.donuts.co',
	'bike' => 'whois.donuts.co',
	'holdings' => 'whois.donuts.co',
	'plumbing' => 'whois.donuts.co',
	'guru' => 'whois.donuts.co',
	'clothing' => 'whois.donuts.co',
	'camera' => 'whois.donuts.co',
	'equipment' => 'whois.donuts.co',
	'estate' => 'whois.donuts.co',
	'gallery' => 'whois.donuts.co',
	'graphics' => 'whois.donuts.co',
	'lighting' => 'whois.donuts.co',
	'photography' => 'whois.donuts.co',
	'contractors' => 'whois.donuts.co',
	'land' => 'whois.donuts.co',
	'technology' => 'whois.donuts.co',
	'construction' => 'whois.donuts.co',
	'directory' => 'whois.donuts.co',
	'kitchen' => 'whois.donuts.co',
	'today' => 'whois.donuts.co',
	'diamonds' => 'whois.donuts.co',
	'enterprises' => 'whois.donuts.co',
	'tips' => 'whois.donuts.co',
	'voyage' => 'whois.donuts.co',
	'shoes' => 'whois.donuts.co',
	'careers' => 'whois.donuts.co',
	'photos' => 'whois.donuts.co',
	'recipes' => 'whois.donuts.co',
	'limo' => 'whois.donuts.co',
	'domains' => 'whois.donuts.co',
	'cab' => 'whois.donuts.co',
	'company' => 'whois.donuts.co',
	'computer' => 'whois.donuts.co',
	'center' => 'whois.donuts.co',
	'systems' => 'whois.donuts.co',
	'academy' => 'whois.donuts.co',
	'management' => 'whois.donuts.co',
	'training' => 'whois.donuts.co',
	'solutions' => 'whois.donuts.co',
	'support' => 'whois.donuts.co',
	'builders' => 'whois.donuts.co',
	'email' => 'whois.donuts.co',
	'education' => 'whois.donuts.co',
	'institute' => 'whois.donuts.co',
	'repair' => 'whois.donuts.co',
	'camp' => 'whois.donuts.co',
	'glass' => 'whois.donuts.co',
	'solar' => 'whois.donuts.co',
	'coffee' => 'whois.donuts.co',
	'international' => 'whois.donuts.co',
	'house' => 'whois.donuts.co',
	'florist' => 'whois.donuts.co',
	'holiday' => 'whois.donuts.co',
	'marketing' => 'whois.donuts.co',
	'viajes' => 'whois.donuts.co',
	'farm' => 'whois.donuts.co',
	'codes' => 'whois.donuts.co',
	'cheap' => 'whois.donuts.co',
	'zone' => 'whois.donuts.co',
	'agency' => 'whois.donuts.co',
	'bargains' => 'whois.donuts.co',
	'boutique' => 'whois.donuts.co',
	'tienda' => 'whois.donuts.co',
	'watch' => 'whois.donuts.co',
	'works' => 'whois.donuts.co',
	'cool' => 'whois.donuts.co',
	'expert' => 'whois.donuts.co',
	'menu' => 'whois.nic.menu',
	'club' => 'whois.nic.club',
	'photo' => 'whois.uniregistry.net',
	'gift' => 'whois.uniregistry.net',
	'guitars' => 'whois.uniregistry.net',
	'pics' => 'whois.uniregistry.net',
	'link' => 'whois.uniregistry.net',
	'sexy' => 'whois.uniregistry.net',
	'tattoo' => 'whois.uniregistry.net',
	'reviews' => 'whois.unitedtld.com',
	'ms' => 'whois.nic.ms',
	'uno' => 'whois.nic.uno',
	'buzz' => 'whois.nic.buzz',
	'berlin' => 'whois.nic.berlin',
	
	'il' => 'whois.isoc.org.il',
	'fi' => 'whois.fi',
	'dk' => 'whois.dk-hostmaster.dk',
	'no' => 'whois.norid.no',
	'ro' => 'whois.rotld.ro',
	'at' => 'whois.nic.at',

	'engineer' => 'whois.rightside.co',
	'attorney' => 'whois.rightside.co',
	'dentist' => 'whois.rightside.co',
	'degree' => 'whois.rightside.co',
	'lawyer' => 'whois.rightside.co',
	'market' => 'whois.rightside.co',
	'mortgage' => 'whois.rightside.co',
	'vet' => 'whois.rightside.co',
	'republican' => 'whois.rightside.co',
	'navy' => 'whois.rightside.co',
	'website' => 'whois.nic.website',
	'space' => 'whois.nic.space',
	'host' => 'whois.centralnic.com',
	'press' => 'whois.centralnic.com',
	'democrat' => 'whois.unitedtld.com',

	'xyz' => 'whois.nic.xyz',
	'nyc' => 'whois.nic.nyc',
	'webcam' => 'whois.nic.webcam'
);

$search_tokens = array(
	"whois.crsnic.net" => "No match for", 
	"whois.publicinterestregistry.net" => "NOT FOUND", 
	"whois.pir.org" => "NOT FOUND",
	"whois.nic.uk" => "No match for", 
	"whois.ausregistry.net.au" => "No Data Found",
	"whois.registry.in" => "NOT FOUND", 
	"whois.afilias.info" => "NOT FOUND", 
	"whois.afilias.net" => "NOT FOUND", 
	"whois.neulevel.biz" => "Not found", 
	"whois.aero" => "NOT FOUND", 
	"whois.nic.coop" => "No Objects Found|No domain records were found to match", 
	"whois.nic.name" => "No match for", 
	"whois.nic.ws" => "No match for", 
	"whois.sidn.nl" => "is not a registered domain|is free", 
	"whois.nic.nu" => "NO MATCH for domain", 
	"whois.nic.de" => "not found in database|free", 
	"whois.cira.ca" => "Domain status:         available",
	"whois.domainz.net.nz" => "220 Available", 
	"whois.nic.us" => "Not found", 
	"whois.nic.fr" => "No entries found",
	"whois.twnic.net.tw" => "No Found",
	"whois.nic.tv" => "No match for",
	"whois.nic.ch" => "do not have an entry",
	"whois.eu" => "Status:AVAILABLE",
	"whois.nic.it" => "Status:             AVAILABLE",
	"whois.cnnic.net.cn" => "no matching record",
	"whois.dotmobiregistry.net" => "NOT FOUND",
	"whois.nic.cc" => "No match for",
	"whois.nic.asia" => "NOT FOUND",
	"whois.registrypro.pro" => "Unknown domain",
	"whois.hknic.net.hk" => "Domain Not Found",
	"whois.meregistry.net" => "NOT FOUND",
	"whois.dns.be" => "Status:      FREE",
	"whois.nic.se" => "not found.",
	"whois.iedr.ie" => "Not Registered",
	"whois.aeda.net.ae" => "No Data Found",
	"whois.nic.or.kr" => "Above domain name is not registered",
	"whois.nic.tel" => "Not found",
	"whois.ja.net" => "No such domain",
	"mx.whois-servers.net" => "Object_Not_Found",
	"whois.nic.co" => "Not found:",
	"whois.jprs.jp" => "No match!!",
	"whois.ripn.net" => "No entries found for",
	"whois.dns.pt" => "no match",
	"whois.nic.at" => "nothing found",
	"whois.dk-hostmaster.dk" => "No entries found for the selected",
	"whois.dns.pl" => "No information available",
	"whois.nic.xxx" => "NOT FOUND",
	"whois.isoc.org.il" => "No data was found to match",
	"whois.nic.net.sg" => "Domain Not Found",
	"whois.nic.ir" => "ERROR:101: no entries found",
	"whois.centralnic.net" => "DOMAIN NOT FOUND",
	"whois.je" => "Status: Not Registered",
	"whois.tcinet.ru" => "No entries found for the selected source",
	"whois.donuts.co" => "Domain not found",
	"whois.nic.menu" => "No Data Found",
	"whois.nic.club" => "Not found",
	"whois.uniregistry.net" => "is available for registration",
	"whois.unitedtld.com" => "Domain not found",
	"whois.nic.ms" => "No Object Found",
	"whois.nic.uno" => "Not found",
	"whois.nic.buzz" => "Not found",
	"whois.nic.berlin" => "No match",
	
	"whois.rightside.co" => "Domain not found",
	"whois.fi" => "Domain not found",
	"whois.isoc.org.il" => "No data was found to match the request criteria",
	"whois.dk-hostmaster.dk" => "No entries found for the selected source",
	"whois.norid.no" => "% No match",
	"whois.rotld.ro" => "No entries found for the selected source",
	"whois.nic.at" => "% nothing found",
	"whois.nic.space" => "DOMAIN NOT FOUND",
	"whois.nic.xyz" => "DOMAIN NOT FOUND",
	"whois.centralnic.com" => "DOMAIN NOT FOUND",
	"whois.nic.website" => "DOMAIN NOT FOUND",
	"whois.nic.nyc" => "Not found:",
	"whois.nic.webcam" => "Not found:",
	"whois.registry.knet.cn" => "The queried object does not exist"
);

	foreach($newtld_array as $tld=>$server)
	{
		$ws = get_whois_server_for_tld($tld);
		if($ws === false || $ws == "")
			set_whois_server_for_tld($tld, $server);
	}
	
	foreach($search_tokens as $server=>$token)
	{
		$st = get_searchtoken_from_whoisserver($server);
		if($st === false || $st == "")
			set_searchtoken_for_whoisserver($server, $token);
	}
	
	$prowhois = get_whois_server_for_tld("pro");
	if($prowhois !== false && strtolower($prowhois) == "whois.registrypro.pro")
		set_whois_server_for_tld("pro", "whois.afilias.net");
	
	$mewhois = get_whois_server_for_tld("me");
	if($mewhois !== false && strtolower($mewhois) == "whois.meregistry.net")
		set_whois_server_for_tld("me", "whois.nic.me");
	
	set_querystring_for_whoisserver("whois.registry.knet.cn", "{d}");
	set_querystring_for_whoisserver("whois.jprs.jp", "{D} /e");
	
$banned_texts = array(

'whois.networksolutions.com' => 'contained within a list of IP addresses that may have failed',
'whois.tucows.com' => 'Maximum Daily connection limit reached',
'whois.ausregistry.net.au' => 'BLACKLISTED: You have exceeded the query limit',
'google.com' => 'Our systems have detected unusual traffic from your computer network',
'whois.nic.xyz' => 'Query rate of 6 queries per hour exceeded for your network',
'whois.nic.uk' => 'the WHOIS query quota for',
'whois.website.ws'=>'You exceeded the maximum allowable number of whois lookups. No further queries can be done.'

);
	$pdo = init_db();
    if($pdo !== false)
	{
		foreach($banned_texts as $key=>$text)
		{
			$tablename = $pdo->getWhoisserverTableName();
			$present = $pdo->getCount($tablename, "server = ?", array($key));
			if(!$present) 
				$pdo->insertIntoTable($tablename, array('server'=>$key)); 
			$winfo = $pdo->getWhoisServerInfo($key);
			if($winfo !== false)
			{
				if(isset($winfo['bannedtext']))
				{
					if($winfo['bannedtext'] == "" || $winfo['bannedtext'] == null)
						$pdo->setWhoisServerInfo($key, array('bannedtext'=>$text));
				}
				else
					$pdo->setWhoisServerInfo($key, array('bannedtext'=>$text));
			}
		}
		try
		{
			$utfsql = "ALTER TABLE " . $pdo->getDomainTableName() . " MODIFY domain varchar(255) COLLATE utf8_bin";
			$stmt = $pdo->db_connect_handle->prepare($utfsql);
			$stmt->execute();
			$utfsql = "ALTER TABLE " . $pdo->getSubdomainTableName() . " MODIFY subdomain varchar(255) COLLATE utf8_bin";
			$stmt = $pdo->db_connect_handle->prepare($utfsql);
			$stmt->execute();
		}
		catch (PDOException $e) 
		{
			$pdo->setError($e->getMessage());
		}
		
		$regapidata = getRegistrarAPIDefaults();
		$rc = count($regapidata)/5;
		for($i = 0; $i < $rc; $i++) {
			$ri = $pdo->getTableData($pdo->getRegistrarAPITableName(), "value", "WHERE registrar=? AND label=?", array($regapidata[$i*5], $regapidata[$i*5+1]));
			if($ri !== false && !count($ri)) {
				$rdata = array('registrar' => $regapidata[$i*5], 'label' => $regapidata[$i*5+1], 'type' => $regapidata[$i*5+2], 'dtype' => $regapidata[$i*5+3], 'value' => $regapidata[$i*5+4]);
				$pdo->insertIntoTable($pdo->getRegistrarAPITableName(), $rdata);
			}
		}
		
		$xlat = get_stranslation_array_for_whois_server("whois.cira.ca");
		if(!isset($xlat['[*]']) && !isset($xlat['[**]'])) {
			$pdo->setWhoisServerInfo("whois.cira.ca", array('xlate'=>'[*]=>*'));
		}
	}
?>
