<?php
###############################################################################
# config-sample.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

function get_default_config_data()
{
	return array(
	'ui_theme'							=> 'redmond',
	'multi_server_global_settings'		=> true,
	'default_lookup_types'				=> 'dw,ip',
	'default_sub_domains'				=> '',
	'do_dns_record_lookup'				=> true,
	'do_subdomain_ext_lookup'			=> false,
	'config_subdomain_entry'			=> "",
	'high_preference_lookups'			=> 'dw,ip',
	'custom_tools_file'					=> 'lib/php/custom/domaintools-sample.php',
	'cell_date_format'					=> 'd-M-Y',
	'auth_timeout_minutes'				=> 15,
	'max_login_attempts'				=> 8,
	'login_lockout_minutes'				=> 10,
	'ui_lang'							=> 'en',
	'admin_user_name'					=> '',
	'admin_password'					=> '',
	'enable_data_history'				=> '',
	'auth_queue_processing'				=> true,
	'fix_host_domain_names'				=> false,
	'requeue_on_empty_whois'			=> false,
	'license_key_code'					=> '',
	'home_page_max_redirs'				=> 3,
	'license_key_code_v3'               => 'mnal5kmWxjsoutorWTmqpnb3+BlqSW',
	'product_page_link'					=> '',
	'support_page_link'					=> '',
	'contact_page_link'					=> '',
	'parked_theme_color'				=> '006EB1',
	'parked_theme_main_background'		=> 'parked.jpg',
	'parked_contact_toemail_name'		=> '',
	'parked_contact_toemail_address'	=> '',

	'sub_domain_columns'				=> 'domain;hostname;record_type;record_value;ip;ssl_valid_to;ssl_issued_by;ssl_issued_to',
	'dns_subgrid_columns'				=> 'record_type;record_value;ttl;ip;ptr',
	'ssl_subgrid_columns'				=> 'ssl_valid_from;ssl_valid_to;ssl_issued_to;ssl_issued_by;ip',
	'home_screen_application'			=> "main.php",
	'main_logo_image'					=> '',
	'highlight_status_codes'			=> 'autorenewperiod,redemptionperiod,pendingdelete,serverhold,pendingtransfer,renewperiod',

	'email_from_address'				=> "contact@example.com",
	'email_from_name'					=> "Company Name",
	'email_reply_address'				=> "",
	'email_reply_name'					=> "",
	'email_send_method'					=> "default",      // sendmail, qmail, default, smtp
	'email_smtp_server'					=> 'smtp.gmail.com',
	'email_smtp_secure' 				=> 'tls',		  // ssl, tls
	'email_smtp_port' 					=> 587, 
	'email_smtp_user'					=> "",  
	'interface_language'				=> "en",
	'email_word_wrap'					=> 50
	);
}

###############################################################################

function get_default_columns_for_groups()
{
	return array(
	'custom01_columns_array' 			=> 'ip;notes_c;notes_d;ns3;ns4',
	'custom02_columns_array' 			=> 'ip;notes_a;notes_b;ns1;ns2',
	'report_columns_array' 				=> 'registry_expiry;registrar_expiry;lookedup;status;registrar',
	'date_columns_array' 				=> 'registry_expiry;registrar_expiry;created_on;last_update;lookedup',
	'http_columns_array' 				=> 'ip;home_page_url;home_page_title;home_page_status;redirect_url;home_page_checked_at',
	'registrar_columns_array' 			=> 'registrar;status;last_update;lookedup;ascii_domain',
	'network_columns_array'				=> 'ns1;ns2;ns3;ping_time;mx1;mx2;ip',
	'sitepop_columns_array' 			=> 'google_index_count;alexa_rank;ping_time;ip',
	'notes_columns_array' 				=> 'notes_a;notes_b;notes_c;notes_d;ip',
	'ipdata_columns_array' 				=> 'ip;ip_org_name;ip_net_name;ip_asnumber;ip_asname'
	);
}

###############################################################################

function get_chathu_poya_pids()
{
	return array( 
	'rISffYmvnHecaaWve2c=', 
	'rISfiIy6oXWhZ6jSdGeRi2l4h6Q=' 
	);
}

###############################################################################
?>