<?php
###############################################################################
# basic.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

# Returns the root path
# Examples
# https://www.example.com/wmdsed3/ => /wmdsed3/
# https://www.example.com/scripts/wmdsed3/ => /scripts/wmdsed3/
function get_install_url_path()
{
	if(!isset($_SERVER['PHP_SELF']) || !isset($_SERVER['SCRIPT_NAME']))
		return "";

	$basepath = $_SERVER['PHP_SELF'];
	$pos = strpos($basepath, "/lib/php/");
	if($pos !== false)
		$basepath = substr($basepath, 0, $pos) . "/";
	$pos = strpos($basepath, "/thirdparty");
	if($pos !== false)
		$basepath = substr($basepath, 0, $pos) . "/";
	$pos = strpos($basepath, "/parked");
	if($pos !== false)
		$basepath = substr($basepath, 0, $pos) . "/";
	$basepath = str_replace(basename($_SERVER['SCRIPT_NAME']), "", $basepath);
	return $basepath;
}

###############################################################################

function get_root_url()
{
	if(isset($_SERVER['HTTP_HOST']))
		$rooturl = (!empty($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'];
	else
		$rooturl = "http://your/install/path";
	$rooturl .= get_install_url_path();
	return $rooturl;
}

###############################################################################

function get_install_folder_path()
{
	return realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . "../../") . DIRECTORY_SEPARATOR;
}

###############################################################################

function get_layout_folder_path()
{
	return get_install_folder_path() . "lib/layouts/default/";
}

###############################################################################

function get_ui_config_panels_path()
{
	return get_install_folder_path() . "lib/php/config/panels/";
}

###############################################################################

function get_ui_blocks_path()
{
	return get_install_folder_path() . "lib/php/ui/";
}

###############################################################################

function get_php_folder_path()
{
	return get_install_folder_path() . "lib/php/";
}

###############################################################################

function is_valid_theme($theme)
{
	$path = get_install_folder_path() . "lib/css/jquery-ui/themes/" . $theme;
	if(is_dir($path))
		return true;
	else
		return false;
}

###############################################################################

function get_lang_code()
{
	$lang = "en";
	if(function_exists('get_config_data'))
	{
		$lang = get_config_data('ui_lang');
		if(!is_valid_lang($lang))
			$lang = "en";
	}
	if(isset($_REQUEST['lang']))
	{
		$lc = $_REQUEST['lang'];
		if(is_valid_lang($lc))
			$lang = $lc;
	}
	return $lang;
}

###############################################################################

function is_valid_lang($lang)
{
	$path = get_install_folder_path() . "lib/php/lang/$lang.php";
	if(is_file($path))
		return true;
	else
		return false;
}

###############################################################################

function get_theme_name()
{
	$default_theme = "redmond";
	if(function_exists('get_default_config_data'))
	{
		$cd = get_default_config_data();
		$default_theme = $cd['ui_theme'];
	}
	
	if(function_exists('get_config_data'))
	{
		$ui_theme = get_config_data('ui_theme');
		if(!is_valid_theme($ui_theme))
			$ui_theme = $default_theme;
	}
	else
		$ui_theme = $default_theme;
	return $ui_theme;
}

###############################################################################

function logToFile($filename, $msg)
{ 
	$fd = fopen($filename, "a");
	fwrite($fd, $msg);
	fclose($fd);
}

###############################################################################

function getLogFileName()
{
	return get_install_folder_path() . "logs/php.log";
}

###############################################################################

function truncateLogFile($length=0)
{
	$fd = fopen(getLogFileName(), "r+");
	ftruncate($fd, $length);
	fclose($fd);
}

###############################################################################

function logData($msg)
{ 
	$fd = fopen(getLogFileName(), "a");
	fwrite($fd, $msg);
	fclose($fd);
}

###############################################################################

function debugLogData($msg, $prompt="")
{
	if(isset($_REQUEST['debug']))
	{
		if($prompt != "")
			$msg = "$prompt:\n$msg";
		$msg .= "\n\n";
		logData($msg);
	}
}

###############################################################################

function logRequestData()
{
	$timestamp = strftime("%c",time());
	$ldata = "\n--" . $timestamp . "--\n";
	foreach ($_REQUEST as $key=>$value) 
	{
		$ldata .= $key . " - " . $value . "\n";
	}
	logToFile(getLogFileName(), $ldata);
}

###############################################################################

function errorEcho($msg)
{
	echo "<p style=\"background-color:#F00; color:#FFF;\">$msg</p>\n";
}

###############################################################################

function smartEcho($msg, $prompt="")
{
	if($prompt != "")
		$msg = "$prompt: $msg";
	if(is_cli())
		echo "$msg\n";
	else
		echo "<p>$msg</p>";
}

###############################################################################

function debugEcho($msg, $prompt="")
{
	if(isset($_REQUEST['debug']))
	{
		if($prompt != "")
			$prompt .= ": ";
		echo "<p>$prompt $msg</p>";
	}
}

###############################################################################

function debugPrintArray($array)
{
	if(isset($_REQUEST['debug']))
		printArray($array);
}

//////////////////////////////////////////////////////////////////////

function debug_out_domain_data($dataarray)
{
	debugPrintArray($dataarray);
}

###############################################################################

function printArray($array)
{
	echo "<pre>"; print_r($array); echo "</pre>";
}

###############################################################################

function get_string_between($string, $start, $end, $includetokens=false)
{
    $string = " ".$string;
    $ini = mb_stripos($string,$start);
    if ($ini == 0) return "";
	if(!$includetokens)
		$ini += mb_strlen($start);
    $len = mb_stripos($string,$end,$ini) - $ini;
	if($includetokens)
		$len += strlen($end);
    return mb_substr($string,$ini,$len);
}

###############################################################################

function in_array_casei($needle, $haystack) 
{
    return in_array(strtolower($needle), array_map('strtolower', $haystack));
}

###############################################################################

function string_ends_with($string, $test) 
{
    $slen = mb_strlen($string);
    $testlen = mb_strlen($test);
    if ($testlen > $slen) 
		return false;
    return substr_compare($string, $test, $slen - $testlen, $testlen) === 0;
}

###############################################################################

function get_date_difference($pdate, $pivot=null)
{
	if($pivot == null)
		$pivot = time(); 
	$datediff = $pdate - $pivot;
	return floor($datediff/(60*60*24));
}

###############################################################################

function isADate( $str ) 
{ 
	$stamp = strtotime( $str ); 
	if (!is_numeric($stamp)) 
		return FALSE; 
	$month = date( 'm', $stamp ); 
	$day   = date( 'd', $stamp ); 
	$year  = date( 'Y', $stamp ); 
	if (checkdate($month, $day, $year)) 
		return TRUE; 
	return FALSE; 
}

###############################################################################

function findWhoisServerFromIANA($domain_name)
{
	require_once("idn/idn.php");
	
	$wserver = "";
	$registry = "";
	$tld = $domain_name;
	$parts = explode(".", $domain_name);
	if(count($parts) > 1)
		$tld = $parts[count($parts)-1];
	$ascii_name = idn_convert($tld);
	$url = "http://www.iana.org/domains/root/db/$ascii_name.html";
	$result = @file_get_contents($url);
	if($result !== false)
	{
		$p1 = strip_tags(get_string_between($result, "<b>URL for registration services:</b>", "\n"));
		$registry = trim($p1);
		$p2 = strip_tags(get_string_between($result, "<b>WHOIS Server:</b>", "\n"));
		$wserver = trim($p2);
	}
	if($wserver == "")
	{
		$tserver = "whois.nic." . $tld;
		$ip = gethostbyname($tserver);
		if($ip != $tserver)
			$wserver = $tserver;
	}
		
	$info['whoisserver'] = $wserver;
	$info['registry'] = $registry;
	$info['tld'] = $tld;
	return $info;
}

###############################################################################
# Just a helper function to cleanup the display group name so that it looks
# clean

function beautifyDisplayGroupName($dgroup)
{
	$name = ucwords(str_replace(" array", "", str_replace("_", " ", $dgroup)));
	$name = str_replace("Ipdata", "IP Data", $name);
	$name = str_replace("Custom01", "Custom-01", $name);
	$name = str_replace("Custom02", "Custom-02", $name);
	$name = str_replace("Report", "Custom-03", $name);
	return $name;
}

###############################################################################

function generateHash($plainText, $salt = null)
{
	if ($salt === null)
	{
		$salt = substr(md5(uniqid(rand(), true)), 0, 25);
	}
	else
	{
		$salt = substr($salt, 0, 25);
	}
	
	return $salt . sha1($salt . $plainText);
}

###############################################################################

function invalidSessionQuit()
{
	header("HTTP/1.0 400 Bad Request");
	echo "Error: Invalid Session. Please login again.";
	exit;
}

###############################################################################

function noPermissionQuit()
{
	header("HTTP/1.0 403 Forbidden");
	echo "Permission Denied.";
	exit;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function getRequestVariable($name, $default)
{
	if(isset($_REQUEST[$name]))
		return $_REQUEST[$name];
	return $default;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function getNumericRequestVariable($name, $default)
{
	if(isset($_REQUEST[$name]))
		return intval($_REQUEST[$name]);
	return $default;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function getSanitizedNumericRequestVariable($name, $default, $minv, $maxv)
{
	$retval = $default;
	if(isset($_REQUEST[$name]))
		$retval = intval($_REQUEST[$name]);
	if($retval < $minv || $retval > $maxv)
		$retval = $default;
	return $retval;
}

###############################################################################

function doAuditLog($action, $desc="")
{
	$pdo = init_db();
	if($pdo !== false)
		$pdo->logAuditEntry($action, $desc);
}

###############################################################################

function isUserAuthEnabled()
{
	$user = getConfigData('admin_user_name', "");
	$pass = getConfigData('admin_password', "");
	if($user != "" && $pass != "" && strlen($pass) >= 6)
		return true;
	else
		return false;
}

###############################################################################

function isUserAdminManuallySet()
{
	global $admin_user_name, $admin_password;
	if($admin_user_name != "" || $admin_password != "")
		return true;
	return false;
}

###############################################################################

function isAdminUser()
{
	if(isUserAuthEnabled() == false)
		return true;
	else
	{
		if(isset($_SESSION['user']))
		{
			$userinfo = $_SESSION['user'];
			if(is_array($userinfo))
				if($userinfo['admin'])
					return true;
		}
		return false;
	}
}

###############################################################################
# Returns empty for admin user (access to all categories)

function getValidCategoryIDs()
{
	$cids = array();
	if(!isAdminUser())
	{
		$cids[] = 1;
		$perms = getPermissionsFromSession();
		if($perms !== false)
		{
			foreach($perms as $p)
			{
				if($p['name'] != "")
					$cids[] = $p['id'];
			}
		}
	}
	return $cids;
}

###############################################################################

function getUserAccessRights()
{
	if(isAdminUser())
		return 1; # View+Edit+Add+Delete
	else
	{
		$userinfo = getUserinfoFromSession();
		if($userinfo !== false)
			return $userinfo['readwrite'];
	}
	return 0;  # Only View
}

###############################################################################

function getAccessRightsString($rights)
{
	if($rights == 1)
		return "View + Edit + Add + Delete";
	else if($rights == 2)
		return "View + Edit";
	else if($rights == 3)
		return "View + Edit + Add";
	else
		return "View";
}

###############################################################################

function doAuthentication($redir="")
{
	if($redir != "")
		$_SESSION['redir'] = $redir;
	
	if(isUserAuthEnabled())
	{
		$login_required = false;
		$extraparam = "";
		
		if(isset($_REQUEST['logout']))
			doLogout();
		
		if(!isset($_SESSION['logged']))
			$login_required = true;
		else
		{
			if($_SESSION['logged'] == false)
				$login_required = true;
		}
		if(isSessionTimedOut()) 
		{
			$login_required = true;
			$extraparam = "timeout";
		}
		if($login_required)
		{
			$newlocation = get_install_url_path() . "login.php?r=" . $extraparam;
			if($redir != "")
				$newlocation .= "&redir=" . $redir;
			header("Location: " . $newlocation);
			exit;
		}
	}
	else
	{
		if(!isset($_SESSION['logged']))
		{
			$_SESSION['logged'] = true;
			$_SESSION['rid'] = $_SERVER["REMOTE_ADDR"];
		}
	}
}

###############################################################################

function isSessionTimedOut()
{
	$auth_timeout_minutes = getConfigData('auth_timeout_minutes', null);
	
	if($auth_timeout_minutes > 0)
	{
		if(isset($_SESSION['timeout']))
		{
			$tseconds = $auth_timeout_minutes * 60;
			if(($_SESSION['timeout'] + $tseconds) < time()) 
				return true;
		}
	}
	
	return false;
}

###############################################################################

function get_last_swipein()
{
	if(isset($_SESSION['timeout']))
	{
		$ts = intval($_SESSION['timeout']);
		if($ts > 0)
			return date("Y-m-d H:i:s", $ts);
	}
	return "";
}

###############################################################################

function get_timeout()
{
	$auth_timeout_minutes = get_config_data('auth_timeout_minutes');
	if($auth_timeout_minutes === false)
		$auth_timeout_minutes = 10;
	
	if(isset($_SESSION['timeout']) && $auth_timeout_minutes > 0)
	{
		$ts = intval($_SESSION['timeout']);
		$ts += $auth_timeout_minutes * 60;
		$tn = time();
		return $ts-$tn;
	}
	return "";
}

###############################################################################

function doLogout()
{
	if(isset($_SESSION['logged']))
	{
		$username = getUserName();
		doAuditLog(AUDIT_LOGGED_OUT, "$username logged out");
		unset($_SESSION['logged']);
		unset($_SESSION['rid']);
		unset($_SESSION['timeout']);
		unset($_SESSION['user']);
		unset($_SESSION['permissions']);
		unset($_SESSION['redir']);
	}
	if(isset($_REQUEST['redir']))
		$_SESSION['redir'] = $_REQUEST['redir'];
}

###############################################################################

function interfaceRedir()
{
	$mainapp = getConfigdata("home_screen_application", null);
	if(!is_file(get_install_folder_path() . $mainapp))
		$mainapp = "main.php";
	if(isset($_REQUEST['redir']))
		$redir = get_install_url_path() . $_REQUEST['redir'];
	else if(isset($SESSION['redir']))
		$redir = get_install_url_path() . $_SESSION['redir'];
	else
		$redir = get_install_url_path() . $mainapp;
	header("Location: " . $redir);
	exit;
}

###############################################################################

function getPermissionsFromSession()
{
	if(isset($_SESSION['permissions']))
		return $_SESSION['permissions'];
	return false;
}

###############################################################################

function getUserinfoFromSession()
{
	if(isset($_SESSION['user']))
		return $_SESSION['user'];
	return false;
}

###############################################################################

function getUserName()
{
	$ui = getUserinfoFromSession();
	if(isset($ui['name']))
		return $ui['name'];
	else
		return "unknown";
}

###############################################################################

function getUserID()
{
	$ui = getUserinfoFromSession();
	if(isset($ui['uid']))
		return $ui['uid'];
	else
		return 0;
}

###############################################################################

function doSessionSwipeIn()
{
	$_SESSION['timeout'] = time();
}

###############################################################################

function validateSession($swipein=true)
{
	if(isUserAuthEnabled())
	{
		if(!isset($_SESSION['logged']))
			return -1;
		else
		{
			if($_SESSION['logged'] == false)
				return -1;
		}
		if(isSessionTimedOut()) 
			return 1;
	}
	else
	{
		if(!isset($_SESSION['logged']))
		{
			$_SESSION['logged'] = true;
			$_SESSION['rid'] = $_SERVER["REMOTE_ADDR"];
		}
	}
	if($swipein)
		doSessionSwipeIn();
	return 0;
}

###############################################################################

function isRequestCommand($command)
{
	return isset($_REQUEST[$command]) ? true : false;
}

###############################################################################

function is_cli()
{
    if( defined('STDIN') || (empty($_SERVER['REMOTE_ADDR']) && !isset($_SERVER['HTTP_USER_AGENT']) && count($_SERVER['argv']) > 0))
        return true;
    return false;
}

###############################################################################

function apikey_authentication_check()
{
	$auth = false;
	if(isset($_REQUEST['key']))
	{	
		$cli_auth_key_code = getConfigData('cli_auth_key_code', "");
		if($_REQUEST['key'] == $cli_auth_key_code && $cli_auth_key_code != "")
			$auth = true;
	}
	return $auth;
}

###############################################################################

function getLabelFromFieldName($field)
{
	$label = $field;
	$label = ucwords(str_replace("_"," ", $label));
	if(strlen($label) <= 3)
		$label = strtoupper($label);
	else if(stristr($label, "mxip") !== false)
		$label = strtoupper($label);
		
	$label = str_replace("Redirect Url", "Redirect URL", $label);
	$label = str_replace("Google Pr", "Google PR", $label);
	$label = str_replace("Google Index Count", "Google Index #", $label);
	$label = str_replace("Ascii Domain", "ASCII Name", $label);
	$label = str_replace("Mx ", "MX ", $label);
	$label = str_replace("Ip ", "IP ", $label);
	$label = str_replace("Ssl ", "SSL ", $label);
	$label = str_replace("Dns ", "DNS ", $label);
	$label = str_replace("Asname", "AS Name", $label);
	$label = str_replace("Asnumber", "AS Number", $label);
	
	return $label;
}

###############################################################################

function array_sort($array, $on, $order=SORT_ASC)
{
    $new_array = array();
    $sortable_array = array();
    if (count($array) > 0) 
	{
        foreach ($array as $k => $v) 
		{
            if (is_array($v)) 
			{
                foreach ($v as $k2 => $v2) 
				{
                    if ($k2 == $on) 
					{
                        $sortable_array[$k] = $v2;
                    }
                }
            } else 
			{
                $sortable_array[$k] = $v;
            }
        }

        switch ($order) 
		{
            case SORT_ASC:
                asort($sortable_array);
            break;
            case SORT_DESC:
                arsort($sortable_array);
            break;
        }

        foreach ($sortable_array as $k => $v) 
		{
            $new_array[$k] = $array[$k];
        }
    }
    return $new_array;
}

###############################################################################

function loginIfRequired($adminrequired=false)
{
	# Check if authentication is required.
	if(!apikey_authentication_check() && !is_cli())
	{
		$auth = validateSession();
		if($adminrequired)
		{
			if(!isAdminUser())
			{
				smartEcho("Administrator privileges required.");
				exit;
			}
		}
		if($auth != 0)
		{
			if(isset($_REQUEST['ajax']))
				echo json_encode(array('validate'=>$auth)); 
			else
				header("Location: " . get_install_url_path() . "login.php");
			exit;
		}
	}
}

###############################################################################

function isValidApp($appname)
{
	$validapps = array("main.php", "sdmgr.php", "menu.php", "verify.php", "monitor.php", "audit.php");
	if(in_array($appname, $validapps))
		return true;
	else
		return false;
}

###############################################################################

function generate_form_token($formname)
{
	if(function_exists("hash_algos") && in_array("sha512", hash_algos()))
	{
		$token = hash("sha512", mt_rand(0, mt_getrandmax()));
	}
	else
	{
		$token = '';
		$characters = 'abcdefghijklmnopqrstuvwxyz0123456789';
		for ($i = 0; $i < 128; $i++) 
			$token .= $characters[rand(0, strlen($characters) - 1)];
	}
	$_SESSION[$formname] = $token;
	return $token;
}

###############################################################################

function is_ok_to_process_form($fname)
{
	$tname = $fname . "-ltk";
	$proc_form = false;
	if(isset($_SESSION[$tname]) && isset($_REQUEST['lgptoken']))
	{
		if($_SESSION[$tname] == $_REQUEST['lgptoken'])
			$proc_form = true;
	}
	return $proc_form;
}

###############################################################################

function echo_form_token($fname)
{
	$tname = $fname . "-ltk";
	echo generate_form_token($tname);
}


###############################################################################
?>
