<?php
###############################################################################
# auth.php
# Watch My Domains SED v3
# (c) Softnik Technologies. All rights reserved.
###############################################################################

define("USE_AUTH_DB","TRUE");

###############################################################################

require_once(dirname(__FILE__) . "/../basic.php");			# Basic UI is always required.
require_once(dirname(__FILE__) . "/../pdo/dbinit.php");		# The database with auth
require_once(dirname(__FILE__) . "/../config.check.php");	# Load default settings.

###############################################################################

if(isset($_REQUEST['user']) && isset($_REQUEST['pass']))
{
	$username = strip_tags(trim($_REQUEST['user']));
	$password = strip_tags(trim($_REQUEST['pass']));
	$login_error = "";
	$login_fail_count = 0;
	$last_login_fail_at = date("Y-m-d H:i:s");
	$returnurl = false;
	
	$user = getConfigData('admin_user_name', "");
	$pass = getConfigData('admin_password', "");
	
	global $db_default_mysql_engine;
	$max_login_attempts = get_config_data('max_login_attempts');
	$login_lockout_minutes = get_config_data('login_lockout_minutes');
	
	$pdo = init_db();
	if(isUserAuthEnabled() && $login_error == "" && $username != "" && $password != "")
	{
		$failcount = $pdo->getSingleEntry($pdo->auth_log_table, "ip", $_SERVER['REMOTE_ADDR'], "login_fail_count");
		if($failcount !== false);
			$login_fail_count = $failcount;
		$failtime = $pdo->getSingleEntry($pdo->auth_log_table, "ip", $_SERVER['REMOTE_ADDR'], "login_last_failed_at");
		if($failtime !== false)
		{
			if(isADate($failtime))
				$last_login_fail_at = $failtime;
		}
		
		$allow_logins = true;
		$maxlogins = 0;
		$lockout = 5;
		if(isset($max_login_attempts))
			$maxlogins = $max_login_attempts;
		if(isset($login_lockout_minutes))
			$lockout = $login_lockout_minutes;
		if($lockout <= 0)
			$lockout = 30*24*60;
		$unblock_minutes = $lockout;
		if($maxlogins > 0 && $login_fail_count >= $maxlogins)
		{
			$allow_logins = false;
			$timegap = intval((time()-strtotime($last_login_fail_at))/60);
			if($timegap >= $lockout && $lockout > 0)
				$allow_logins = true;
			else
				$unblock_minutes = $lockout-$timegap;
		}
		
		if($allow_logins)
		{
			# first check if admin user
			
			# if salted and hashed
			if(strlen($pass) > 25)
				$admpassword = generateHash($password, $pass);
			else
				$admpassword = $password;

			if($user == $username && $pass == $admpassword && strlen($pass) >= 6)
			{
				$pdo->addAuthLog(true);
				$userinfo['uid'] = 0;
				$userinfo['admin'] = true;
				$userinfo['name'] = $username;
				$userinfo['readwrite'] = 1;
				$userinfo['fullname'] = "System Admin";
				$userinfo['displayname'] = "System Admin [c]";
				$userinfo['lastsignin'] = date("Y-m-d H:i:s");
				$returnurl = $pdo->doLogin($userinfo);
			}
			else 
			{
				$returnurl = checkUserLogin($pdo, $username, $password);
			}
			
			if($returnurl === false)
			{
				# Login has failed.
				$login_fail_count++;
				$login_error = "Incorrect Login or Password";
				if($login_fail_count)
				{
					$login_error .= " (";
					$login_error .= $login_fail_count;
					if($maxlogins > 0)
						$login_error .= "/" . $maxlogins;
					$login_error .= ")";
				}
			}
			else
				$pdo->logAuditEntry(AUDIT_LOGGED_IN, "$username logged in");
		}
		else
			$login_error = "Temporarily blocked for " . $unblock_minutes . " minutes. Too many failed attempts!";
	}
	
	if($returnurl === false)
		$returnurl = "";
	$output['return'] = $returnurl;
	$output['errors'] = $login_error;
	$output['failed'] = $login_fail_count;
	$output['maxfail'] = $maxlogins;
	echo json_encode($output);
}

###############################################################################
?>
