/////////////////////////////////////////////////////////////////////////////////////////
// window.js
// Watch My Domains SED v3
// (c) Softnik Technologies. All rights reserved.
/////////////////////////////////////////////////////////////////////////////////////////

$(function()
{
	$(".btn-navtb").hover(function(e) 
	{ 
		var group = getCookie('display-group', "date_columns_array");
		var btnid = get_buttonid_from_displaygroup_name(group);
		var cpid = jQuery(this).attr("id");
		if(cpid !== btnid)
		{
			var btnbackground = $('.ui-state-default').css('background-color');
			var btnhovercolor = $('.ui-state-active').css('background-color');
			$(this).css("background-color", e.type === "mouseenter" ? btnhovercolor : btnbackground); 
		}
	});
	
	if(getCookieInt("popmenu", 1))
		togglePopupMenu();
	
	$(window).bind('resize', function() {fixDivSizes(); setTimeout(function(){fixDivSizes();}, 50);}).trigger('resize');
});

/////////////////////////////////////////////////////////////////////////////////////////

function fixDivSizes()
{
	positionMainInterface();
	
	var DOMAINGRID_AUTO_WIDTH = (getCookieInt("domaingrid_auto_width", 1) == 1) ? true : false;
	
	var domain_title_height = $('#DomainTablePane').find('.ui-jqgrid-titlebar').outerHeight();
	var domain_header_height = $('#DomainTablePane').find('.ui-jqgrid-htable').outerHeight();
	var domain_pager_height = $('#pg_DomainTablePager').height();
	
	var domaintablewidth = $("#toppane").width()-(11*2);
	var domaintableheight = $("#toppane").height()-domain_title_height-domain_pager_height-domain_header_height-20-4;
	jQuery("#DomainTable").setGridWidth(domaintablewidth, DOMAINGRID_AUTO_WIDTH); 
	jQuery("#DomainTable").setGridHeight(domaintableheight);
		
	var lph = $("#leftpane").height();
	var tabh = $(".ui-tabs-nav").height() + 6; 
	var ctw = $("#leftpane").width()-(10*2);
	
	if($('#DomainCategoryTable').is(':visible'))
	{
		domain_pager_height = $('#pg_DomainCategoryTablePager').height();
		domain_header_height = $('#gbox_DomainCategoryTable').find('.ui-jqgrid-htable').outerHeight();
		var cth = $("#leftpane").height()-domain_pager_height-domain_header_height-tabh-20-4;
		jQuery("#DomainCategoryTable").setGridWidth(ctw, true); 
		jQuery("#DomainCategoryTable").setGridHeight(cth); 
	}
	else if($('#DomainQueryTable').is(':visible'))
	{
		domain_pager_height = $('#pg_DomainQueryTablePager').height();
		domain_header_height = $('#gbox_DomainQueryTable').find('.ui-jqgrid-htable').outerHeight();
		var qth = $("#leftpane").height()-domain_pager_height-domain_header_height-tabh-20-4;
		jQuery("#DomainQueryTable").setGridWidth(ctw, true); 
		jQuery("#DomainQueryTable").setGridHeight(qth); 
	}
	
	var bph = $("#bottompane").height();
	var tabh = $('#DetailsTabView').find(".ui-tabs-nav").height() + 6; 
	var dtw = $("#bottompane").width()-(10*2);
	var dth = $("#bottompane").height()-tabh-24+8;
	jQuery("#registrywhois").css('height', dth); 
	jQuery("#registrywhois").css('width', dtw);
	jQuery("#registrarwhois").css('height', dth); 
	jQuery("#registrarwhois").css('width', dtw);
	jQuery("#ipwhois").css('height', dth); 
	jQuery("#ipwhois").css('width', dtw);
	jQuery("#subdomains").css('height', dth); 
	jQuery("#oltools").css('height', dth); 
	jQuery("#oltools").css('width', dtw);
	jQuery("#about").css('height', dth); 
	jQuery("#about").css('width', dtw);
	jQuery("#luqinfo").css('height', dth); 
	jQuery("#dataview").css('height', dth); 
	//jQuery(".luqstatus").css('height', dth); 
	//jQuery(".luqcontrol").css('height', dth); 
	//jQuery(".luqcontrol").css('min-height', dth-24);  // padding (top/bottom) of parent = 12px;
	jQuery("#DetailsTabView").css('width', dtw);
	jQuery("#DetailsTabView").css('height', dth+tabh); 
	
	if($('#SubdomainTable').is(':visible'))
	{
		domain_pager_height = $('#pg_SubdomainTablePager').height();
		domain_header_height = $('#gbox_SubdomainTable').find('.ui-jqgrid-htable').outerHeight();
		jQuery("#SubdomainTable").setGridWidth(dtw, true); 
		jQuery("#SubdomainTable").setGridHeight($("#bottompane").height()-tabh-domain_pager_height-domain_title_height-domain_header_height-20); 
	}
	if($('#SSLTable').is(':visible'))
	{
		domain_pager_height = $('#pg_SSLTablePager').height();
		domain_header_height = $('#gbox_SSLTable').find('.ui-jqgrid-htable').outerHeight();
		jQuery("#SSLTable").setGridWidth(dtw, true); 
		jQuery("#SSLTable").setGridHeight($("#bottompane").height()-tabh-domain_pager_height-domain_title_height-domain_header_height-20); 
	}
	
	if($('#columnsetup').is(':visible'))
		positionColumnSetupWindow();
	
	if($('#dnscolsetup').is(':visible'))
		positionDNSColumnSetupWindow();
	
	if($('#sslcolsetup').is(':visible'))
		positionSSLColumnSetupWindow();
	
	if($('#useradmin').is(':visible'))
		positionUserAdminWindow();
	
	if($('#customcolumns').is(':visible'))
		positionCustomColumnsWindow();
	
	if($('#mpanel-bulkedit').is(':visible'))
		positionBulkEditWindow();
	
	// Custom Queries is always visible.
	positionCustomQueriesWindow();
	
	positionHider();
}

/////////////////////////////////////////////////////////////////////////////////////////

function positionColumnSetupWindow()
{
	var dheight = $('.panel-outer').outerHeight()-140;
	$('#displaylist').css('max-height', dheight);
}

/////////////////////////////////////////////////////////////////////////////////////////

function positionDNSColumnSetupWindow()
{
	var dheight = $('.panel-outer').outerHeight()-140;
	$('#dnsdisplaylist').css('max-height', dheight);
}

/////////////////////////////////////////////////////////////////////////////////////////

function positionSSLColumnSetupWindow()
{
	var dheight = $('.panel-outer').outerHeight()-140;
	$('#ssldisplaylist').css('max-height', dheight);
}

/////////////////////////////////////////////////////////////////////////////////////////

function positionCustomColumnsWindow()
{
	var ht = $('#customcolumns-edit').height();
	$('#domaincolumns').css('height', ht-$('#cch4').outerHeight());
}

/////////////////////////////////////////////////////////////////////////////////////////

function themeChanged()
{
	var bgcolor = $('.ui-widget-content').css('background-color');
	var color = $('.ui-widget-content').css('color');
	var abgcolor = bgcolor;
	if(abgcolor.indexOf('a') == -1)
		abgcolor = abgcolor.replace(')', ', 0.9)').replace('rgb', 'rgba');
	$('body').css('background-color', bgcolor);
	$('#header').css('background-color', bgcolor);
	$('#footer').css('background-color', bgcolor);
	$('#header').css('color', color);
	$('#footer').css('color', color);
	
	var altrowcolor = 'rgba(255,255,255,0.2)';
	if(bgcolor.indexOf('a') == -1)
	{
		var ic = getContrastYIQ(bgcolor);
		if(ic > 125)
		{
			$("#logo").attr("src", logo_image_dark);
			$("#menu-logo").attr("src", logo_image_dark);
		}
		else
		{
			$("#logo").attr("src", logo_image_light);
			$("#menu-logo").attr("src", logo_image_light);
		}
		if(ic >= 60)
			altrowcolor = ColorLuminance(rgb2hex(bgcolor), -0.05);
	}
	$('.gridAltRowClass').css('background-color', altrowcolor);

	bgcolor = $('.ui-state-default').css('background-color');
	color = $('.ui-state-default').css('color');
	abgcolor = bgcolor;
	if(abgcolor.indexOf('a') == -1)
		abgcolor = abgcolor.replace(')', ', 0.5)').replace('rgb', 'rgba');
	var brcolor = $('.ui-state-default').css('border-color');
	
	var btncolor = $('.ui-state-default').css('background-color');
	var btnbordercolor = ColorLuminance(rgb2hex(bgcolor), -0.3);
	var btnmenucolor = ColorLuminance(rgb2hex(bgcolor), -0.1);
	$('.btn-navtb').css('background-color', btncolor);
	$('.btn-navtb').css('border-color', btnbordercolor);
	$('.btn-menu').css('background-color', btnmenucolor);
	$('.btn-menu').css('border-color', btncolor);
	var btnhighlightcolor = $('.ui-state-highlight').css('background-color');
	var btnid = get_buttonid_from_displaygroup_name(getCookie('display-group', "date_columns_array"));
	$('#'+btnid).css("background-color", btnhighlightcolor);
	
	var bg = $('.ui-widget-header').css('background');
	if(bg == "")
	{
		var bg2 = $('.ui-widget-header').css('background-image');
		var bg3 = $('.ui-widget-header').css('background-repeat');
		var bg4 = $('.ui-widget-header').css('background-color');
		bg = bg2+" "+bg3+" "+bg4;
	}
		
	var n = bg.search(/repeat /i);
	if(n >= 0)
		$('#popmenu').css('background', bg);
	else
		$('#popmenu').css('background-color', bgcolor);
	$('#popmenu').css('color', color);
		
	bgcolor = $('.ui-widget-header').css('background-color');
	color = $('.ui-widget-header').css('color');
	var contrast = getContrastYIQ(bgcolor);
	abgcolor = bgcolor;
	if(abgcolor.indexOf('a') == -1)
		abgcolor = abgcolor.replace(')', ', 0.5)').replace('rgb', 'rgba');
	$('.gutter').css('background-color', abgcolor);
	$('#header').css('border-color', abgcolor);
	$('#footer').css('border-color', abgcolor);
	if(contrast > 125)
	{
		$('.gutter.gutter-vertical').css('background-image', 'url(' + split_hgrip_image_dark + ')');
		$('.gutter.gutter-horizontal').css('background-image', 'url(' + split_vgrip_image_dark + ')');
	}
	
	$('#DetailsPane h3').css('border-bottom-color', bgcolor);
	$('#DetailsTabView').css('padding', 0);
	
	bgcolor = $('.ui-state-default').css('background-color');
	color = $('.ui-state-default').css('color');
	abgcolor = bgcolor;
	if(abgcolor.indexOf('a') == -1)
		abgcolor = abgcolor.replace(')', ', 0.5)').replace('rgb', 'rgba');
	$('.panel').css('background-color', bgcolor);
	$('.panel').css('color', color);
	$('.panel h3').css('border-bottom', "0px dotted " + color);
	$('hr.panelruler').css('border-bottom', "1px dotted " + color);
	$('.categorychecklist').css('border', "1px dotted " + color);
	$('.panel-outer').css('background-color', abgcolor);
	$('.panel-outer-opaque').css('background-color', bgcolor);
	$('.panelwell').css('background-color', abgcolor);
	$('.panelwell').css('border-color', color);
	$('.panelwell').css('color', color); 
	$('.ui-widget-content .panelwell').css('color', $('.ui-widget-content').css('color'));
	abgcolor = bgcolor;
	if(abgcolor.indexOf('a') == -1)
		abgcolor = abgcolor.replace(')', ', 0.7)').replace('rgb', 'rgba');
	$('#navbarmenu .panel').css('background-color', abgcolor);
	$('.navruler').css('border-color', color);
	
	$('.dialogWithShadow  > .ui-dialog-content').css('background-color', bgcolor);
	$('.dialogWithShadow  > .ui-dialog-content').css('color', color);
	$('.dialogWithShadow  > .ui-dialog-buttonpane').css('background-color', bgcolor);
	$('.dialogWithShadow  > .ui-dialog-buttonpane').css('color', color);
	$('.dialogWithShadow  > .ui-dialog-buttonpane').css('border-top-color', color);
	$('.dialogWithShadow').css('border', '8px solid ' + abgcolor);
	btnbordercolor = ColorLuminance(rgb2hex(bgcolor), -0.3);
	$('.dialogWithShadow .ui-button').css('border', '1px solid ' + btnbordercolor);
	
	$('.ui-jqdialog-content').css('background-color', bgcolor);
	$('.ui-jqdialog-content').css('color', color);
	
	bgcolor = $('.ui-widget-header').css('background-color');
	color = $('.ui-widget-header').css('color');
	$('.panel h3').css('background-color', bgcolor);
	$('.panel h3').css('color', color);
	
	//$('.btn-nav, .btn-dgroup').css('background-color', bgcolor);
	//$('.btn-nav, .btn-dgroup').css('color', color);
}

/////////////////////////////////////////////////////////////////////////////////////////
