/////////////////////////////////////////////////////////////////////////////////////////
// subgrids.js
// Watch My Domains SED v3
// (c) Softnik Technologies. All rights reserved.
/////////////////////////////////////////////////////////////////////////////////////////

var dns_table_jqgrid = null;
var ssl_table_jqgrid = null;

/////////////////////////////////////////////////////////////////////////////////////////

$(function() 
{
	LoadSubdomainGrid();
	LoadSSLGrid();
	
	$('#addsubd-submit').click(function(event) { event.preventDefault(); addSubDomains(); });
});


/////////////////////////////////////////////////////////////////////////////////////////

function LoadSubdomainGrid()
{
	var unloaded = false;
	if(dns_table_jqgrid != null)
	{
		dns_table_jqgrid.GridUnload();
		unloaded = true;
	}
	
	dns_table_jqgrid = jQuery("#SubdomainTable").jqGrid({
		hidegrid: false,
		height: 400,
		width: 451,
		altRows:true,
		altclass: "gridAltRowClass",
		url: base_grid_ajax_url + '?' + DGA_SUBDOMAIN_GRID,
		editurl: base_grid_ajax_url + '?' + DGA_SUBDOMAIN_GRID_EDIT,
		datatype: "json",
		colModel: subdomaingrid_columns_array,
		rowNum:100,
		rowList:[100,200,500],
		rownumWidth: 50,
		rownumbers: true,
		viewrecords: false,
		caption:"DNS",
		multiselect: false,
		pager: "#SubdomainTablePager",
		scrollOffset:18,
		sortname: 'id',
		shrinkToFit: true,
		scroll:1,
		loadError: function (jqXHR, textStatus, errorThrown) 
		{
			gridSessionTimedoutError(jqXHR);
		},
		loadComplete : function () 
		{
			themeChanged();
        },
		beforeRequest: function() 
		{
			var sid = 1000000000;
			var selids = jQuery("#DomainTable").getGridParam("selarrrow"); 
			if(selids != null && selids.length == 1)
				sid = selids[0];

			var columns = jQuery("#SubdomainTable").getGridParam("colModel");
			var colnum = columns.length;
			var edurl = base_grid_ajax_url + "?" + DGA_SUBDOMAIN_GRID_EDIT + "&sid=" + sid;
			var durl = base_grid_ajax_url + "?" + DGA_SUBDOMAIN_GRID + "&sid=" + sid + "&columns=hid,";
			for(i = 0; i < colnum; i++)
			{
				if(columns[i].name != "rn" && columns[i].name != "cb")
				{
					durl += encodeURIComponent(columns[i].name);
					durl += ",";
				}
			}
			if(jQuery("#SubdomainTable").setGridParam('url') !== durl)
				jQuery("#SubdomainTable").setGridParam({url:durl});
			if(jQuery("#SubdomainTable").setGridParam('editurl') !== edurl)
				jQuery("#SubdomainTable").setGridParam({editurl:edurl});
		}
	});
	
	var aedit = (user_access_rights == 0 ? false : true);
	var adel = (user_access_rights == 1 ? true : false);
	jQuery("#SubdomainTable").navGrid('#SubdomainTablePager', {add:false,edit:aedit,del:adel,search:false},
	{	// Edit
		width: 'auto',
		viewPagerButtons: false,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodSubdomainTable');
			setGridDialogColors();
		},
		afterComplete : function (response, postdata, formid)
		{
			var aqid = getCookieInt('current_autoquery', 0);
			if(aqid > 0)
			{
				scrollToRow($("#SubdomainTable"), aqid);
			}
		}
	},
	{	// Add
		width: 'auto',
		closeAfterAdd: true,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodSubdomainTable');
			setGridDialogColors();
		},
		beforeShowForm: function () 
		{
			$('<span class="pull-left"<a href="#"><span class="ui-icon ui-icon-newwin"></span>Help</a></span>')
			.click(function() 
			{
				window.open ("docs/query-edit.php","help");
			}).addClass("fm-button ui-state-default ui-corner-all fm-button-icon-left")
			  .prependTo("#Act_Buttons>td.EditButton");  
			setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
		}
	},
	{	// Delete
		width: 'auto',
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('delmodSubdomainTable');
			setGridDialogColors();
		},
		afterComplete:function() 
		{
			$("#SSLTable").trigger("reloadGrid");
		}
	}
	);
	
	if(user_access_rights == 1 || user_access_rights == 3)
	{
		jQuery("#SubdomainTable").navButtonAdd('#SubdomainTablePager',
		{
			// Add domain names
			caption:"", 
			buttonicon:"ui-icon-plus", 
			onClickButton: function()
			{ 
				onPanelButtonClick('mpanel-addsubd');
				var dlist = getSelectedDomainList(5);
				dlist = dlist.replace("and", "<code>and");
				dlist = dlist.replace("more domains", "more domains</code>");
				$('.selecteddomains').html(dlist);
				return false;
			}, 
			title:'Add subdomains',
			position:"first"
		})
	}
	
	jQuery("#SubdomainTable").navButtonAdd('#SubdomainTablePager',
	{
		// setup columns
		caption:"", 
		buttonicon:"ui-icon-wrench", 
		onClickButton: function()
		{ 
			$('#btn_dnscolsetup').click();
		}, 
		title:'Setup Columns',
		position:"last"
	})
	
	centerGridTitle("SubdomainTable");
	
	if(unloaded)
	{
		var fs = getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE);
		setTableFontSize(fs);
		fixDivSizes();
		setTimeout(function(){fixDivSizes();}, 150);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function LoadSSLGrid()
{
	var unloaded = false;
	if(ssl_table_jqgrid != null)
	{
		ssl_table_jqgrid.GridUnload();
		unloaded = true;
	}
	
	ssl_table_jqgrid = jQuery("#SSLTable").jqGrid({
		hidegrid: false,
		height: 400,
		width: 451,
		altRows:true,
		altclass: "gridAltRowClass",
		url: base_grid_ajax_url + '?' + DGA_SSL_GRID,
		editurl: base_grid_ajax_url + '?' + DGA_SSL_GRID_EDIT,
		datatype: "json",
		colModel:sslgrid_columns_array,
		rowNum:100,
		rowList:[100,200,500],
		rownumWidth: 50,
		rownumbers: true,
		viewrecords: false,
		caption:"SSL",
		multiselect: false,
		pager: "#SSLTablePager",
		scrollOffset:18,
		sortname: 'id',
		shrinkToFit: true,
		scroll:1,
		loadError: function (jqXHR, textStatus, errorThrown) 
		{
			gridSessionTimedoutError(jqXHR);
		},
		onSelectRow: function(ids) 
		{
		},
		beforeSelectRow: function(rowid, e) 
		{
			if ($(this).getGridParam('selrow') == rowid) 
				return false;
			else
				return true;
        },
		loadComplete : function () 
		{
			themeChanged();
        },
		beforeRequest: function() 
		{
			var sid = 1000000000;
			var selids = jQuery("#DomainTable").getGridParam("selarrrow"); 
			if(selids != null && selids.length == 1)
				sid = selids[0];

			var columns = jQuery("#SSLTable").getGridParam("colModel");
			var colnum = columns.length;
			var edurl = base_grid_ajax_url + "?" + DGA_SSL_GRID_EDIT + "&sid=" + sid;
			var durl = base_grid_ajax_url + "?" + DGA_SSL_GRID + "&sid=" + sid + "&columns=hid,";
			for(i = 0; i < colnum; i++)
			{
				if(columns[i].name != "rn" && columns[i].name != "cb")
				{
					durl += encodeURIComponent(columns[i].name);
					durl += ",";
				}
			}
			if(jQuery("#SSLTable").setGridParam('url') !== durl)
				jQuery("#SSLTable").setGridParam({url:durl});
			if(jQuery("#SSLTable").setGridParam('editurl') !== edurl)
				jQuery("#SSLTable").setGridParam({editurl:edurl});
		}
	});
	
	var aedit = (user_access_rights == 0 ? false : true);
	var adel = (user_access_rights == 1 ? true : false);
	jQuery("#SSLTable").navGrid('#SSLTablePager', {add:false,edit:aedit,del:adel,search:false},
	{	// Edit
		width: 'auto',
		viewPagerButtons: false,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodSSLTable');
			setGridDialogColors();
		},
		afterComplete : function (response, postdata, formid)
		{
		}
	},
	{	// Add
		width: 'auto',
		closeAfterAdd: true,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodSSLTable');
			setGridDialogColors();
		}
	},
	{	// Delete
		width: 'auto',
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('delmodSSLTable');
			setGridDialogColors();
		},
		afterComplete:function() 
		{
			$("#SubdomainTable").trigger("reloadGrid");
		}
	}
	);
	
	jQuery("#SSLTable").navButtonAdd('#SSLTablePager',
	{
		// setup columns
		caption:"", 
		buttonicon:"ui-icon-wrench", 
		onClickButton: function()
		{ 
		$('#btn_sslcolsetup').click();
		}, 
		title:'Setup Columns',
		position:"last"
	})
	
	if(unloaded)
	{
		var fs = getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE);
		setTableFontSize(fs);
		fixDivSizes();
		setTimeout(function(){fixDivSizes();}, 150);
	}
	
	centerGridTitle("SSLTable");
}

