$(function()
{
	$("body").fadeIn(1000);
	
	initInterfaceDivs();
	
	$(window).bind('resize', function() {fixDivSizes();}).trigger('resize');
	themeChanged();
	
	$(".menubox").hover(function(e) 
	{ 
		var bgcolor = $('.ui-state-default').css('background-color');
		var color = $('.ui-state-default').css('color');
		var hovercolor = $('.ui-state-active').css('background-color');
		var hcolor = $('.ui-state-active').css('color');
		$(this).css("background-color", e.type === "mouseenter" ? hovercolor : bgcolor); 
		$(this).css("color", e.type === "mouseenter" ? hcolor : color); 
	});
	
    $( "#testresults" ).accordion({
		active: false,
		collapsible: true,
		heightStyle: "content"
    });
	
	$('#login-submit').click(function(event)
	{
		doLogin();
	});
	
	$("#regcode").keydown(function(event) 
	{
		if(!HandleEnterKey(event, "submit-regcode"))
			return false;
	});
	
	$("#ui-password").keydown(function(event) 
	{
		if(!HandleEnterKey(event, "login-submit"))
			return false;
	});
	
	$("#ui-user").keydown(function(event) 
	{
		if(!HandleEnterKey(event, "login-submit"))
			return false;
	});
	
	$('#submit-regcode').click(function(event)
	{
		submitRegistration();
	});
	
	showServerInfo();
	
	$('#reset_server_table').click(function(event)
	{
		event.preventDefault();
		reset_server_table();
	});
});

/////////////////////////////////////////////////////////////////////////////////////////

function fixDivSizes()
{
	var dheight = $(window).height();
	var dwidth = $(window).width();
	if(dwidth >= 768)
	{
		$('.menu-sidebar').height(dheight);
		$('.main').height(dheight-20);
	}
	else
	{
		$('.main').height(dheight-$('.menu-sidebar').outerHeight()-40);
		$('h3.heading').css('text-align', 'center');
		$('.menu-sidebar').css('height', 'auto');
	}
	var lgw = $('.lgbox').width()-200;
	if(lgw > 400)
		lgw = 400;
	$('.loginbox').css('min-width', lgw);
}

/////////////////////////////////////////////////////////////////////////////////////////

function themeChanged()
{
	var bgcolor = $('.ui-widget-content').css('background-color');
	var color = $('.ui-widget-content').css('color');
	var abgcolor = bgcolor;
	if(abgcolor.indexOf('a') == -1)
		abgcolor = abgcolor.replace(')', ', 0.9)').replace('rgb', 'rgba');
	$('body').css('background-color', bgcolor);
	$('body').css('color', color);
	var bgc = getContrastYIQ(bgcolor);
	if(bgc > 125)
		$("#loginlogo").attr("src", logo_image_dark);
	else
		$("#loginlogo").attr("src", logo_image_light);
	
	var bgcolor = $('.ui-widget-header').css('background-color');
	var color = $('.ui-widget-header').css('color');
	$('#loginsubmit').css('background', bgcolor);
	$('#loginsubmit').css('color', color);
	
	bgcolor = $('.ui-state-default').css('background-color');
	color = $('.ui-state-default').css('color');
	abgcolor = bgcolor;
	if(abgcolor.indexOf('a') == -1)
		abgcolor = abgcolor.replace(')', ', 0.5)').replace('rgb', 'rgba');
	var brcolor = $('.ui-state-default').css('border-color');
	$('.menubox').css('background', bgcolor);
	$('.menubox').css('color', color);
	$('a.menubox').css('color', color);
	$('.menubox hr').css('border-top-color', color);
	
	$('.loginbox').css('background', abgcolor);
	$('.loginbox').css('color', color);
	$('.loginbox hr').css('border-top-color', color);
	
	var bg = $('.ui-widget-header').css('background');
	if(bg == "")
	{
		var bg2 = $('.ui-widget-header').css('background-image');
		var bg3 = $('.ui-widget-header').css('background-repeat');
		var bg4 = $('.ui-widget-header').css('background-color');
		bg = bg2+" "+bg3+" "+bg4;
	}
	
	$('.menu-sidebar').css('background-color', bgcolor);
	$('.menu-sidebar').css('color', color);
	bgc = getContrastYIQ(bgcolor);
	if(bgc > 125)
		$("#menu-logo").attr("src", logo_image_dark); //'lib/css/images/logo-dark.png');
	else
		$("#menu-logo").attr("src", logo_image_light); //'lib/css/images/logo.png');
	$('.menu-sidebar hr').css('border-top-color', color);
	
	bgcolor = $('.ui-state-highlight').css('background-color');
	abgcolor = bgcolor;
	if(abgcolor.indexOf('a') == -1)
		abgcolor = abgcolor.replace(')', ', 0.5)').replace('rgb', 'rgba');
	$('.highlight').css('border-color', abgcolor);
}

/////////////////////////////////////////////////////////////////////////////////////////

function doLogin()
{
	var user = $.trim($("#ui-user").val());
	var pass = $.trim($("#ui-password").val());
	if(user != "" && pass != "")
	{
		var durl = "lib/php/ajax/auth.php";
		var datastr = 'user=' + encodeURIComponent(user) + '&pass=' + encodeURIComponent(pass);
		$.ajax(
		{
			type: 'POST',
			url: durl,
			data: datastr,
			cache: false
		}
		).done(function(data) 
		{
			var x = jQuery.parseJSON(data);
			if(x.return != "")
			{
				window.location = x.return;
				$('#login-message').html('');
				$('.loginmsg').hide();
			}
			else
			{
				$('.loginmsg').show();
				$('#login-message').html(x.errors);
			}
		}).fail(function(jqXHR, status, errorThrown) 
		{
			console.log(errorThrown);
			console.log(jqXHR.responseText);
			console.log(jqXHR.status);
		});
	}
}

/////////////////////////////////////////////////////////////////////

function submitRegistration()
{
	var regcode = encodeURIComponent($.trim($("#regcode").val()));
	if(regcode != "")
	{
		var durl = "lib/php/ajax/appsetup.php";
		var datastr = 'value=' + regcode + "&opset=" + 'license_key_code_v3';
		$.ajax(
		{
			type: 'POST',
			url: durl,
			data: datastr,
			cache: false
		}
		).done(function(data) 
		{
			var x = jQuery.parseJSON(data);
			window.location = 'main.php';
		}).fail(function(jqXHR, status, errorThrown) 
		{
			console.log(errorThrown);
			console.log(jqXHR.responseText);
			console.log(jqXHR.status);
		});
	}
}

/////////////////////////////////////////////////////////////////////

function HandleEnterKey(e, submitid)
{
	var keycode = (e.keyCode ? e.keyCode : (e.which ? e.which : e.charCode));
	if (keycode == 13)
	{
		if(submitid != "")
			$("#" + submitid).click();
		return false;
	}
	return true;
}

/////////////////////////////////////////////////////////////////////

function show_server_info() 
{
	$.ajax({
		type: 'POST',
		url: 'lib/php/ajax/appsetup.php?gsst&nsi',
		cache: false
	}).done(function(data) {
		var x = jQuery.parseJSON(data);
		sessionValidate(x.validate);
		if(x.status == "ok")
		{
			$("#servertable").html(x.table);
			$("#queue-status").html(x.qsize);
		}
	}).fail(function(jqXHR,status, errorThrown) {
	});
}

/////////////////////////////////////////////////////////////////////

function reset_server_table() 
{
	$.ajax({
		type: 'POST',
		url: 'lib/php/ajax/appsetup.php?csst',
		cache: false
	}).done(function(data) {
		var x = jQuery.parseJSON(data);
		if(x.status == "ok")
		{
			show_server_info();
		}
	}).fail(function(jqXHR,status, errorThrown) {
	});
}

/////////////////////////////////////////////////////////////////////

function showServerInfo()
{
	if($("#servertable").length != 0) 
	{
		show_server_info();
		var switcher;
		switcher = setInterval(show_server_info, 30000);
		$("#info_refresh").click(function(e){show_server_info();e.preventDefault();});
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function sessionValidate(status)
{
	if(status == 1 || status == -1)
	{
		reason = (status == 1 ? "timeout" : "badsession");
		var location = "login.php?r=" + reason;
		location += "&redir=monitor.php";
		window.location = location;
		return false;
	}
	return true;
}

/////////////////////////////////////////////////////////////////////

