
$(function() 
{	
	var cid = getCookieInt('current_category', 0);
	$.cookie('current_category', cid == 0 ? default_category_selection : cid);
	$.cookie('current_autoquery', "0");
	$.cookie('current_customquery', "0");
	
	initCustomSQLTab();
	$('#customqueries-refresh').button();
	$('#customqueries-save').button();
	$('#customqueries-reset').button();
	$('#customqueries-refresh').click(function(event) { event.preventDefault(); selectCustomQuery(); });
	$('#customqueries-save').click(function(event) { event.preventDefault(); SaveCustomQuery(); });
	$('#customqueries-reset').click(function(event) { event.preventDefault(); selectCategory(1); $("#DomainCategoryTable").setSelection(1, false); });
	
	LoadDomainCategoryGrid();
	LoadDomainQueryGrid();
});

/////////////////////////////////////////////////////////////////////////////////////////

function LoadDomainCategoryGrid()
{
	jQuery("#DomainCategoryTable").jqGrid({
		hidegrid: false,
		height: 400,
		width: 150,
		altRows:true,
		altclass: "gridAltRowClass",
		url: base_grid_ajax_url + '?' + DGA_CATEGORY_GRID,
		editurl: base_grid_ajax_url + '?' + DGA_CATEGORY_GRID_EDIT,
		datatype: "json",
		colNames:['Category Names','SortOrder'],
		colModel:[
			{name:'CategoryName', width:118,sortable:false,editable:true,editoptions:{size:35}, classes:"dccell category-name-cell"},
			{name:'SortOrder', hidden: true}

		],
		rowNum:1000,
		rowList:[],
		rownumWidth: 50,
		rownumbers: true,
		viewrecords: false,
		caption:"",
		multiselect: false,
		pager: "#DomainCategoryTablePager",
		scrollOffset:18,
		sortname: 'SortOrder',
		sortorder: 'desc',
		scroll:1,
		shrinkToFit: true,
		loadError: function (jqXHR, textStatus, errorThrown) 
		{
			gridSessionTimedoutError(jqXHR);
		},
		onSelectRow: function(ids) 
		{
			if(ids == null) 
				ids = 0;
			var cid = getCookieInt('current_category', 0);
			if(cid != ids && ids > 0)
				selectCategory(ids);
		},
		beforeSelectRow: function(rowid, e) 
		{
			if ($(this).getGridParam('selrow') == rowid) 
				return false;
			else
				return true;
        },
		loadComplete : function () 
		{
			themeChanged();
			highlightCategoriesOfCurrentDomain();
        },
		gridComplete : function()
		{
			var cc = getCookieInt('current_category', 0);
			$("#DomainCategoryTable").setGridParam({scrollrows:false}); 
			$("#DomainCategoryTable").setSelection(cc, true);
			scrollToRow($("#DomainCategoryTable"), cc);
			setDomainTableCaption();
		}
	});
	
	var cmod = is_an_admin_user ? true : false;
	jQuery("#DomainCategoryTable").navGrid('#DomainCategoryTablePager', {add:cmod,edit:cmod,del:cmod,search:false},
	{	// Edit
		width: 'auto',
		viewPagerButtons: false,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodDomainCategoryTable');
			setGridDialogColors();
		}
	},
	{	// Add
		width: 'auto',
		closeOnEscape:true,
		closeAfterAdd: true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodDomainCategoryTable');
			setGridDialogColors();
		}
	},
	{	// Delete
		width: 'auto',
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('delmodDomainCategoryTable');
			setGridDialogColors();
		}
	}
	);
	
	if(is_an_admin_user)
		addCategoryOrderButtons();
}

/////////////////////////////////////////////////////////////////////////////////////////

function LoadDomainQueryGrid()
{
	jQuery("#DomainQueryTable").jqGrid({
		hidegrid: false,
		height: 400,
		width: 451,
		altRows:true,
		altclass: "gridAltRowClass",
		url: base_grid_ajax_url + '?qg',
		editurl: base_grid_ajax_url + '?qge',
		datatype: "json",
		colNames:['Auto Queries', 'Query'],
		colModel:[
			{name:'Name', width: 118,sortable:true,editable:true, editoptions:{size:50}, formoptions:{label: 'Name'}, classes:"aqcell auto-query-cell"},
			{name:'Query', width: 118,sortable:true,editable:true, editoptions:{rows:'4',cols:'50'}, formoptions:{label: 'Query'}, editrules:{edithidden:true}, hidden: true, edittype: 'textarea', classes:"aqcell auto-query-cell"}
		],
		rowNum:1000,
		rowList:[],
		rownumWidth: 50,
		rownumbers: true,
		viewrecords: false,
		caption:"",
		multiselect: false,
		pager: "#DomainQueryTablePager",
		scrollOffset:18,
		sortname: 'id',
		shrinkToFit: true,
		scroll:1,
		loadError: function (jqXHR, textStatus, errorThrown) 
		{
			gridSessionTimedoutError(jqXHR);
		},
		onSelectRow: function(ids) 
		{
			if(ids == null) 
				ids = 0;
			selectAutoQuery(ids);
		},
		beforeSelectRow: function(rowid, e) 
		{
			if ($(this).getGridParam('selrow') == rowid) 
				return false;
			else
				return true;
        },
		loadComplete : function () 
		{
			themeChanged();
        }
	});
	
	jQuery("#DomainQueryTable").jqGrid(
		'filterToolbar',{
			stringResult: true,
			searchOnEnter : false
		}
	);
	
	var cmod = is_an_admin_user ? true : false;
	jQuery("#DomainQueryTable").navGrid('#DomainQueryTablePager', {add:cmod,edit:cmod,del:cmod,search:false},
	{	// Edit
		width: 'auto',
		resize: false,
		viewPagerButtons: false,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodDomainQueryTable');
			setGridDialogColors();
		},
		afterComplete : function (response, postdata, formid)
		{
			var aqid = getCookieInt('current_autoquery', 0);
			if(aqid > 0)
			{
				scrollToRow($("#DomainQueryTable"), aqid);
			}
		}
	},
	{	// Add
		width: 'auto',
		closeAfterAdd: true,
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('editmodDomainQueryTable');
			setGridDialogColors();
		},
		beforeShowForm: function () 
		{
			$('<span class="pull-left"<a href="#"><span class="ui-icon ui-icon-newwin"></span>Help</a></span>')
			.click(function() 
			{
				window.open ("docs/query-edit.php","help");
			}).addClass("fm-button ui-state-default ui-corner-all fm-button-icon-left")
			  .prependTo("#Act_Buttons>td.EditButton");  
			setTableFontSize(getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE));
		}
	},
	{	// Delete
		width: 'auto',
		closeOnEscape:true,
		afterShowForm: function(form) 
		{
			centerDialog('delmodDomainQueryTable');
			setGridDialogColors();
		}
	}
	);
}
