/////////////////////////////////////////////////////////////////////////////////////////

var GET_CATEGORIES_FOR_DOMAIN 		= "gcd";
var GET_ALL_DOMAIN_COLUMNS 			= "gacol";

var ASA_GET_USER_ADMIN_DATA			= "gua";
var ASA_ADD_TO_CATEGORIES			= "atc";
var ASA_REMOVE_FROM_CATEGORIES		= "rfc";
var ASA_DO_CUSTOM_QUERY				= "dcq";
var ASA_SAVE_QUERY_AS_AUTOQUERY		= "scqa";
var ASA_INSERT_CUSTOM_COLUMN		= "icc";
var ASA_DELETE_CUSTOM_COLUMN		= "dcc";
var ASA_DELETE_ORPHAN_COLUMN		= "doc";
var ASA_BULK_EDIT_COLUMN			= "bec";
var ASA_BULK_EDIT_SD_COLUMN			= "besdc";
var ASA_GET_EDITABLE_DOMAIN_COLUMNS = "gedc";
var ASA_GET_EDITABLE_SUBDOMAIN_COLUMNS = "gesdc"
var ASA_SAVE_SUPER_ADMIN			= "ssau";
var ASA_SAVE_USER_DETAILS			= "sud";
var ASA_GET_USER_DETAILS			= "gud";
var ASA_SET_USER_PASSWORD			= "sup";
var ASA_RESET_DOMAIN_MANUAL_EDIT	= "rmed";
var ASA_RESET_SUBDOMAIN_MANUAL_EDIT = "rmesd";

var DGA_GET_TLD_INFO				= "gti";
var DGA_GET_SERVER_INFO				= "gsi";
var DGA_SET_TLD_INFO				= "sti";
var DGA_SET_SERVER_FOR_TLD			= "ssft";
var DGA_DOMAIN_LOOKUP				= "dlu";
var DGA_EXPORT_DATA					= "exportdata"
var DGA_DOMAIN_CSV_UPLOAD			= "csvdu";
var DGA_SUBDOMAIN_CSV_UPLOAD		= "csvsdu";

var DGA_DOMAIN_GRID					= "dg";
var DGA_DOMAIN_GRID_EDIT			= "dge";
var DGA_CATEGORY_GRID				= "cg";
var DGA_CATEGORY_GRID_EDIT			= "cge";
var DGA_QUERY_GRID					= "qg";
var DGA_QUERY_GRID_EDIT				= "qge";
var DGA_USER_GRID					= "ug";
var DGA_USER_GRID_EDIT				= "uge";
var DGA_SUBDOMAIN_GRID				= "sdg";
var DGA_SUBDOMAIN_GRID_EDIT			= "sdge";
var DGA_SSL_GRID					= "sslg";
var DGA_SSL_GRID_EDIT				= "sslge";

/////////////////////////////////////////////////////////////////////////////////////////

var DEFAULT_TABLE_FONT_SIZE			= 13;

/////////////////////////////////////////////////////////////////////////////////////////

function initInterfaceDivs()
{
	// Add a bunch of dummy divs so that we can adjust the colors
	$("#header").append('<div class="ui-widget-content" style="display:none"></div>');
	$("#header").append('<div class="ui-widget-header" style="display:none"></div>');
	$("#header").append('<div class="ui-state-default" style="display:none"></div>');
	$("#header").append('<div class="ui-state-highlight" style="display:none"></div>');
	$("#header").append('<div class="ui-state-active" style="display:none"></div>');
	$("#header").append('<div class="ui-state-hover" style="display:none"></div>');
	$("#header").append('<div class="ui-state-error" style="display:none"></div>');
	$("#header").append('<div id="hider"></div>');
	$("#hider").hide();
}

/////////////////////////////////////////////////////////////////////////////////////////

function positionHider()
{
	// Hide if Visible, adjust the dimensions and then restore
	// Otherwise unwanted scrollbars may appear on window resize.
	var vis = $('#hider').is(':visible') ? true : false;
	if(vis)
		$('#hider').hide();
	$("#hider").width($( document ).width());
	$("#hider").height($( document ).height());
	if(vis)
		$('#hider').show();
}

/////////////////////////////////////////////////////////////////////////////////////////

function saveCookie(name, value)
{
	$.cookie(name, value, {expires:30});
}

/////////////////////////////////////////////////////////////////////////////////////////

function getCookie(name, defval)
{
	var value = $.cookie(name);
	if(value == "" || value == null)
		return defval;
	return value
}

/////////////////////////////////////////////////////////////////////////////////////////

function getCookieInt(name, defval)
{
	var value = $.cookie(name);
	if(value == "" || value == null)
		return defval;
	return Math.round(parseFloat(value));
}

/////////////////////////////////////////////////////////////////////////////////////////

function getCookiePercent(name, defval)
{
	var value = getCookieInt(name, defval);
	if(value < 0 || value > 100)
		value = defval;
	return value;
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_buttonid_from_displaygroup_name(dgroup)
{
	return "btn_" + dgroup.replace("_array", "_group");
}

/////////////////////////////////////////////////////////////////////////////////////////

function getContrastYIQ(colour)
{
    var r,g,b,brightness;

	if(colour.indexOf('a') > 0)
		return 0;
	
    if (colour.match(/^rgb/)) {
      colour = colour.match(/rgb\(([^)]+)\)/)[1];
      colour = colour.split(/ *, */).map(Number);
      r = colour[0];
      g = colour[1];
      b = colour[2];
    } else if ('#' == colour[0] && 7 == colour.length) {
      r = parseInt(colour.slice(1, 3), 16);
      g = parseInt(colour.slice(3, 5), 16);
      b = parseInt(colour.slice(5, 7), 16);
    } else if ('#' == colour[0] && 4 == colour.length) {
      r = parseInt(colour[1] + colour[1], 16);
      g = parseInt(colour[2] + colour[2], 16);
      b = parseInt(colour[3] + colour[3], 16);
    }

    brightness = (r * 299 + g * 587 + b * 114) / 1000;
	return brightness;
}

/////////////////////////////////////////////////////////////////////////////////////////

function ColorLuminance(hex, lum) {

	// validate hex string
	hex = String(hex).replace(/[^0-9a-f]/gi, '');
	if (hex.length < 6) {
		hex = hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2];
	}
	lum = lum || 0;

	// convert to decimal and change luminosity
	var rgb = "#", c, i;
	for (i = 0; i < 3; i++) {
		c = parseInt(hex.substr(i*2,2), 16);
		c = Math.round(Math.min(Math.max(0, c + (c * lum)), 255)).toString(16);
		rgb += ("00"+c).substr(c.length);
	}

	return rgb;
}

/////////////////////////////////////////////////////////////////////////////////////////

function rgb2hex(rgb) 
{
	if(rgb.indexOf('a') > 0)
		return rgb;
	
    if (/^#[0-9A-F]{6}$/i.test(rgb)) return rgb;

    rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
    function hex(x) {
        return ("0" + parseInt(x).toString(16)).slice(-2);
    }
    return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]);
}

/////////////////////////////////////////////////////////////////////////////////////////

function clear_form_elements(ele) 
{
    $(ele).find(':input').each(function() 
	{
        switch(this.type) {
            case 'password':
            case 'select-multiple':
            case 'select-one':
            case 'text':
            case 'textarea':
                $(this).val('');
                break;
            case 'checkbox':
            case 'radio':
                this.checked = false;
        }
    });
}

/////////////////////////////////////////////////////////////////////////////////////////
// Requires CSS for .dialogWithShadow

function custom_alert(output_msg, title_msg)
{
    if (!title_msg)
        title_msg = 'Alert';

    if (!output_msg)
        output_msg = 'No Message to Display.';
	
    $("<div></div>").html(output_msg).dialog({
        title: title_msg,
        resizable: false,
        modal: true,
		maxHeight: 400,
		dialogClass: 'dialogWithShadow customAlert',
		create: function( event, ui ) {themeCustomDialog();},
        buttons: {
            "OK": function() 
            {
                $( this ).dialog( "close" );
            }
        }
    });
}

/////////////////////////////////////////////////////////////////////////////////////////

function alert_and_exec(output_msg, execfunction)
{
    var title_msg = 'Alert';
    if (!output_msg)
        output_msg = 'No Message to Display.';
	
    $("<div></div>").html(output_msg).dialog({
        title: title_msg,
        resizable: false,
        modal: true,
		maxHeight: 400,
		dialogClass: 'dialogWithShadow customAlert',
		create: function( event, ui ) {themeCustomDialog();},
        buttons: {
            "OK": function() 
            {
                $( this ).dialog( "close" );
				execfunction();
            },
			"Cancel": function() 
			{
				$( this ).dialog( "close" );
			}
        }
    });
}

/////////////////////////////////////////////////////////////////////////////////////////

function themeCustomDialog()
{
	var bgcolor = $('.ui-state-default').css('background-color');
	var color = $('.ui-state-default').css('color');
	var abgcolor = bgcolor;
	if(abgcolor.indexOf('a') == -1)
		abgcolor = abgcolor.replace(')', ', 0.5)').replace('rgb', 'rgba');
	$('.dialogWithShadow  > .ui-dialog-content').css('background-color', bgcolor);
	$('.dialogWithShadow  > .ui-dialog-content').css('color', color);
	$('.dialogWithShadow  > .ui-dialog-buttonpane').css('background-color', bgcolor);
	$('.dialogWithShadow  > .ui-dialog-buttonpane').css('color', color);
	$('.dialogWithShadow  > .ui-dialog-buttonpane').css('border-top-color', color);
	$('.dialogWithShadow').css('border', '8px solid ' + abgcolor);
	var btnbordercolor = ColorLuminance(rgb2hex(bgcolor), -0.3);
	$('.dialogWithShadow .ui-button').css('border', '1px solid ' + btnbordercolor);
	var fs = getCookieInt("table-font-size", DEFAULT_TABLE_FONT_SIZE);
	$('.customAlert').css('font-size', fs+'px');
}

/////////////////////////////////////////////////////////////////////////////////////////

function centerGridTitle(gridid)
{
	var captionDiv = jQuery("#" + gridid)[0].grid.cDiv;
	var titleSpan = jQuery(".ui-jqgrid-title",captionDiv);
	titleSpan.css ("float", "none");
	titleSpan.parent().css ("text-align", "center");
}

/////////////////////////////////////////////////////////////////////////////////////////

function csvWrapQuotes(ptext)
{
	if(typeof ptext === 'undefined' || ptext == "" || ptext == null)
		return "\"\"";
	else
	{
		ptext = ptext.trim();
		if(ptext.indexOf("\"") > -1)
		{
			while (ptext.indexOf("\"") > -1)
				ptext = ptext.replace("\"", "{{^&}}")
			while (ptext.indexOf("{{^&}}") > -1)
				ptext = ptext.replace("{{^&}}", "\"\"")
			return '"' + ptext + '"';
		}
		if (ptext.indexOf(",") > -1 || ptext.indexOf("'") > -1)
		   return '"' + ptext + '"';
		 return ptext;
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

