<?php
###############################################################################
# Custom.login.php
# Watch My Domains SED v3
#
# Sample Custom Login Script that allows you to authenticate users yourself.
#
# Rename this to custom.login.php and copy to the installation root folder.
#
###############################################################################

// Do your login and authenticate the user in the DoCustomLoginAndGetUserID 
// function. The authenticated user should have a corresponding ID in the 
// local Watch My Domains SED user table.

function DoCustomLoginAndGetUserID()
{
	// Do the authentication.
	
	// ...
	// ...
	
	// Return a valid user-id from the user table, otherwise return false.
	// Please be careful here. The application will login as the user specified
	// in the returned user-id with no additional authentication. It is your 
	// responsibility to ensure that this user is really authenticated.
	
	return 1;
}

###############################################################################

define("USE_AUTH_DB","TRUE");

###############################################################################

require_once("lib/php/basic.php");				# Base Functions.
require_once("lib/php/ui/ui.php");				# UI Functions.
require_once("lib/php/pdo/dbinit.php");			# Database
require_once("lib/php/config.check.php");		# Load the configuration.

###############################################################################

$auth = validateSession();
if($auth == 0)
	interfaceRedir();

###############################################################################

$msg  = "<h3>We have a problem!</h3><hr>";
$userid = DoCustomLoginAndGetUserID();
if($userid !== false)
{
	$pdo = init_db();
	$uinfo = $pdo->getTableData($pdo->user_table, "*", "WHERE id=?", array($userid));
	if($uinfo !== false)
	{
		if(is_array($uinfo) && count($uinfo) && count($uinfo[0]))
		{
			$uinfo = $uinfo[0];
			$pdo->addAuthLog(true);
			$userinfo['uid'] = $userid;
			$userinfo['fullname'] = $uinfo['full_name'];
			$userinfo['displayname'] = $uinfo['display_name'];
			$userinfo['name'] = $uinfo['name'];
			$userinfo['readwrite'] = $uinfo['readwrite'];
			$userinfo['admin'] = false;
			$userinfo['lastsignin'] = $uinfo['last_sign_in_stamp'];
			
			$sql = "SELECT user_id, group_id FROM " . $pdo->group_access_table . " WHERE user_id = ? AND group_id = 1";
			$stmt = $pdo->db_connect_handle->prepare($sql);
			$stmt->execute(array($userid));
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			if(count($rows) == 1)
				$userinfo['admin'] = true;
			
			// Find all access rights for the user.
			$categoryTable = $pdo->getCategoryTableName();
			
			$sql = "SELECT user_id, cat_id FROM " .  $pdo->category_access_table . " WHERE user_id = ?";
			$stmt = $pdo->db_connect_handle->prepare($sql);
			$stmt->execute(array($userid));
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			
			$permissions = array();
			foreach($rows as $row)
			{
				$entry['name'] = $pdo->getSingleEntry($categoryTable, "CategoryID", $row['cat_id'], "CategoryName");
				$entry['id'] = $row['cat_id'];
				$permissions[]  = $entry;
			}			
			
			$stmt = $pdo->db_connect_handle->prepare("UPDATE " . $pdo->user_table . " SET last_sign_in_stamp=? WHERE id=?");
			$stmt->execute(array(date("Y-m-d H:i:s"), $userid));
			
			$returnurl = $pdo->doLogin($userinfo, $permissions);
			header("Location: $returnurl");
			exit;
		}
	}
	$msg .= "Unable to login, The specified user was not found!";
}
else
	$msg .= "Unable to login or authentication failed!";
show_message($msg);

###############################################################################
?>
