<?php
	
require_once("lib/php/config.check.php");
require_once("config.php");
require_once("lib/php/base.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Only admin users can use this script.
# If user authentication is disabled, everyone is an admin user!

session_start();
check_authentication_login();
if(is_admin_user() == false)
{
	header("Location: " . get_base_path());
	exit;
}
doSessionSwipeIn();

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function get_base_dir()
{
	return realpath(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	$jqtheme = get_theme_name("");
	$title = "";
	if($title == "")
		$title = "Domain Portfolio Manager - Whois Setup";
	$panesjs = "cfgpanes.js";
	$grid_url_file = get_grid_base_file_name();

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
		<title><?php echo $title; ?></title>
		<meta http-equiv="Content-Language" content="en">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link rel="shortcut icon" type="image/x-icon" href="lib/css/img/favicon.ico">
		
		<link type="text/css" href="lib/css/jqueryui/<?php echo $jqtheme; ?>/jquery-ui-1.8.7.custom.css" rel="stylesheet">
		<link type="text/css" href="lib/css/jqueryui/<?php echo $jqtheme; ?>/splitter.1.51.css" rel="stylesheet" media="screen">
		<link type="text/css" href="lib/css/jqueryui/splitter.1.51.css" rel="stylesheet" media="screen">
		<link type="text/css" href="lib/css/jqueryui/ui.jqgrid.css" rel="stylesheet" media="screen">

		<script type="text/javascript" src="lib/js/jquery/jquery-1.5.1.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery.cookie.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery-ui-1.8.7.noeffects.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/splitter.1.51.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/i18n/grid.locale-en.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery.jqGrid.3.8.2.min.js"></script>
		
		<link type="text/css" href="lib/css/default.css" rel="stylesheet" media="all">
		<link type="text/css" href="lib/css/<?php echo $jqtheme; ?>.css" rel="stylesheet" media="all">
		<script type="text/javascript" src="lib/js/<?php echo $panesjs; ?>"></script>
		<script type="text/javascript" src="lib/js/tldgrid.js"></script>
		<script type="text/javascript" src="lib/js/buttons.js"></script>
		<script type="text/javascript" src="lib/js/add.js"></script>
<?php
		if(get_main_logo_image() != "")
			echo "\t\t<style> .mainlogo {background-image: url('" . get_main_logo_image() . "');}</style>\n";
?>
		<script type="text/javascript">
			var grid_url_base = "lib/php/<?php echo $grid_url_file; ?>";
		</script>
</head>

<body>
		<div id="header">
		<div class="mainlogo">&nbsp;</div>
		<div class="navbar">
			<button id="menu"></button>
			&nbsp;&nbsp;
			<button id="pfolio"></button>
			&nbsp;&nbsp;
		<?php
			if(is_admin_user())
			{
		?>
				<button id="subdomains"></button>
				<button id="report"></button>
				<button id="appsetup"></button>
				<button id="admin"></button>
		<?php
			}
			show_link_buttons();
			if(is_user_auth_enabled())
			{
		?>
				&nbsp;&nbsp;
				<button id="logout"></button>
		<?php
			}
		?>
		</div>
		<div class="clear">&nbsp;</div>
	</div>

	<div id="ConfigVSplitter">
		<div id="ControlPane">
			<div class="Padded10">
				<table id="DomainTLDTable"></table>
				<div id="pagerDomainTLDView"></div>
			</div>
		</div> <!-- #ControlPane -->
	  
		<div id="RightPane" style="overflow: auto;">
			<div id="ConfigPane">
				<div class="Padded10">
					<div id="WhoisSetupTabView" style="overflow:auto;">
						<ul>
							<li><a href="#whoissetup">Whois Server Config</a></li>
						</ul>
							
						<div id="whoissetup">
							<div class="leftbox" style="width:65%;">
							<div id="formhead"><h3>Whois Server</h3></div>
							<div id="tldform">
								<p>
								<label for "whois_server_ui">Whois Server</label>
								<input type="text" name="server" size="32" value="" id="whois_server_ui">
								<input type="submit" value="Set" id="whois_server_ui_submit">
								</p>
								
								<p>
								<label for "port_ui">Port</label>
								<input type="text" name="server" size="12" value="" id="port_ui">
								</p>
								
								<p>
								<label for "query_string_ui">Query String</label>
								<input type="text" name="server" size="32" value="" id="query_string_ui">
								</p>
								
								<p>
								<label for "search_token_ui">Search Token</label>
								<input type="text" name="server" size="32" value="" id="search_token_ui">
								</p>
								
								<p>
								<label for "date_format_ui">Date Format</label>
								<select id="date_format_ui">
									<option value="auto">auto</option>
									<option value="ddmm">ddmm</option>
									<option value="mmdd">mmdd</option>
									<option value="ddyy">ddyy</option>
									<option value="yydd">yydd</option>
									<option value="yymmdd">yymmdd</option>
									<option value="ddmmyy">ddmmyy</option>
								</select>
								</p>
								
								<!--
								<p>
								<label for "max_connesctions_ui">Max Connections</label>
								<input type="text" name="server" size="12" value="" id="max_connesctions_ui">
								</p>
								-->
								<p>
								<label for "connection_interval_ui">Connection Interval</label>
								<input type="text" name="server" size="12" value="" id="connection_interval_ui">
								</p>
								
								<p>
								<label for "xlate_array_ui">Extraction Tokens</label>
								<textarea rows="15" cols="45" id="xlate_array_ui"></textarea>
								</p>
								
								<p>
								<label for "http_proxy_ui">HTTP Proxy</label>
								<input type="text" name="server" size="60" value="" id="http_proxy_ui">
								</p>
								
								<p>
								<label for "ip_blocked_text_ui">IP Ban Text Token</label>
								<input type="text" name="server" size="60" value="" id="ip_blocked_text_ui">
								</p>
								
								<p>
								<label for "whois_server_stopped_ui">Stop Connections</label>
								<input id="whois_server_stopped_ui" type="checkbox" name="whois_server_stopped_ui" value="1">
								</p>
								
								
								<p>
								<label for "ui_whois_server_data_submit">&nbsp;</label>
								<input type="submit" value="Submit Changes" id="ui_whois_server_data_submit">
								</p>
								<br>
								<p>
								<label for "ui_whois_server_last_connect">Last Connected At</label>
								<span id="ui_whois_server_last_connect"></span>
								<input type="submit" value="Reset Last Connected Time" id="whois_server_conect_time_reset">
								</p>
								
								<p>
								<label>&nbsp;</label>
								<div id="whois_server_mismatch"></div>
								</p>
							</div>
							</div>
							<div class="rightbox" style="width:30%; text-align:left; padding-left:20px;">
								<p>&nbsp;</p>
								<p>&nbsp;</p>
								<p>&nbsp;</p>
								<h3>Extraction Tokens</h3>
								<p>Here are some Example Tokens</p>
								<hr>
								<p>[*]=&gt;*</p>
								<p>Registrant Address:=&gt;address</p>
								<p>Registrant:@@:@@Name:=&gt;owner</p>
								<p>Renewal date{nl}=&gt;registrar_expiry</p>
								<p>Expiry date:=&gt;expiry_date</p>
								<p>Name servers:{ml}=&gt;name server</p>
								<hr>
								<p>The left side contains the text token present in the raw whois text. The right side contains the 
								column to which the data should be extracted into. For additional details, please see the online documentation.</p>
								<p>The first entry ([*]=&gt;*) tells the parser to use the default tokens that are built into the application.
								In most cases you want this. However, if you are going to define all the extraction tokens manually don't insert that entry.</p>
								
								<h3>HTTP Proxy</h3>
								
								<p>Specify a web based URL for obtaining the whois data. The application will replace {D} in the URL with
								the domain name. If a proxy URL is specified, the port 43 connection will not be made.</p>
								
								<h3>IP Ban Text Token</h3>
								<p>Specify the text token found in whois output when the connections from your IP are blocked. If this
								token is found in the whois output, further connections to the whois server will be automatically stopped for the
								next 24 hours.</p>
								
								<h3>Stop Connections</h3>
								
								<p>You may use this to manually stop all connections to the whois server. Please note that the application also may set this
								when the 'IP Ban Text Token' is found in the whois output.</p>
								
							</div>
							<div class="clear"></div>
						</div>
						
					</div>
				</div>
			</div>
		</div> <!-- #RightPane -->
	</div> <!-- #ConfigVSplitter -->
	
</body>
</html>
<?php
?>
