<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2010-2013 Softnik Technologies
// Author: SK
/////////////////////////////////////////////////////////////////////////////////////////////////////////

require_once("lib/php/config.check.php");
require_once("config.php");
require_once("lib/php/base.php");
require_once("lib/php/version.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Only admin users can use this script.
# If user authentication is disabled, everyone is an admin user!

session_start();
check_authentication_login();
if(is_admin_user() == false)
{
	header("Location: " . get_base_path());
	exit;
}
doSessionSwipeIn();

/////////////////////////////////////////////////////////////////////////////////////////////////////////
connect_to_mysql_and_select_db();
/////////////////////////////////////////////////////////////////////////////////////////////////////////

if(isset($_REQUEST['q']))
{
	global $db_config_lookup_queue_table;
	
	$sqlCount = "SELECT COUNT(*) AS count from " . $db_config_lookup_queue_table;
	$countResult = mysql_query( $sqlCount );
	if($countResult !== false)
	{
		$queue = mysql_fetch_array($countResult); 
		$qsize = $queue['count'];
		$output = array();
		$output['status'] = "done";
		$output['table'] = get_installed_server_status_table();
		$output['qsize'] = "<p>Lookup Queue Size: $qsize</p>";
		echo json_encode($output);
	}
	exit;
}
else if(isset($_REQUEST['reset']))
{
	clear_installed_server_status_table();
	$scheme = "https://";
	if(empty($_SERVER['HTTPS']))
		$scheme = "http://";
	$base_url = $scheme . $_SERVER['SERVER_NAME'] . $_SERVER['PHP_SELF'];
	header('Location:' . $base_url);
	exit;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
		<title></title>
		<meta http-equiv="Content-Language" content="en">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link rel="shortcut icon" type="image/x-icon" href="lib/css/img/favicon.ico">
		<link type="text/css" href="lib/css/default.css" rel="stylesheet" media="all">
		<script type="text/javascript" src="lib/js/jquery/jquery-1.5.1.min.js"></script>
		<style>
			body, html {overflow: auto;}
			.dotline {border-bottom: 1px dotted #055C69; height:9px; margin-bottom:9px; margin-left:auto; margin-right:auto;}
			table.tb-server-status
			{
				border-collapse: collapse;
				font-family: Trebuchet MS,Verdana,Arial,sans-serif; 
				margin-left: auto;
				margin-right: auto;
				margin-top: 36px;
				margin-bottom: 0px;
				font-size: 0.9em;
				width: 960px;
			}

			table.tb-server-status td, table.tb-server-status th
			{
			  padding-left: 4px;
			  color:#000;
			  border-bottom: 1px dotted #C0C0C0;
			  border-left: 1px dotted #C0C0C0;
			  height: 32px;
			  width: 140px;
			  vertical-align: middle;
			  text-align: left;
			}
			
			table.tb-server-status th
			{
				background-color: #EEEEFF;
				color: #000;
				border-bottom: 3px solid #888;
			}

			table.tb-server-status td.status, table.tb-server-status th.status
			{
				width: 32px;
				text-align: center;
				border-left: 0px dotted #000;
			}

			table.tb-server-status tr.master
			{
				background-color: #FFEEEE;
			}
			
			#queue-status {text-align: left; margin-top: 0; font-size: 80%;}
			
			.outerbounds
			{
				width: 960px; margin-left:auto; margin-right: auto; margin-top: 24px; font-family:Trebuchet MS,Verdana,Arial,sans-serif; overflow:auto; 
			}
		</style>
		<script type="text/javascript">
			function show_server_info() 
			{
				$.ajax({
					type: 'POST',
					url: 'status.php?q',
					cache: false,
					contentType: false,
					processData: false
				}).done(function(data) {
					var x = jQuery.parseJSON(data);
					if(x.status == "done")
					{
						$("#srv-status").html(x.table);
						$("#queue-status").html(x.qsize);
					}
				}).fail(function(jqXHR,status, errorThrown) {
				});
			}
				
			function showServerInfo()
			{
				show_server_info();
				var switcher;
				switcher = setInterval(show_server_info, 30000);
				$("#info_refresh").click(function(e){show_server_info();e.preventDefault();});
			}
			
			$(function()
			{
				showServerInfo();
			});
		</script>
</head>
<body>
	<div id="serverstatus">
		<div class="outerbounds">
		<p style="text-align:center; margin-top:0px;"><img src="<?php echo get_main_logo_image(); ?>"></p>
		<h2 class="center">Status Monitor</h2>
		<hr>
		<div id="srv-status"></div>
		<div id="queue-status"></div>
		<p style="font-size:80%; text-align: justify">The server will do lookups only if there are viable entries in the lookup queue. So it is normal for 
		the 'last lookup' status to be not green. This page will auto-refresh every 30 seconds. Click <a href="#" id="info_refresh">here</a> to refresh now.</p>
		
		<p style="font-size:80%; text-align: justify">The application status monitor is useful for monitoring the status of each installation
		when in <b>multi-server mode</b> (professional edition required).</p>
		<div class="dotline"></div><p style="font-size:80%; text-align:center">
		Watch My Domains Server Edition <?php echo get_version() ?>, Build: <?php echo get_build_date(); ?>
		&nbsp;&nbsp;|&nbsp;&nbsp;
		<a href="<?php echo get_base_path() . "menu.php"; ?>">Main Menu</a>
		</p></div>
	</div>
</body>
</html>

	
