<?php
#########################################################################################################
#  RunQ.php
#
#  Copyright (C) Softnik Technologies. All rights reserved.
#
#  Process the Lookup Queue and Do Automatic Domain Lookups
#
#  This script should be run as a cronjob.
#
#  Options
#
#  Adding to Queue
#  auto - set the refresh interval in days.
#  num  - Number of domains to add to queue
#
#  Processing Queue
#  s - start index for processing lookup queue
#  m - maximum queue entries to process.
#
#########################################################################################################

require_once(dirname(__FILE__) . "/lib/php/config.check.php");
require_once(dirname(__FILE__) . "/config.php");
require_once(dirname(__FILE__) . "/lib/php/base.php");
require_once(dirname(__FILE__) . "/lib/php/lookup.php");
require_once(dirname(__FILE__) . "/lib/php/version.php");

#########################################################################################################
# Parse command line if running in CLI

if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

#########################################################################################################

# If verbose.
if(isset($_REQUEST['v']))
{
	echo "<div style=\"width:960px;margin-left:auto;margin-right:auto; text-align:center; font-family:Tahoma,Arial,Verdana;\">";
	echo "<h2>Lookup Queue Processor</h2><hr>";
	echo "<p>When you run this, pending entries (if any) at the top of the lookup queue are processed.</p>";
	echo "<p>You should normally run this as a <b>cronjob</b> from your server.</p>";
	echo "<p style=\"background-color:#FFDFDF; padding: 5px;\"><b>Don't use this</b> as a replacement for the cronjob. If you do, it will not work.</p>";
	echo "<p>It is provided here in this interface to allow <b>infrequent</b>, quick lookup queue processing.</p>";
}

#########################################################################################################

$script_started_at = microtime(true);
connect_to_mysql_and_select_db();
$customfields = SetupAllowableFields();

#########################################################################################################

$max_count = 8;
if(isset($_REQUEST['m']))
	$max_count = intval($_REQUEST['m']);
if($max_count < 2 || $max_count > 16)
	$max_count = 8;
	
#########################################################################################################

$start_from = 0;
if(isset($_REQUEST['s']))
{
	if($_REQUEST['s'] == "")
		$start_from = get_queue_index() * $max_count * 2;
	else
		$start_from = intval($_REQUEST['s']);
}
if($start_from < 0)
	$start_from = 0;
	
#########################################################################################################

$prefer = "";
global $high_preference_lookups;
if(isset($high_preference_lookups))
	$prefer = trim($high_preference_lookups);
	
#########################################################################################################

log_queue_proc_timestamp();
$processinfo = process_lookup_queue($max_count, $start_from, $prefer);
$qcount = $processinfo['count'];
$script_ended_at = microtime(true);

#########################################################################################################

if(isset($_REQUEST['v']))
{
	echo "<p>Processed Queue Size: " . $processinfo['processed'] . "</p>";
	echo "<p>Lookup Queue Size: " . $qcount . "</p>";
	if(isset($_REQUEST['s']))
	{
		echo "<p>Processing Queue At: " . $start_from . "</p>";
		echo "<p>Queue Entries Attempted / Run: " . $max_count . "</p>";
		global $script_ended_at, $script_started_at;
		$exec_time = $script_ended_at-$script_started_at;
		echo "<p>Execution Time: " . round($exec_time) . " seconds.</p>";
	}
}

#########################################################################################################

if($qcount == 0 && isset($_REQUEST['auto']))
{
	$maxdays = intval($_REQUEST['auto']);
	if($maxdays > 180 || $maxdays < 1)
		$maxdays = 180;
		
	$numadd = 8;
	if(isset($_REQUEST['num']))
		$numadd = intval($_REQUEST['num']);
	if($numadd > 2048 || $numadd < 1)
		$numadd = 2048;
		
	$added = add_elu_domains_to_lookup_queue($numadd);
	if($added > 0)
	{
		if(isset($_REQUEST['v']))
			echo "<p>" . $added . " domains, that have not yet been looked up, added to lookup queue.</p>";
	}
	else if($maxdays)
	{
		$added = add_lu_domains_to_lookup_queue($maxdays, $numadd);
		if(isset($_REQUEST['v']) && $added > 0)
			echo "<p>" . $added . " domains, that were last looked up more than " . $maxdays . "day(s) ago, added to lookup queue.</p>";
	}
}

#########################################################################################################

if(isset($_REQUEST['v']))
	echo "<hr><p style=\"font-size:80%;\">Watch My Domains Server Edition " . get_version() . ", Build: " . get_build_date() . "</p></div>";

?>
