<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2010-2013 Softnik Technologies
// Author: SK
/////////////////////////////////////////////////////////////////////////////////////////////////////////

require_once("lib/php/config.check.php");
require_once("config.php");
require_once("lib/php/base.php");
require_once("lib/php/version.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Only admin users can use this script.
# If user authentication is disabled, everyone is an admin user!

session_start();
check_authentication_login();
if(is_admin_user() == false)
{
	//header("Location: " . get_base_path());
	//exit;
}
doSessionSwipeIn();

$jqtheme = "";
$jqtheme = get_theme_name($jqtheme);

$showsalesmgr = false;
$salespath = dirname(__FILE__) . "/tools/sales/index.php";
if(is_file($salespath))
	$showsalesmgr = true;

/////////////////////////////////////////////////////////////////////////////////////////////////////////
connect_to_mysql_and_select_db();
/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
		<title></title>
		<meta http-equiv="Content-Language" content="en">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link rel="shortcut icon" type="image/x-icon" href="lib/css/img/favicon.ico">
		<link type="text/css" href="lib/css/jqueryui/<?php echo $jqtheme; ?>/jquery-ui-1.8.7.custom.css" rel="stylesheet">
		<link type="text/css" href="lib/css/default.css" rel="stylesheet" media="all">
		<link type="text/css" href="lib/css/<?php echo $jqtheme; ?>.css" rel="stylesheet" media="all">
		<script type="text/javascript" src="lib/js/jquery/jquery-1.5.1.min.js"></script>
		<style>
			body
			{ 
				background-position: 55% 45px;
				background-repeat:no-repeat;
				background-attachment:scroll;
			}
			
			table.tb-menu
			{
				border-collapse: collapse;
				font-family: Trebuchet MS,Verdana,Arial,sans-serif; 
				margin-left: auto;
				margin-right: auto;
				margin-top: 24px;
				margin-bottom: 4px;
				font-size: 0.9em;
				width: 840px;
				border-spacing: 10px;
				border-collapse: separate;
			}

			table.tb-menu td, table.tb-menu th
			{
			  color:#000;
			  border: 0px dotted #C0C0C0;
			  width: 100px;
			  vertical-align: middle;
			  text-align: center;
			}
			
			table.tb-menu td.ikon
			{
				box-shadow: rgba(34, 25, 25, 0.398438) 0px 1px 3px 0px;
				border: 5px solid #FFF;
				border-radius: 4px;
			}
			
			table.tb-menu td.disabled
			{
				box-shadow: rgba(34, 25, 25, 0.398438) 0px 1px 3px 0px;
				opacity:0.90; filter: alpha(opacity=90);
				background-color: #F0F0F0;
			}
			
			table.tb-menu th
			{
				color: #000;
				border: 0;
				height: 12px;
			}

			table.tb-menu td.main
			{
				background-color: #23ACFF;
			}
			
			table.tb-menu img
			{
				width: 100px;
				height: auto;
			}
			
			p.disabled {color: #AAA;}
			
			img.disabled
			{
				opacity: 0.4 !important;
				filter: alpha(opacity=40);
			}
			
			table.tb-menu a {text-decoration: none;}
			table.tb-menu a:hover {text-decoration: underline;}
			
			#queue-status {text-align: left; margin-top: 0; font-size: 80%;}
			
			.outerBounds
			{
				width: 960px; margin-left:auto; margin-right: auto; margin-top: 16px; font-family:Trebuchet MS,Verdana,Arial,sans-serif; overflow:auto;
			}
		
		</style>
		<script type="text/javascript">
			$(function()
			{
				$(window).bind('resize', function() {resizeBounds();}).trigger('resize');
			});
			function resizeBounds()
			{
				var dheight = $(window).height();
				jQuery(".outerBounds").height(dheight-96, true); 
			}
		</script>
</head>
<body>
	<div id="serverstatus">
		<div class="outerBounds">
		<p style="text-align:center; margin-top:0px;"><img src="<?php echo get_main_logo_image(); ?>"></p>
		
		<table class="tb-menu">
			<tr>
				<td class="ikon ui-state-default"><a href="lib/php/test.php"><img src="lib/css/img/192/diag-tools.png"></a></td>
				<td class="ikon ui-state-default"><a href="install.php"><img src="lib/css/img/192/database-repair.png"></a></td>
				
				<?php if(is_admin_user()) { ?>
					<td class="ikon ui-state-default"><a href="status.php"><img src="lib/css/img/192/server-status.png"></a></td>
					<td class="ikon ui-state-default"><a href="appsetup.php"><img src="lib/css/img/192/app-setup.png"></a></td>
				<?php } else { ?>
					<td class="ikon ui-state-default"><img class="disabled" src="lib/css/img/192/server-status.png"></td>
					<td class="ikon ui-state-default"><img class="disabled" src="lib/css/img/192/app-setup.png"></td>
				<?php } ?>
			</tr>
			<tr>
				<td><p><a class="infobox" href="lib/php/test.php">Installation Diagnostics</a></p></td>
				<td><p><a class="infobox" href="install.php">Database Setup &amp; Repair</a></p></td>
				<?php if(is_admin_user()) { ?>
				<td><p><a class="infobox" href="status.php">App Status Monitor</a></p></td>
				<td><p><a class="infobox" href="appsetup.php">Basic App Setup</a></p></td>
				<?php } else { ?>
				<td><p class="disabled">App Status Monitor</p></td>
				<td><p class="disabled">Basic App Setup</p></td>
				<?php } ?>
			</tr>
			<tr><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th></tr>
			<tr>
				<?php if(is_admin_user()) { ?>
				<td class="ikon ui-state-default"><a href="report.php"><img src="lib/css/img/192/reports.png"></a></td>
				<td class="ikon ui-state-default"><a href="admin.php"><img src="lib/css/img/192/users.png"></a></td>
				<td class="ikon ui-state-default"><a href="wconfig.php"><img src="lib/css/img/192/whois-setup.png"></a></td>
				<?php } else { ?>
				<td class="ikon ui-state-default"><img class="disabled" src="lib/css/img/192/reports.png"></td>
				<td class="ikon ui-state-default"><img class="disabled" src="lib/css/img/192/users.png"></td>
				<td class="ikon ui-state-default"><img class="disabled" src="lib/css/img/192/whois-setup.png"></td>
				<?php } ?>
				<td class="ikon ui-state-highlight"><a href="<?php echo get_base_path() . "?show=main"; ?>"><img src="lib/css/img/192/domain-table.png"></a></td>
			</tr>
			<tr>
				<?php if(is_admin_user()) { ?>
				<td><p><a class="infobox" href="report.php">Domain Reports</a></p></td>
				<td><p><a class="infobox" href="admin.php">User Administration</a></p></td>
				<td><p><a class="infobox" href="wconfig.php">Whois Setup</a></p></td>
				<?php } else { ?>
				<td><p class="disabled">Domain Reports</p></td>
				<td><p class="disabled">User Administration</p></td>
				<td><p class="disabled">Whois Setup</p></td>
				<?php } ?>
				<td><p><a class="infobox" href="<?php echo get_base_path() . "?show=main"; ?>">Main Interface</a></p></td>
			</tr>
			<tr><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th></tr>
			<tr>
				<?php
				if($showsalesmgr)
				{
				?>
				<td class="ikon ui-state-default"><a href="<?php echo get_base_path() . "tools/sales/admin.php"; ?>"><img src="lib/css/img/192/sales-mgmt.png"></a></td>
				<?php
				}
				?>
				<td class="ikon ui-state-default"><a href="<?php echo get_base_path() . "subdomains.php"; ?>"><img src="lib/css/img/192/subdomains.png"></a></td>
				<td class="ikon ui-state-default"><a href="<?php echo get_base_path() . "lib/php/links.php?r=support"; ?>"><img src="lib/css/img/192/user-guide.png"></a></td>
				<?php if(is_user_auth_enabled()) { ?>
				<td class="ikon ui-state-default"><a href="lib/php/login.php?logout"><img src="lib/css/img/192/logout.png"></a></td>
				<?php } else { ?>
				<td class="ikon ui-state-default"><img class="disabled" src="lib/css/img/192/logout.png"></td>
				<?php } ?>
				<?php
				if(!$showsalesmgr)
				{
				?>
				<td>&nbsp;</td>
				<?php
				}
				?>
			</tr>
			<tr>
				<?php
				if($showsalesmgr)
				{
				?>
				<td><p><a class="infobox" href="<?php echo get_base_path() . "tools/sales/admin.php"; ?>">Sales Management</a></p></td>
				<?php
				}
				?>
				<td><p><a class="infobox" href="<?php echo get_base_path() . "subdomains.php"; ?>">Subdomain Manager</a></p></td>
				<td><p><a class="infobox" href="<?php echo get_base_path() . "lib/php/links.php?r=support"; ?>">User Guide</a></p></td>
				<?php if(is_user_auth_enabled()) { ?>
				<td><p><a class="infobox" href="lib/php/login.php?logout">Logout</a></p></td>
				<?php } else { ?>
				<td><p class="disabled">Logout</p></td>
				<?php } ?>
				<?php
				if(!$showsalesmgr)
				{
				?>
				<td>&nbsp;</td>
				<?php
				}
				?>
			</tr>
			<tr><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th><th>&nbsp;</th></tr>
		</table>
		
		<p class="infobox" style="font-size:80%; text-align:center">Watch My Domains Server Edition <?php echo get_version() ?>, Build: <?php echo get_build_date(); ?></p>
		</div>
	</div>
</body>
</html>

	
