<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2010-2011 Softnik Technologies
// Version 0.1.11 2011-01-15
/////////////////////////////////////////////////////////////////////////////////////////////////////////

require_once("version.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function show_simple_head($title="Domain Portfolio Manager", $desc="")
{
	$jqtheme = "redmond";
	$jqtheme = get_theme_name($jqtheme);
	$favicon = get_favicon_name();
	$favpngf = get_favicon_name(true);
?>
	<head>
		<title><?php echo $title; ?></title>
		<meta http-equiv="Content-Language" content="en">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link rel="shortcut icon" type="image/x-icon" href="lib/css/img/<?php echo $favicon; ?>">
		<link type="text/css" href="lib/css/default.css" rel="stylesheet" media="all">
		<link type="text/css" href="lib/css/<?php echo $jqtheme; ?>.css" rel="stylesheet" media="all">
		<style type="text/css">
			body
			{ 
				background-image:url("lib/css/img/<?php echo $favpngf; ?>");
				background-position: 55% 45px;
				background-repeat:no-repeat;
				background-attachment:scroll;
			}
			#databox {opacity:0.90; filter: alpha(opacity=90);};
		</style>
	</head>
<?php
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function get_base_dir()
{
	return realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . "../../") . DIRECTORY_SEPARATOR;
}

/////////////////////////////////////////////////////////////////////////////////////////

function show_head($jqtheme="redmond", $what="domaintable", $title="Domain Portfolio Manager", $desc="")
{
	if($title == "")
		$title = "Domain Portfolio Manager";
		
	$jqtheme = get_theme_name($jqtheme);
		
	if($what == "")
		$what = "domaintable";
	$what = str_replace(" ", "", strtolower($what));
	
	$panesjs = "panes.js";
	
	$favicon = get_favicon_name();
?>
	<head>
		<title><?php echo $title; ?></title>
		<meta http-equiv="Content-Language" content="en">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link rel="shortcut icon" type="image/x-icon" href="lib/css/img/<?php echo $favicon; ?>">

		<link type="text/css" href="lib/css/jqueryui/<?php echo $jqtheme; ?>/jquery-ui-1.8.7.custom.css" rel="stylesheet">
		<link type="text/css" href="lib/css/jqueryui/<?php echo $jqtheme; ?>/splitter.1.51.css" rel="stylesheet" media="screen">
		<link type="text/css" href="lib/css/jqueryui/splitter.1.51.css" rel="stylesheet" media="screen">
		<link type="text/css" href="lib/css/jqueryui/ui.jqgrid.css" rel="stylesheet" media="screen">

		<script type="text/javascript" src="lib/js/jquery/jquery-1.5.1.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery.cookie.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery-ui-1.8.7.noeffects.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/splitter.1.51.min.js"></script>
		<script type="text/javascript" src="lib/js/jquery/i18n/grid.locale-en.js"></script>
		<script type="text/javascript" src="lib/js/jquery/jquery.jqGrid.3.8.2.min.js"></script>
		
		<link type="text/css" href="lib/css/default.css" rel="stylesheet" media="all">
<?php
if(file_exists(get_base_dir() . "lib/css/custom.css"))
{
?>
		<link type="text/css" href="lib/css/custom.css" rel="stylesheet" media="all">
<?php
}
?>
		<link type="text/css" href="lib/css/<?php echo $jqtheme; ?>.css" rel="stylesheet" media="all">
		<?php
		if($what == "domaintable")
		{
			emitCustomColumnJS();
		?>		
        <script type="text/javascript" src="lib/js/<?php echo $panesjs; ?>"></script>
		<script type="text/javascript" src="lib/js/grid.js"></script>
		<script type="text/javascript" src="lib/js/buttons.js"></script>
		<script type="text/javascript" src="lib/js/add.js"></script>
		<script type="text/javascript" src="lib/js/utils.js"></script>
<?php
if(file_exists(get_base_dir() . "lib/php/custom/head.js.php"))
{
?>
		<script type="text/javascript" src="lib/php/custom/head.js.php"></script>
<?php
}
		}
		if(get_main_logo_image() != "")
		{
		?>
<style> .mainlogo {background-image: url('<?php echo get_main_logo_image(); ?>');}</style>
		<?php
		}
		?>	
	</head>
<?php
}

/////////////////////////////////////////////////////////////////////////////////////////

function show_domain_table()
{
?>
	<body>
		<div id="header">
			<div class="mainlogo">&nbsp;</div>
			<div class="navbar">
					<button id="adddomains"></button>
					<button id="importdomains"></button>
					<button id="deldomains"></button>
					<button id="bulkaction"></button>
					&nbsp;&nbsp;
					<button id="dates"></button>
					<button id="http"></button>
					<button id="registrar"></button>
					<button id="network"></button>
					<button id="sitepop"></button>
					<button id="notes"></button>
					<button id="ipinfo"></button>
					<button id="cdisp01"></button>
					<button id="cdisp02"></button>
					&nbsp;&nbsp;
					<button id="runq"></button>
					<button id="subdomains"></button>
				<?php
				if(is_admin_user())
				{
				?>
					<button id="report"></button>
					<button id="config"></button>
					<button id="appsetup"></button>
					<button id="admin"></button>
				<?php
				}
				?>
	<?php
	show_link_buttons();
	if(is_user_auth_enabled())
	{
		if(!is_admin_user())
		{
			$loggeduserinfo = get_userinfo_from_session();
			$loggedusername = $loggeduserinfo['name'];
		?>
					<button id="usrpwd"></button>
<?php
		}
		else
			$loggedusername = "";
?>
					<button id="logout"></button>
<?php
	}
?>
			</div>
			<div class="clear">&nbsp;</div>
		</div>

		<div id="SplitterPane">
			<div id="CategoryPane">
				<div class="Padded10">
					<div id="LeftPane">
						<div id="CategoryTabView" style="overflow: auto;">
							<ul>
								<li><a href="#domaincategories">Main</a></li>
								<li><a href="#automaticviews">Auto</a></li>
							</ul>
							<div id="domaincategories" style="padding:0px;padding-top:2px;">
								<table id="DomainCategoryTable"></table>
								<div id="pagerCatView"></div>
							</div>
							<div id="automaticviews" style="padding:0px;padding-top:2px;">
								<table id="DomainQueryTable"></table>
								<div id="pagerQueryView"></div>
							</div>
						</div>
						<div class="clear">&nbsp;</div>
					</div> <!-- #LeftPane -->
				</div>
			</div> <!-- #CategoryPane -->
		  
			<div id="RightPane">
				<div id="DomainTablePane">
					<div class="Padded10">
						<!-- alphabet navbar here -->
						<table id="DomainTableGrid"></table>
						<div id="DomainTablePager"></div>
					</div>
				</div>
			
				<div id="DetailsPane">
					<div class="Padded10">
						<div id="DomainDetailTabView" style="overflow: auto;">
								<ul>
									<li><a href="#registrywhois">Raw Registry Whois</a></li>
									<li><a href="#registrarwhois">Raw Registrar Whois</a></li>
									<li><a href="#subdomains">DNS/SSL Records</a></li>
									<li><a href="#ipdata">IP Whois Data</a></li>
									<li><a href="#oltools">Online Tools</a></li>
									<li><a href="#luqinfo">Lookup Queue</a></li>
									<li><a href="#about">About</a></li>
								</ul>
								<div id="registrywhois">&nbsp;</div>
								<div id="registrarwhois">&nbsp;</div>
								<div id="ipdata">&nbsp;</div>
								<div id="subdomains">
									<table id="SubDomainTable"></table>
									<div id="pagerSubDomainView"></div>
								</div>
								<div id="oltools">
									<div id="oltooldomain">&nbsp;</div>
									<div class="dotline"></div>
									<?php include("domaintools.php"); ?>
								</div>
								<div id="luqinfo">
									<?php require_once("luqinfo.php"); ?>
								</div>
								<div id="about">
									<div class="leftbox">
										<h2>Watch My Domains SED</h2>
									</div>
									<div class="rightbox">
										<button id="version"></button>
										<button id="vercheck"></button>
									</div>
									<div class="clear"></div>
									<div class="dotline"></div>
									<div id="version_build_date"><p><?php echo get_version_and_build_date(); ?></p></div>
								</div>
							</div>
						</div>
						<div class="clear">&nbsp;</div>
				</div> <!-- #DetailsPane -->
			</div> <!-- #RightPane -->
		</div> <!-- #SplitterPane -->
		
		
		<div id="dialog-add-domains" title="Add Domains">
			<form id="domain-entry-form">
			<div style="padding: 10px; text-align:center;">
				<input type="hidden" id="lgptoken" name="lgptoken" value="<?php echo_form_token('domain-entry-form'); ?>">
				<label for="data" id="data_label">Domain Names To Add (one entry per line)</label>
				<br><br>
				<textarea style="width:350px;" rows="15" id="data" name="data" cols="40"></textarea>
				<br><br>
				<p style="text-align:left;">
				<input type="checkbox" id="catadd" name="catadd" value="catadd" checked> Add the above domains to category <span class="adc-catname"></span><br>
				<input type="checkbox" id="catempty" name="catempty" value="catempty"> Empty category <span class="adc-catname"></span> before adding the above domains</p>
			</div>
			</form>
		</div>
		
		<div id="dialog-user-admin" title="User Self Admin">
			<form id="user-selfadmin-form">
				<div style="padding: 2px;">
					<input type="hidden" id="lgptoken" name="lgptoken" value="<?php echo_form_token('user-selfadmin-form'); ?>">
					<input type="hidden" id="username" name="username" value="<?php echo $loggedusername; ?>">
					<h4>Change the Password For [<?php echo $loggedusername; ?>]</h4>
					<br>
					<label for old_pwd>Current Password: &nbsp;</label>
					<input type="password" name="old_pwd" id="old_pwd"><br><br>
					<label for new_pwd_1>New Password: &nbsp;</label>
					<input type="password" name="new_pwd_1" id="new_pwd_1"><br><br>
					<label for new_pwd_2>Repeat Password: &nbsp;</label>
					<input type="password" name="new_pwd_2" id="new_pwd_2"><br><br>
					
					<p>Please make sure that the password has a minimum of 8 characters with a mix of digits, lower and upper case alphabets etc.</p>
					<p id="selfadmerror" class="warning"></p>
				</div>
			</form>
		</div>
		
		<div id="dialog-add-subdomains" title="Add Sub-domains">
			<form id="subdomains-entry-form">
			<div style="padding: 10px; text-align:center;">
				<label for="ui_subdomains" id="subdomains_label">Sub-domains To Add to all selected domains (Don't enter the full hostname. Enter only www, ssl, ftp, etc.)</label>
				<br><br>
				<textarea rows="15" id="ui_subdomains" name="ui_subdomains" cols="40"></textarea>
			</div>
			</form>
		</div>
		
		<div id="dialog-parse-whois" title="Parse Domain Whois">
			<div style="padding: 10px; text-align:justify;">
				<p>Click OK to parse the whois data for selected domain(s). This is useful if you have made changes to the data extraction tokens and wish to
				extract column data without redoing a whois lookup all over again.</p>
			</div>
		</div>
		
		<div id="dialog-lookup-what" title="Domain Lookups">
			<p>Please select what to queue for lookup.</p>
			<hr>
			<form id="lookup-what-form">
			<div style="padding: 10px;">
				<input type="checkbox" id="luwhois"><label for="luwhois">Domain Whois</label><br>
				<input type="checkbox" id="ludns"><label for="ludns">Domain IP</label><br>
				<input type="checkbox" id="luhttp"><label for="luhttp">Home Page (http)</label><br>
				<input type="checkbox" id="lualexa"><label for="lualexa">Alexa Info</label><br>
				<input type="checkbox" id="lugpr"><label for="lugpr">Google PR</label><br>
				<input type="checkbox" id="lumx"><label for="lumx">MX Records</label><br>
				<input type="checkbox" id="luping"><label for="luping">Ping Response</label><br>
				<input type="checkbox" id="luipwhois"><label for="luipwhois">IP Whois</label><br>
				<input type="checkbox" id="lugindex"><label for="lugindex">Google Index</label><br>
				<input type="checkbox" id="lusubdom"><label for="lusubdom">Sub Domains</label><br>
				<div class="dotline"></div>
				<label for luint>Lookup Interval (seconds): &nbsp;</label>
				<input type="text" name="luint" id="luint" style="width:50px;" value="1440"><br>
				<p>Specify lookup interval of 0 (zero) seconds if you want to force the lookups.</p>
			</div>
			</form>
		</div>
		
		<div id="dialog-bulk-action" title="Bulk Action Tool">
			<form id="bulk-action-form">
				<div style="padding: 2px;">
					<h4>Bulk set data &amp; categorize selected domain(s).</h4>
					<br>
					<label for notes_a>Notes-A: &nbsp;</label>
					<input type="text" name="notes_a" id="bt-notes-a"><br><br>
					<label for notes_b>Notes-B: &nbsp;</label>
					<input type="text" name="notes_b" id="bt-notes-b"><br><br>
					<label for notes_c>Notes-C: &nbsp;</label>
					<input type="text" name="notes_b" id="bt-notes-c"><br><br>
					<label for notes_d>Notes-D: &nbsp;</label>
					<input type="text" name="notes_d" id="bt-notes-d"><br><br>
					<label for field_set><select id="bt-field-set"></select></label>
					<input type="text" name="field_set" id="field_set"><br><br>
					<br>
					
					<label for cat_add>Add to Category: &nbsp;</label>
					<select id="bt-cat-add">
					</select>
					<br><br>
					
					<label for cat_delete>Remove from Category: &nbsp;</label>
					<select id="bt-cat-delete">
					</select>
					<br><br>
					<div id="bt-domain-info"></div>
					<p class="warning">Please be careful with this tool. It is very easy to mistakenly overwrite the 
					note and other columns while using this. Double check all the entries before pressing 'OK'.</p>
				</div>
			</form>
		</div>
		
		<div id="dialog-regalias-editor" title="Registrar Alias Editor">
			<form id="regalias-form">
				<div style="padding: 2px; text-align: center;">
					<h4>Specify a Shorter Alias Name for the Registrar</h4>
					<div class="dotline"></div>
					<div id="ra-real-name"></div>
					<div class="dotline"></div>
					<br>
					<label for alias>Alias: &nbsp;</label>
					<input type="text" name="alias" id="ra-regalias" size="30"><br>
					<div id="ra-error"></div>
					<br><br>
				</div>
			</form>
		</div>
		
		<div id="dialog-csv-upload" title="CSV File Upload">
			<br>
			<form id="csv-upload" class="fileupload" action="lib/php/uploadcsv.php" method="post" enctype="multipart/form-data">
			<p><label for="file">CSV File Name:</label>
			<input type="file" name="csv_file" id="csv_file"></p>
			<br>
			<label for csv_sep>Separator: </label>
			<!--
			<input type="text" name="csv_sep" size="5" id="csv_sep" value=","><br><br>
			-->
			<select id="csv_sep" name="csv_sep">
			  <option value=",">Comma</option>
			  <option value=";">Semi Colon</option>
			  <option value="t">Tab</option>
			</select>
			<br><br>
			
			<div class="dotline"></div>
			
			<p>The CSV File should have a heading row that contains the field names. If the Upload
			fails, please check the encoding of the file ('UTF-8 without BOM' will always work).</p>
			
			<p>New domains added as part of a CSV set are <b>not queued</b> for lookup. However, 
			if the CSV file contains only domain names (and no other data), the domains will be queued for lookup.</p>
			
			<p>Please use this with care. Do not try to upload huge / binary files.</p>
			
			<p>This will not work in IE9 and less.</p>
			
			<div id="csverrors">&nbsp;</div>
			
			<p>Click 'Close' when you are done.</p>
			</form>
		</div>
		
		<div id="dialog-csv-download" title="CSV File Download">
			<br>
			<h3 class="center">Select What To Download and then Click 'Download'</h3>
			<div id="csvdnload"></div>
			<br><br>
			<form>
				<div style="text-align:left; padding-left:20px;">
					<div id="csv-download-radio">
						<input type="radio" id="selectedrows" name="csv-download-radio"><label for="selectedrows">Selected Rows</label>
						<input type="radio" id="allrows" name="csv-download-radio" checked="checked"><label for="allrows">All Rows</label>
						<input type="radio" id="selecteddomainnames" name="csv-download-radio"><label for="selecteddomainnames">Selected Names</label>
						<input type="radio" id="alldomainnames" name="csv-download-radio"><label for="alldomainnames">All Names</label>
						<br><br>
						<input type="radio" id="selecteddnsrows" name="csv-download-radio"><label for="selecteddnsrows">Domain DNS Data - Selected Rows</label>
						<input type="radio" id="alldnsrows" name="csv-download-radio"><label for="alldnsrows">Domain DNS Data - All Rows</label>
						<br><br>
						<input type="radio" id="selectedsslrows" name="csv-download-radio"><label for="selectedsslrows">Domain SSL Data - Selected Rows</label>
						<input type="radio" id="allsslrows" name="csv-download-radio"><label for="allsslrows">Domain SSL Data - All Rows</label>
						<p>&nbsp;</p>
						Click the <b>download button</b> below to start the download.
					</div>
				</div>
			</form>
			<br><br>
		</div>
	</body>
<?php
}

/////////////////////////////////////////////////////////////////////////////////////////

function show_domain_manager($jqtheme="", $title="", $desc="")
{
$success = false;
$status = array();

// Nov 6, 2013
if(!is_ion_cube_installed_if_required())
{
	$status[] = "ionCube Loader is not installed. This is required for demo and standard version installations.";
	$status[] = "Please see <a href=\"http://www.ioncube.com/loaders.php\">ionCube Loaders</a> for installation instructions.";
	show_error_page($status);
	exit;
}
//

// July 2014
if (!defined('PDO::ATTR_DRIVER_NAME')) 
{
	$status[] = "PHP::PDO is not enabled. This is required.";
	$status[] = "Please see <a href=\"http://php.net/manual/en/pdo.installation.php\">PHP Installation</a> for help or contact your system administrator.";
	show_error_page($status);
	exit;
}

if (!defined('PDO::MYSQL_ATTR_INIT_COMMAND')) 
{
	$status[] = "PHP::PDO is not enabled or php-mysql is not installed.";
	$status[] = "Please see <a href=\"http://php.net/manual/en/pdo.installation.php\">PHP Installation</a> for help or contact your system administrator.";
	show_error_page($status);
	exit;
}

if(!function_exists('mb_substr'))
{
	$status[] = "php-mbstring is not installed. This is required.";
	$status[] = "Please contact your system administrator or install php-mbstring.";
	show_error_page($status);
	exit;
}

if(!is_wmdsed_installed($status, $success))
{
	if($success)
		install_wmdsed("lib/php/data/tables.sql");
	else
	{
		array_unshift($status, "Database Error!");
		show_error_page($status); //array("Database Error!", "Please check your database settings."));
	}
	exit;
}

session_start();
check_authentication_login();

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"> 
<html>
<?php	
	show_head($jqtheme, "domaintable", $title, $desc);
	show_domain_table();
?>
</html>
<?php
}

/////////////////////////////////////////////////////////////////////////////////////////

function show_page($status, $title)
{
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"> 
<html>
<?php
	$image_path = get_main_logo_image();
	show_simple_head($title);
	echo "<body>\n";
	echo "<div id=\"databox\" style=\"padding-left:20px; padding-right:20px;\">";
?>
	<p style="text-align:center; margin-top:0px;"><img src="<?php echo get_main_logo_image(); ?>"></p>
	<div class="dotline"></div>
	<br>
<?php
	$i = 0;
	for($i = 0; $i < count($status); $i++)
	{
		echo "<p style=\"font-size:16px; text-align:center;\">" . $status[$i] . "</p>";
	}
	echo "<br>";
	echo "<div class=\"dotline\"></div>";
	echo "<p class=\"center nomargin\">" . "<a href=\"" . get_base_path() . "lib/php/links.php?r=home" . "\">Home Page</a>";
	echo "&nbsp;&nbsp;|&nbsp;&nbsp;";
	echo "<a href=\"" . get_base_path() . "\">Watch My Domains Server Edition</a>";
	echo "&nbsp;&nbsp;|&nbsp;&nbsp;";
	echo "<a href=\"" . get_base_path() . "menu.php" . "\">Main Menu</a>";
	echo "</p>";
	echo "</div>";
	echo "</body>\n";
?>
</html>
<?php	
}


/////////////////////////////////////////////////////////////////////////////////////////

function show_success_page($status)
{
	show_page($status, "Success");
}

/////////////////////////////////////////////////////////////////////////////////////////

function show_error_page($status)
{
	show_page($status, "Problem");
}

/////////////////////////////////////////////////////////////////////////////////////////

?>
