<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2010-2013 Softnik Technologies
// Version 2013-09-26
// Initial Version: SK
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////

require_once("config.check.php");
require_once("../../config.php");
require_once("base.php");
require_once("idn.php");
require_once("whois.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Ajax script. 
# Check authentication and quit with http error code if auth fails.

session_start();
check_authentication_error_quit();
doSessionSwipeIn();

///////////////////////////////////////////////////////////////////////////////////////////////////

if(is_user_auth_enabled())
{
	$access_rights = 1;
	$userinfo = get_userinfo_from_session();
	if(!is_admin_user_or_is_basic_version())
	{
		$access_rights = $userinfo['readwrite'];
	}
	if(!$access_rights)
	{
		header("HTTP/1.0 403 Forbidden");
		echo "Permission Denied.";
		exit;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////

function is_admin_user_or_is_basic_version()
{
	return is_admin_user();
}

///////////////////////////////////////////////////////////////////////////////////////////////////

function parse_whois_again($domain_name, $spit_out=false)
{
	if(get_domainparts_from_url($domain_name, $tld, $domain, $subdomain, $wserver) === true)
	{
		$whoisdata = get_whoisdata_for_domain($domain_name);
		if(isset($whoisdata['ip_whois']))
		{
			$data_array = array();
			generic_ipwhois_parser("", $whoisdata['ip_whois'], $data_array);
			if(is_array($data_array))
			{
				unset($data_array['ip_whois_at']);
				unset($data_array['ip_whois']);
				update_domain_table($data_array, $domain_name);
				if($spit_out)
					print_r($data_array);
			}
		}
		$deeplookup = false;
		if(isset($whoisdata['registry_whois']))
		{
			$data_array_01 = array();
			do_whois_postlookup($domain_name, $wserver, $whoisdata['registry_whois'], $data_array_01, $deeplookup, $secserver);
			if(is_array($data_array_01))
			{
				unset($data_array_01['lookedup']);
				unset($data_array_01['registry_whois']);
				update_domain_table($data_array_01, $domain_name);
				if($spit_out)
					print_r($data_array_01);
			}
		}
		if($deeplookup && isset($whoisdata['registrar_whois']))
		{
			$data_array_02 = array();
			do_whois_post2ndlookup($domain_name, $secserver, $whoisdata['registrar_whois'], $data_array_02);
			if(is_array($data_array_02))
			{
				unset($data_array_02['lookedup']);
				unset($data_array_02['registrar_whois']);
				update_domain_table($data_array_02, $domain_name);
				if($spit_out)
					print_r($data_array_02);
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////

function parse_whois($sids, $spit_out=false)
{
	$idarray = validate_request_data( trim($sids, ","));
	$ids = explode(",", $idarray);
	foreach($ids as $sid)
	{
		$domain = get_domain_name_from_sid($sid);
		parse_whois_again($domain, $spit_out);
	}	
}

///////////////////////////////////////////////////////////////////////////////////////////////////

connect_to_mysql_and_select_db();

$customfields = SetupAllowableFields();

$domain_name = "";
if(isset($_REQUEST['d']))
	$domain_name = validate_request_data($_REQUEST["d"]);
	
$spit_out = false;
if(isset($_REQUEST['v']))
{
	$spit_out = true;
	echo "<pre>";
}

$responce = new stdClass();
$responce->status = "ok";
$responce->msg = "";

if($domain_name != "")
	parse_whois_again($domain_name, $spit_out);
	
if(isset($_REQUEST['id']))
	parse_whois($_REQUEST['id'], $spit_out);
	
if(!$spit_out)
	echo json_encode($responce);
exit;

///////////////////////////////////////////////////////////////////////////////////////////////////

?>
