<?php
###############################################################################
# Adding SimilarWeb data into domain database.
#
# May - 10 -2014
# 
# Rename simweb-sample.php to simweb.php
# Edit it to include the API Key from SimilarWeb
# Run this as a cron-job at regular intervals to insert data into the
# domain table.
# eg.
#
# */3 * * * * wget -q -O /dev/null "http://<install-url>/lib/php/thirdparty/simweb.php?d=90" >/dev/null 2>&1
#
###############################################################################

# Parse command line if running in CLI

if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

###############################################################################

require_once(dirname(__FILE__) . "/../config.check.php");
require_once(dirname(__FILE__) . "/../../../config.php");
require_once(dirname(__FILE__) . "/config.check.php");
require_once(dirname(__FILE__) . "/../sdk/wmdsed-api.php");

###############################################################################

if(!function_exists('curl_version'))
{
	echo "Please install php5-curl.";
	exit;
}
	
###############################################################################
# Get Command-line

$verbose        = false;
$refresh_days   = 30;
$use_paid_api   = false;

if(isset($_REQUEST['v']))
	$verbose = true;
if(isset($_REQUEST['d']))
{
	$days = intval($_REQUEST['d']);
	if($days > 0 && $days <= 365)
		$refresh_days = $days;
}
if(isset($_REQUEST['paid']))
	$use_paid_api = true;
	
###############################################################################

if($verbose)
	echo "<pre>";
	
###############################################################################
# Open the Domain Database

$pdo = new wmDomainDatabase($db_table_prefix);
$dbc = $pdo->openMySQL($db_config_host, $db_config_database, $db_config_username, $db_config_password);

if(!$dbc)
{
	$pdo->showLog();
	exit;
}


###############################################################################
# Add the MOZ columns to the domain portfolio database.
# NOTE: This may fail if any of the columns is already present in the 
# domain table but not registered as a custom column. If you have problems
# you will need to start with a fresh DB.

$columns = $pdo->getAllColumnNames();
if($columns !== false)
{
	# date time column
	if(!in_array('simweb_checked_at', $columns))
		$pdo->addDateTimeColumn('simweb_checked_at');
		
	# Add Rank & Visits Columns
	if(!in_array('simweb_rank', $columns))
		$pdo->addBigIntColumn('simweb_rank', 20);
	if(!in_array('simweb_visits', $columns))
		$pdo->addBigIntColumn('simweb_visits', 20);
}
else
{
	$pdo->showLog();
	exit;
}

###############################################################################
# Find the domains to lookup.

$lookup_array = $pdo->getDomainsToLookup("simweb_checked_at", 1, $refresh_days);
if($lookup_array !== false)
{
	if(count($lookup_array) == 0 && $verbose)
		echo "Nothing to do!<br>";
		
	$simweb_checked_at = date("Y-m-d H:i:s");
	foreach($lookup_array as $dinfo)
	{
		$domain = $dinfo['domain'];
		
		$rank_data = get_similar_web_traffic_data($domain, $similarweb_api_key);
		if($rank_data !== false)
			$pdo->setDomainData($domain, "simweb_rank", $rank_data);
		else
			$pdo->setDomainData($domain, "simweb_rank", 0);

		$visitors_data = 0;
		$visitors_data = get_similar_web_estimated_visitors($domain, $similarweb_api_key);
		if($visitors_data !== false)
			$pdo->setDomainData($domain, "simweb_visits", $visitors_data);
		else
			$pdo->setDomainData($domain, "simweb_visits", 0);
			
		$pdo->setDomainData($domain, "simweb_checked_at", $simweb_checked_at);
		
		if($verbose)
			echo "$domain - Global Rank: $rank_data, Estimated Visitors: $visitors_data<br>";
	}
}
else
{
	$pdo->showLog();
	exit;
}

###############################################################################

function api_http_call($url)
{
	$options = array(CURLOPT_RETURNTRANSFER => true);
	$ch = curl_init($url);
	curl_setopt_array($ch, $options);
	$content = curl_exec($ch);
	$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close( $ch );
	if($http_status == 200)
		return json_decode($content);
	return false;
}

###############################################################################

function get_similar_web_traffic_data($domain_name, $api_user_key)
{
	$trafficRequestUrl = "http://api.similarweb.com/Site/$domain_name/v1/traffic?Format=JSON&UserKey=$api_user_key";
	$contents = api_http_call($trafficRequestUrl);
	if($contents !== false)
	{
		if(isset($contents->GlobalRank))
			return $contents->GlobalRank;
	}
	return false;
}

###############################################################################

function get_similar_web_estimated_visitors($domain_name, $api_user_key)
{
	$visitsRequestUrl = "http://api.similarweb.com/Site/$domain_name/v1/EstimatedTraffic?Format=JSON&UserKey=$api_user_key";
	$contents = api_http_call($visitsRequestUrl);
	if($contents !== false)
	{
		if(isset($contents->EstimatedVisitors))
			return $contents->EstimatedVisitors;
	}
	return false;
}

###############################################################################
# A Helper function

function is_cli()
{
    if( defined('STDIN') )
        return true;
    if( empty($_SERVER['REMOTE_ADDR']) and !isset($_SERVER['HTTP_USER_AGENT']) and count($_SERVER['argv']) > 0) 
        return true;
    return false;
}

###############################################################################

?>
