<?php
###############################################################################
# Adding MOZ data into domain database.
#
# May - 6 -2014
# Portions of the code from MOZ sample PHP code.
#
# Rename lib/php/thirdparty/config-sample.php to config.php
# Edit it to include the ID and KEY from MOZ
# Run this as a cron-job at regular intervals to insert data into the
# domain table.
# eg.
#
# */5 * * * * wget -q -O /dev/null "http://<install-url>/lib/php/thirdparty/moz.php?d=90" >/dev/null 2>&1
#
###############################################################################

# Parse command line if running in CLI

if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

###############################################################################

require_once(dirname(__FILE__) . "/../config.check.php");
require_once(dirname(__FILE__) . "/../../../config.php");
require_once(dirname(__FILE__) . "/config.check.php");
require_once(dirname(__FILE__) . "/../sdk/wmdsed-api.php");

###############################################################################

if(!function_exists('curl_version'))
{
	echo "Please install php5-curl.";
	exit;
}

###############################################################################
# Get Command-line

$verbose        = false;
$refresh_days   = 30;
$moz_batch_size = 5;

if(isset($_REQUEST['v']))
	$verbose = true;
if(isset($_REQUEST['d']))
{
	$days = intval($_REQUEST['d']);
	if($days >= -1 && $days <= 365)
		$refresh_days = $days;
}
if(isset($_REQUEST['b']))
{
	$batch = intval($_REQUEST['b']);
	if($batch > 0 && $batch <= 100)
		$moz_batch_size = $batch;
}

###############################################################################

if($verbose)
	echo "<pre>";

###############################################################################
# Open the Domain Database

$pdo = new wmDomainDatabase($db_table_prefix);
$dbc = $pdo->openMySQL($db_config_host, $db_config_database, $db_config_username, $db_config_password);

if(!$dbc)
{
	$pdo->showLog();
	exit;
}

###############################################################################
# Add the MOZ columns to the domain portfolio database.
# NOTE: This may fail if any of the columns is already present in the 
# domain table but not registered as a custom column. If you have problems
# you will need to start with a fresh DB.

$columns = $pdo->getAllColumnNames();
if($columns !== false)
{
	# date time column
	if(!in_array('moz_checked_at', $columns))
		$pdo->addDateTimeColumn('moz_checked_at');
		
	# Use Text for Rank Columns
	if(!in_array('moz_rank', $columns))
		$pdo->addTextColumn('moz_rank', "32");
	if(!in_array('moz_www_rank', $columns))
		$pdo->addTextColumn('moz_www_rank', "32");

	# Number columns
	$required_columns = array('moz_pa', 'moz_www_pa', 'moz_da', 'moz_www_da', 'moz_links', 'moz_www_links');
	foreach($required_columns as $col)
	{
		if(!in_array($col, $columns))
			$pdo->addBigIntColumn($col, 20);
	}
}
else
{
	$pdo->showLog();
	exit;
}

###############################################################################
# Find the domains to lookup.

$batchedDomains = array();

$lookup_array = $pdo->getDomainsToLookup("moz_checked_at", $moz_batch_size, $refresh_days);
if($lookup_array !== false)
{
	foreach($lookup_array as $dinfo)
	{
		$domain = $dinfo['domain'];
		$batchedDomains[] = $domain;
		$batchedDomains[] = "www." . $domain;
	}
	if($verbose)
		print_r($batchedDomains);
}
else
{
	$pdo->showLog();
	exit;
}

###############################################################################
# Find the MOZ Data

$data_array = get_moz_data($batchedDomains, $moz_access_id, $moz_secret_key);
if($data_array !== false)
{
	$moz_checked_at = date("Y-m-d H:i:s");

	$column_array = array('moz_pa', 'moz_da', 'moz_links');
	$column_www_array = array('moz_www_pa', 'moz_www_da', 'moz_www_links');
	
	$index = 0;
	foreach($data_array as $mozdata)
	{
		$db_data    = array();
		$db_data[0] = $mozdata['pa'];
		$db_data[1] = $mozdata['da'];
		$db_data[2] = $mozdata['links'];
		$domain     = $mozdata['url'];
		
		if($domain == "")
			$domain = $batchedDomains[$index];
			
		# Separate the www data 
		if(substr($domain, 0, 4) == "www.")
		{
			$domain = substr($domain, 4);
			$pdo->setDomainDataArray($domain, $column_www_array, $db_data);
			$pdo->setDomainData($domain, "moz_www_rank", $mozdata['rank']);
		}
		else
		{
			$pdo->setDomainDataArray($domain, $column_array, $db_data);
			$pdo->setDomainData($domain, "moz_rank", $mozdata['rank']);
		}
			
		# Set the looked up timestamp.
		$pdo->setDomainData($domain, "moz_checked_at", $moz_checked_at);
		
		$index++;
	}
	
	# echo
	
	if($verbose)
		print_r($data_array);
}

###############################################################################
# The MOZ API Call

function get_moz_data($batchedDomains, $access_id, $secret_key)
{
	$expires = time() + 300;
	$stringToSign = $access_id."\n".$expires;
	$binarySignature = hash_hmac('sha1', $stringToSign, $secret_key, true);
	$urlSafeSignature = urlencode(base64_encode($binarySignature));
	$cols = "103079231524"; 
	$requestUrl = "http://lsapi.seomoz.com/linkscape/url-metrics/?Cols=".$cols."&AccessID=".$access_id."&Expires=".$expires."&Signature=".$urlSafeSignature;
	$encodedDomains = json_encode($batchedDomains);
	$options = array(
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_POSTFIELDS     => $encodedDomains
		);

	$ch = curl_init($requestUrl);
	curl_setopt_array($ch, $options);
	$content = curl_exec($ch);
	$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close( $ch );

	if($http_status == 200)
	{
		$contents = json_decode($content);
		$dataArray = array();
		foreach($contents as $entry)
		{
			$mozData = array();
			$mozData['pa'] = round($entry->upa,0); 
			$mozData['da'] = round($entry->pda,0);
			$mozData['links'] = $entry->ueid;
			$mozData['rank'] = round($entry->umrp, 3);
			$mozData['url'] = trim($entry->uu, "/ ");
			$dataArray[] = $mozData;
		}
		return $dataArray;
	}
	return false;
}

###############################################################################
# A Helper function

function is_cli()
{
    if( defined('STDIN') )
        return true;
    if( empty($_SERVER['REMOTE_ADDR']) and !isset($_SERVER['HTTP_USER_AGENT']) and count($_SERVER['argv']) > 0) 
        return true;
    return false;
}

###############################################################################

?>
