<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2010-2013 Softnik Technologies
// Initial Version: Anil Kumar
//
// Modified: Feb 13, 2013: SK
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
// This is simply a sandbox for testing various stuff.
// Use it to debug stuff.
/////////////////////////////////////////////////////////////////////////////////////////////////////////

require_once("config.check.php");
require_once("../../config.php");
require_once("base.php");
require_once("lookup.php");
require_once("wmdsed.php");
require_once("dbtables.php");
require_once("idn.php");

error_reporting( E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED & ~E_WARNING);

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$ion_icon = "success.png";
$status_icon = "success.png";
$test_status = array();
$mysql_time = "";
$phptime = "";

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$index = 0;
$gbf = get_grid_base_file_name();
if($gbf != "datagrid.php")
{
	if ( extension_loaded('ionCube Loader') ) 
	{
		$ion_status = ioncube_loader_version_array();
		$ion_version = $ion_status['version'];
		if($ion_status['major'] >= 4 && $ion_status['minor'] >= 0)
			$test_status[$index]  = "<p>ionCube Loader v$ion_version installed.</p>"; 
		else
		{
			$ion_icon = "alert.png";
			$test_status[$index]  = "<p>ionCube Loader v$ion_version installed. ";
			$test_status[$index] .= "We need v4.0 or greater for demo and standard version installations.</p>";
		}
	}
	else
	{
		$ion_icon = "alert.png";
		$test_status[$index]  = "<p>ionCube Loader is not installed. ";
		$test_status[$index] .= "This is required for demo and standard version installations. ";
		$test_status[$index] .= "Please see <a href=\"http://www.ioncube.com/loaders.php\">ionCube Loaders</a></p>";
	}
	$test_status[$index+1] = $ion_icon;

	$index += 2;
	$test_status[$index+1] = "";
	$test_status[$index] = "<div class=\"dotline\"></div>\n";
	$index += 2;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$phpver = phpversion();
$test_status[$index] = "<p>PHP Version is " . $phpver . ".";
if(substr($phpver, 0, 3) == "5.2" || substr($phpver, 0, 3) == "5.3" || substr($phpver, 0, 3) == "5.4" || substr($phpver, 0, 3) == "5.5" || substr($phpver, 0, 3) == "5.6")
	$test_status[$index+1] = "success.png";
else 
{
	$test_status[$index+1] = "alert.png";
	$test_status[$index] .= " The application requires PHP 5.2.x, 5.3.x, 5.4.x, 5.5.x or 5.6.x. Please see the section about PHP version in <a href=\"https://watchmy.domains/sed/guide/troubleshooting.php\">trouble-shooting</a> instructions.";
}
$test_status[$index] .= "</p>";

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$index += 2;
$test_status[$index+1] = "";
$test_status[$index] = "<div class=\"dotline\"></div>\n";
$status_icon = "success.png";
$index += 2;
$test_status[$index] = "";
global $db_config_host, $db_config_username, $db_config_password, $db_config_database;
$dbLink = @mysql_connect($db_config_host, $db_config_username, $db_config_password);
if ($dbLink === false) 
{
	$status_icon = "error.png";
    $test_status[$index] .= "<p>Failed to connect to MySQL: " . mysql_error() . "</p>";
	//$test_status[2] .= "<p>Is the hostname '$db_config_host' correct?</p>";
}
else
{
	$test_status[$index] .= "<p>MySQL server version is " . mysql_get_server_info() . "</p>";
	$test_status[$index] .= "<p>User '$db_config_username'@'$db_config_host' connected to MySQL.</p>";
	if(!mysql_select_db($db_config_database))
	{
		$status_icon = "error.png";
		$test_status[$index] .= "<p>Failed to select database: " . mysql_error() . "</p>";
	}
	else
	{
		$test_status[$index] .= "<p>Able to select the database '$db_config_database'.</p>";
		$idresults = @mysql_query("select NOW() as CT");
		if($idresults !== false)
		{
			$row = mysql_fetch_array($idresults, MYSQL_ASSOC);
			if(isset($row['CT']))
			{
				$mysql_time = $row['CT'];
				$phptime = date("Y-m-d H:i:s");
			}
		}
	}
	mysql_close($dbLink);
}
$test_status[$index+1] = $status_icon;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$index += 2;
$test_status[$index+1] = "";
$test_status[$index] = "<div class=\"dotline\"></div>\n";
$status_icon = "success.png";
$index += 2;
$test_status[$index] = "";

if (!defined('PDO::ATTR_DRIVER_NAME')) 
{
	$status_icon = "error.png";
	$test_status[$index] .= "<p>PDO_MySQL is not available. Please install / enable it.</p>";
}
else if (defined('PDO::ATTR_DRIVER_NAME')) 
	$test_status[$index] .= "<p>PDO_MySQL is available.</p>";
$test_status[$index+1] = $status_icon;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$index += 2;
$test_status[$index+1] = "";
$test_status[$index] = "<div class=\"dotline\"></div>\n";
$status_icon = "success.png";
$index += 2;
$test_status[$index] = "";

if(!function_exists('curl_version'))
{
	$status_icon = "alert.png";
	$test_status[$index] .= "<p>PHP5-Curl is not available. Please install / enable it if you want to use third-party add-ons (MOZ, EstiBot) and domain homepage checks.</p>";
}
else 
	$test_status[$index] .= "<p>PHP5-Curl is available.</p>";
$test_status[$index+1] = $status_icon;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$index += 2;
if(function_exists('session_status'))
{
	$test_status[$index+1] = "";
	$test_status[$index] = "<div class=\"dotline\"></div>\n";
	$index += 2;

	session_start();
	$test_status[$index] = "";
	if(session_status() == PHP_SESSION_ACTIVE)
	{
		$test_status[$index] .= "<p>PHP Sessions are active</p>";
		$test_status[$index+1] = "success.png";
	}
	else if(session_status() == PHP_SESSION_DISABLED)
	{
		$test_status[$index] .= "<p>PHP Sessions are disabled</p>";
		$test_status[$index+1] = "error.png";
	}
	else if(session_status() == PHP_SESSION_NONE)
	{
		$test_status[$index] .= "<p>PHP Sessions are enabled but none exists.</p>";
		$test_status[$index+1] = "alert.png";
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$index += 2;
$test_status[$index+1] = "";
$test_status[$index] = "<div class=\"dotline\"></div>\n";
$index += 2;
$msnow_stat = test_mysql_now($zonedata);
if($msnow_stat !== false)
{
	$test_status[$index] .= "<p>Time Zones appear to be fine.</p>";
	$test_status[$index] .= $zonedata;
	$test_status[$index+1] = "success.png";
}
else
{
	$test_status[$index] .= "<p>Time Zone Error!</p>";
	$test_status[$index] .= $zonedata;
	$test_status[$index+1] = "error.png";
}

function test_mysql_now(&$zonedata)
{
	global $mysql_time, $phptime, $php_timezone_was_autoset;
	
	$autoset = "";
	if($php_timezone_was_autoset)
		$autoset = " [Autoset]";
	if($mysql_time != "" && $phptime != "")
	{
		$gmdiff = strtotime($mysql_time) - strtotime(gmdate("Y-m-d H:i:s"));
		$mysqltimezone = timezone_name_from_abbr("", $gmdiff, false);
		if($mysqltimezone === false)
			$mysqltimezone = "";
		$phptimezone = date_default_timezone_get();
		$tdiff = strtotime($phptime) - strtotime($mysql_time);
		$zonedata = "<p>MySQL Time = $mysql_time [<b>$mysqltimezone</b>]<br>PHP Time = $phptime [<b>$phptimezone</b>]$autoset<br>Offset = $tdiff Seconds</p>\n";
		if(abs($tdiff) > 1)
		{
			$zonedata .= "<p>Please see the <a href=\"https://watchmy.domains/sed/guide/troubleshooting.php\">trouble shooting guide</a>.</p>\n";
			return false;
		}
		else
			return true;
	}
	else
	{
		return false;
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$index += 2;
$test_status[$index+1] = "";
$test_status[$index] = "<div class=\"dotline\"></div>\n";
$index += 2;
$whois_stat = test_whois($whoisdata);
if($whois_stat !== false)
{
	$test_status[$index] .= "<p>Able to make port 43 whois connections</p>";
	$test_status[$index+1] = "success.png";
}
else
{
	$test_status[$index] .= "<p>Unable to make a port 43 whois connection to whois.crsnic.net!</p>";
	$test_status[$index] .= $whoisdata;
	$test_status[$index+1] = "error.png";
}

function test_whois(&$data)
{
	$data = "";
	$whoisserver = "whois.crsnic.net";
	$fp = @fsockopen($whoisserver, 43, $errno, $errstr, 10);
	if( $fp )
	{
		@fputs($fp, "domain example.com\r\n");
		@socket_set_timeout($fp, $m_sockettimeout);
		while( !@feof($fp) )
			$data .= @fread($fp, 4096);
		@fclose($fp);
		return true;
	}
	else
	{
		$data = "<p>Error - unable to connect to $whoisserver.<br>$errstr ($errno).</p>";
		$data .= "<p>Please see the <a href=\"https://watchmy.domains/sed/guide/troubleshooting.php\">trouble shooting guide</a>.</p>\n";
	}
	return false;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$index += 2;
$test_status[$index+1] = "";
$test_status[$index] = "<div class=\"dotline\"></div>\n";
$index += 2;
$test_status[$index] = "";
$queue_stamp = get_queue_proc_time();
if($queue_stamp !== false)
{
	$diff = time() - $queue_stamp;
	if($diff > (60*60))
		$sdiff = "a long time ago!";
	else
		$sdiff =  gmdate("H:i:s", $diff) . " ago.";
	$test_status[$index] .= "<p>Lookup queue was last processed at " . get_queue_proc_timestamp() . "<br>That was " . $sdiff . "</p>";
	if($diff > 300)
	{
		$test_status[$index] .= "<p>The lookup queue processor doesn't seem to be running as a cronjob or you are not running it frequently!</p>";
		$test_status[$index+1] = "alert.png";
	}
	else
	{
		$test_status[$index+1] = "success.png";
	}
}
else
{
	$test_status[$index] .= "<p>Unable to find the last lookup queue processor time-stamp</p>";
	$test_status[$index+1] = "error.png";
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"> 
<html>
<?php
	$header_image = get_main_logo_image();
	$image_path = get_base_path() . "lib/css/img/";
	$jqtheme = "redmond";
	$jqtheme = get_theme_name($jqtheme);
	$title = "Watch My Domains SED Installation Check";
	$favicon = get_favicon_name();
	$favpngf = get_favicon_name(true);
?>
	<head>
		<title><?php echo $title; ?></title>
		<meta http-equiv="Content-Language" content="en">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link rel="shortcut icon" type="image/x-icon" href="../../lib/css/img/<?php echo $favicon; ?>">
		<style type="text/css">
			body
			{ 
				background-image:url("../../lib/css/img/<?php echo $favpngf; ?>");
				background-position: 55% 55px;
				background-repeat:no-repeat;
				background-attachment:scroll;
				background-color: #CDECFE;
			}
			#databox
			{
				width: 520px;
				margin-left: auto;
				margin-right: auto;
				padding: 10px;
				padding-top: 16px;
				padding-bottom: 12px;
				margin-top: 60px;
				margin-bottom: 60px;
				background-color: #FFF;
				color: #000;
				font-family: 'Trebuchet MS', 'Lucida Sans Unicode', verdana, arial, helvetica, sans-serif;
				font-size: 15px;
				box-shadow: rgba(34, 25, 25, 0.398438) 0px 1px 3px 0px; -webkit-box-shadow: rgba(34, 25, 25, 0.398438) 0px 1px 3px 0px;
				border-radius: 0px;
				opacity:0.90;filter: alpha(opacity=90);
			}
			#databox .dotline {border-bottom: 1px dotted #055C69; height:9px; margin-bottom:9px;}
			.center {text-align:center;}
		</style>
	</head>
	<body>
	<div id="databox" style="padding-left:20px; padding-right:20px;">

	<p style="text-align:center; margin-top:0px;"><img src="<?php echo get_main_logo_image(); ?>"></p>
	<div class="dotline"></div>
	<br>
<?php
	$i = 0;
	for($i = 0; $i < count($test_status)/2; $i++)
	{
		echo "<table width=\"100%\">";
		echo "<tr><td width=\"30\"></td>";
		echo "<td width=\"60\" valign=top>";
		if($test_status[$i*2+1] != "")
			echo "<img style=\"margin-top:10px;\" src=\"" . $image_path . $test_status[$i*2+1] . "\" width=\"24\" height=\"24\">";
		else
			echo "&nbsp";
		echo "</td valign=top>";
		echo "<td>" . $test_status[$i*2] . "</td></tr>";
		echo "</table>";
	}
	echo "\n<br>";
	echo "<div class=\"dotline\"></div>";
	echo "<p class=\"center nomargin\">" . "<a href=\"" . get_base_path() . "lib/php/links.php?r=support" . "\">Support</a>";
	echo "&nbsp;&nbsp;|&nbsp;&nbsp;";
	echo "<a href=\"" . get_base_path() . "\">Watch My Domains Server Edition</a>";
	echo "&nbsp;&nbsp;|&nbsp;&nbsp;";
	echo "<a href=\"" . get_base_path() . "menu.php\">Main Menu</a>";
	echo "</p>";
	echo "</div>";
	echo "</body>\n";
?>
</html>

<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
