<?php

/////////////////////////////////////////////////////////////////////////////////////////

function openssl_to_timestamp ($in) 
{
	$year  = substr($in, 0, 2); /* NOTE: Yes, this returns a two digit year */
	$month = substr($in, 2, 2);
	$day   = substr($in, 4, 2);
	$hour  = substr($in, 6, 2);
	$min   = substr($in, 8, 2);
	$sec   = substr($in, 10, 2);
	return gmmktime($hour, $min, $sec, $month, $day, $year);
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_all_ssl_records($domain, $spit_out=false)
{
	$rootSSLChecked = false;
	$sid = get_sid_from_domain_name($domain);
	global $db_config_subdomain_table;
	$sql = "select subdomain,hid,record_type,ssl_issued_by,ip from " . $db_config_subdomain_table . " where sid = $sid";
	$idresults = mysql_query($sql) or die ("Error reading from database");  
	while($row = mysql_fetch_array($idresults,MYSQL_ASSOC)) 
	{
		$host = $row['subdomain'];
		$hid  = $row['hid'];
		$type = $row['record_type'];
		$sslby = $row['ssl_issued_by'];
		if($host == "@" && $type == "A" && !$rootSSLChecked && $sslby != "")
		{
			// Look for the first A record and do the root SSL check
			// For compatibility with versions older than Aug 2014 builds.
			// This block may be removed in later versions.
			get_ssl_records("", $domain, $hid, $spit_out);
			$rootSSLChecked = true;
		}
		else if($host == "@" && $type == "" && !$rootSSLChecked)
		{
			get_ssl_records("", $domain, $hid, $spit_out);
			$rootSSLChecked = true;
		}
		else if($host != "" && $host != "@")
			get_ssl_records($host, $domain, $hid, $spit_out);
	}
	
	// Add a @ record with a blank 'type' that will hold the SSL data for the root domain.
	if($rootSSLChecked == false)
	{
		$sqlAdd = "insert into $db_config_subdomain_table (`subdomain`, `added_on`, `record_type`, `sid`) values ('@', now(), '', $sid)";
		$result = mysql_query( $sqlAdd ) or die ("Error adding to database");  
		$hid = mysql_insert_id();
		get_ssl_records("", $domain, $hid, $spit_out);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_ssl_records($host, $domain, $hid, $spit_out=false)
{
	$subdomain = $host;
	if($subdomain == "@")
		$subdomain = "";
		
	$data_array = Array();
	if($host != "@")
	{
		$hostname = idn_convert_to_host_name($domain, $subdomain);
		
		if($host == "")
		{
			// Find the IP for root domain entry
			$ip = gethostbyname($hostname);
			if($ip != $hostname)
				$data_array['ip'] = $ip;
			else
				$data_array['ip'] = "";
		}

		$get = @stream_context_create(array("ssl" => array("capture_peer_cert" => TRUE, "verify_peer"=>false, "verify_peer_name"=>true)));
		$read = @stream_socket_client("ssl://" . $hostname . ":443", $errno, $errstr, 30, STREAM_CLIENT_CONNECT, $get);
		if($read != false)
		{
			$cert = stream_context_get_params($read);
			$certd = $cert["options"]["ssl"]["peer_certificate"];
			$parsed = openssl_x509_parse($cert["options"]["ssl"]["peer_certificate"]);
			
			if(isset($parsed['validFrom']))
				$data_array['ssl_valid_from'] = date("Y-m-d H:i:s", openssl_to_timestamp($parsed['validFrom']));
			if(isset($parsed['validTo']))
				$data_array['ssl_valid_to'] = date("Y-m-d H:i:s",openssl_to_timestamp($parsed['validTo']));
			if(isset($parsed['subject']['CN']))
				$data_array['ssl_issued_to'] = $parsed['subject']['CN'];
			if(isset($parsed['issuer']['CN']))
				$data_array['ssl_issued_by'] = $parsed['issuer']['CN'];
		}
	}
	
	if(count($data_array))
	{
		$data_array['id' ] = $hid;
		update_subdomain_table($data_array, $host, $domain);
		
		$domain_data['ssl_checked_at'] = date("Y-m-d H:i:s");
		update_domain_table($domain_data, $domain);
		
		if($spit_out)
		{
			echo "<pre>"; print_r($data_array); echo"</pre>";
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

?>
