<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2010-2014 Softnik Technologies
// 
// Initial Version: AK
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////

require_once("config.check.php");
require_once("../../config.php");
require_once("base.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Ajax script. 
# Check authentication and quit with http error code if auth fails.

session_start();
check_authentication_error_quit();
if(!is_user_auth_enabled())
	exit;
if(is_admin_user())
	exit;
doSessionSwipeIn();

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$oldpass = "";
$username = "";
$newpass  = "";
if(isset($_REQUEST['old_pwd']))
	$oldpass = $_REQUEST['old_pwd'];
if(isset($_REQUEST['username']))
	$username = $_REQUEST['username'];
if(isset($_REQUEST['new_pwd_1']))
	$newpass = $_REQUEST['new_pwd_1'];
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////

if($oldpass != "" && $username != "" && $newpass != "" && is_ok_to_process_form("user-selfadmin-form"))
{
	require_once("pdo/cppdo.php");
	require_once("auth/basic.auth.php");
	$pdo = new cpUserManager($db_table_prefix);
	$dbh = $pdo->openMySQL($db_config_host, $db_config_database, $db_config_username, $db_config_password);
	if($dbh)
	{
		$pdo->initTables();
		
		if($pdo->isValidLogin($username, $oldpass) === true)
		{
			if($pdo->resetUserPassword($username, $newpass) === true);
			{
				echo "Password Changed!";
				exit;
			}
		}
		else
			echo "Current Password is Wrong!";
	}
}
else
	echo "Incorrect Input!";

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
