<?php
///////////////////////////////////////////////////////////////////////////////////////////////////
#  Author:   Anil Kumar
#  Version:	 1.0
#  Date:     2-Jun-2013
#  Purpose:  Preferences Handling
#  Requires: Requires PHP5, PDO
#  Usage Example:
#                     	require_once("lib/php/pdo/cpppdo.php");
#						require_once("lib/php/base.php");
#						require_once("lib/php/preferences.php");
#                     	$pdo = new cpPreferences();
#						...
///////////////////////////////////////////////////////////////////////////////////////////////////

class cpPreferences extends cpPDO
{
	public $settings_table 		= null;
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	public function __construct($table_prefix="")
	{ 
		$this->settings_table 		= trim(strtolower($table_prefix . "settings"));
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	public function getColumns($tablename)
	{
		$columns = array();
		if(strtolower($tablename) == $this->settings_table)
		{
			$columns[] = "id";
			$columns[] = "bigint(20)";
			$columns[] = "NOT NULL AUTO_INCREMENT";
			
			$columns[] = "name";
			$columns[] = "varchar(255)";
			$columns[] = "NOT NULL DEFAULT ''";
			
			$columns[] = "value";
			$columns[] = "varchar(255)";
			$columns[] = "NOT NULL DEFAULT ''";
		}
		return $columns;
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	public function getDefaultKeys($tablename)
	{
		if(strtolower($tablename) == $this->settings_table)
			return "PRIMARY KEY (id), UNIQUE KEY name (name)";
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	public function initTables()
	{
		$this->initTable($this->settings_table);
		$this->repairTable($this->settings_table);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	public function setValue($name, $value)
	{
		try
		{
			$stmt = $this->db_connect_handle->prepare("SELECT * FROM " . $this->settings_table . " WHERE name=?");
			$stmt->execute(array($name));
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			if(count($rows) == 0)
			{
				$stmt = $this->db_connect_handle->prepare("INSERT INTO " . $this->settings_table . " (name,value) VALUES(:name,:value)");
				$stmt->execute(
				array(
				':name' => $name, ':value' => $value
				));
				return true;
			}
			else
			{
				$stmt = $this->db_connect_handle->prepare("UPDATE " . $this->settings_table . " SET value=? WHERE name=?");
				$stmt->execute(array($value,$name));
				return true;
			}
		}
		catch (PDOException $e) 
		{
			$this->setError($e->getMessage());
			return false;
		}
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	public function getValue($name)
	{
		try
		{
			$stmt = $this->db_connect_handle->prepare("SELECT * FROM " . $this->settings_table . " WHERE name=?");
			$stmt->execute(array($name));
			$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
			if(count($rows) == 1)
			{
				return $rows[0]['value'];
			}
			return false;
		}
		catch (PDOException $e) 
		{
			$this->setError($e->getMessage());
			return false;
		}
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	public function setNumber($name, $value)
	{
		return $this->setValue($name, strval($value));
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////
	
	public function getNumber($name)
	{
		$value = $this->getValue($name);
		if($value !== false)
		{
			if(ctype_digit($value))
				return intval($value);
		}
		return false;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////

?>
