<?php

/////////////////////////////////////////////////////////////////////////////////////////////////////////
require_once("phpmailer/class.phpmailer.php");
/////////////////////////////////////////////////////////////////////////////////////////////////////////
 
class AutoResponderMailer extends PHPMailer
{
    function AutoResponderMailer()
    {
		global $app_config;
		
		$this->SetLanguage($app_config['interface_language']);
	
		if(strcasecmp($app_config['email_send_method'], "smtp") == 0)
		{
			$this->IsSMTP();                                      
			$this->Host       = $app_config['email_smtp_server'];
			$this->SMTPAuth   = $app_config['email_smtp_user'] == '' ? false : true;     
			$this->SMTPSecure = $app_config['email_smtp_secure'];
			$this->Port       = $app_config['email_smtp_port'];
			$this->Username   = $app_config['email_smtp_user'];
			$this->Password   = $app_config['email_smtp_password'];
		}
		else if(strcasecmp($app_config['email_send_method'], "qmail") == 0)
			$this->IsQmail();
		else if(strcasecmp($app_config['email_send_method'], "sendmail") == 0)
			$this->IsSendmail();
		else if(strcasecmp($app_config['email_send_method'], "default") == 0)
			$this->IsMail();
		
		$this->CharSet   = 'UTF-8';
		$this->WordWrap  = $app_config['email_word_wrap'];
		$this->From      = $app_config['email_from_address'];
		$this->FromName  = $app_config['email_from_name'];
		
		if($app_config['email_reply_address'] != "" && $app_config['email_reply_name'] != "")
			$this->AddReplyTo($app_config['email_reply_address'], $app_config['email_reply_name']);
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function send_email($htmlmsg, $subject, $toemail, $toname="")
{
	global $app_config;
	
	$ishtml = false;
	if(preg_match('/^'.preg_quote("<html>")."/", $htmlmsg))
		$ishtml = true;
	
	$status  = "";
	$retstat = true;
	
	if($htmlmsg != "")
	{
		$mail = new AutoResponderMailer();

		$mail->IsHTML($ishtml);                                  
		$mail->AddAddress($toemail, $toname);
		$mail->Subject = $subject;
		$mail->MsgHTML(trim($htmlmsg));
		$mail->CharSet   = 'UTF-8';
		$mail->WordWrap  = $app_config['email_word_wrap'];

		if(!$mail->Send())
		{
		   $status = "fail: " . $mail->ErrorInfo;
		   $retstat = false;
		}
		
		$mail->ClearAddresses();
		$mail->ClearAttachments();
		$mail->IsHTML(false);
	}
	
	return $retstat == true ? $retstat : $status;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>