<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2010-2011 Softnik Technologies
// Version 0.1.11 2011-01-15
/////////////////////////////////////////////////////////////////////////////////////////////////////////

require_once("idn.php");
require_once("dns.php");
require_once("whois.php");
require_once("http.php");
require_once("googlepr.php");
require_once("alexa.php");
require_once("mx.php");
require_once("ssl.php");
require_once("googleindex.php");

///////////////////////////////////////////////////////////////////////////////////////////////////
// Do Lookup
// Find the next lookup candidate entry in queue 
// Mark it's status as "in progress" and set last_updated time.
// Finish the lookup and set it's status as completed or failed. 
// Set last_updated time.

function process_lookup_queue($max_count, $start_from=0, $prefer="")
{
	global $db_config_lookup_queue_table, $db_config_domain_table;
	global $config_subdomain_entry;
		
	$lookup_array = array();
	$count = 0;
	
	$sql = "select * from " . $db_config_lookup_queue_table . " order by created_on asc";
	
	if($prefer != "")
	{
		$where = "";
		$luts = explode(",", $prefer);
		foreach($luts as $luw)
		{
			$luw = strtolower(trim($luw));
			if($luw == "alexa")
				$where .= " | type=" . intval(LOOKUP_ALEXA_DATA);
			else if($luw == "dw")
				$where .= " | type=" . intval(LOOKUP_DOMAIN_WHOIS);
			else if($luw == "sdw")
				$where .= " | type=" . intval(LOOKUP_SEC_DOMAIN_WHOIS);
			else if($luw == "gpr")
				$where .= " | type=" . intval(LOOKUP_GOOGLE_PR);
			else if($luw == "ip")
				$where .= " | type=" . intval(LOOKUP_IP_ADDRESS);
			else if($luw == "mx")
				$where .= " | type=" . intval(LOOKUP_MX_RECORDS);
			else if($luw == "ipw")
				$where .= " | type=" . intval(LOOKUP_IP_WHOIS);
			else if($luw == "http")
				$where .= " | type=" . intval(LOOKUP_HTTP_HOMEPAGE);
			else if($luw == "ping")
				$where .= " | type=" . intval(LOOKUP_PING_RESPONSE);
			else if($luw == "ssl")
				$where .= " | type=" . intval(LOOKUP_SSL_CERTS);
			else if($luw == "gi")
				$where .= " | type=" . intval(LOOKUP_GOOGLE_INDEX);
			else if($luw == "dns")
				$where .= " | type=" . intval(LOOKUP_SUB_DOMAINS);
		}
		$where = trim($where, "| ");
		$where = str_replace("|", "OR", $where);
		if($where != "")
			$sql = "select * from $db_config_lookup_queue_table WHERE ($where) order by created_on asc";
	}
	
	if($start_from != 0 && $start_from > 0 && $start_from < 150000)
	{
		$endat = $start_from+$max_count+1;
		$limit = " LIMIT $start_from, $endat";
		$sql .= $limit;
	}
	$result = mysql_query( $sql ) or die("Couldn't execute your query.".mysql_error());
	while($row = mysql_fetch_array($result,MYSQL_ASSOC))
	{
		$lookup_array[$count] = $row;
		$lookup_type   = $row['type'];
		$sid           = $row['sid'];
		$dsql = "Delete FROM $db_config_lookup_queue_table WHERE sid=$sid AND type='$lookup_type'";
		$dresult = mysql_query($dsql);
		$count++;
		if($count == $max_count)
			break;
	}
	
	// Prefered lookup queue is empty. So process the rest.
	if($count == 0 && $prefer != "")
		return process_lookup_queue($max_count, $start_from, "");
		
	$subdomain	   = "www";
	if(isset($config_subdomain_entry))
		$subdomain = $config_subdomain_entry;
	
	$processed = 0;
	foreach($lookup_array as $row)
	{
		$sid           = $row['sid'];
		$lookup_type   = $row['type'];
		$lookup_status = $row['status'];
		$server        = $row['server'];
		$domain_name   = get_domain_name_from_sid($sid);
		$status        = true;
		if($lookup_status == LUQSTAT_WAITING)
		{
			switch($lookup_type)
			{
				case LOOKUP_DOMAIN_WHOIS:
					$status = do_domain_registry_whois($domain_name);
					break;
				case LOOKUP_SEC_DOMAIN_WHOIS:
					$status = do_domain_registrar_whois($domain_name, $server);
					break;
				case LOOKUP_IP_ADDRESS:
					do_ip_lookup($domain_name, $subdomain);
					break;
				case LOOKUP_HTTP_HOMEPAGE:
					get_and_parse_homepage($domain_name, $subdomain);
					break;
				case LOOKUP_ALEXA_DATA:
					get_alexa_records($domain_name, $subdomain);
					break;
				case LOOKUP_MX_RECORDS:
					get_mx_records($domain_name);
					break;
				case LOOKUP_PING_RESPONSE:
					get_ping_response($domain_name, $subdomain);
					break;
				case LOOKUP_YAHOO_LINKS:
					break;
				case LOOKUP_GOOGLE_LINKS:
					break;
				case LOOKUP_GOOGLE_PR:
					get_google_pr($domain_name, $subdomain);
					break;
				case LOOKUP_SSL_CERTS:
					get_all_ssl_records($domain_name);
					break;
				case LOOKUP_IP_WHOIS:
					do_ip_whois($domain_name);
					break;
				case LOOKUP_SUB_DOMAINS:
					do_subdomain_lookup($domain_name);
					break;
				case LOOKUP_GOOGLE_INDEX:
					$status = get_google_index($domain_name, $subdomain);
					break;
			}
			if($status == false)
			{
				if($lookup_type == LOOKUP_SEC_DOMAIN_WHOIS)
					add_to_registrar_whois_lookup_queue($sid, $server, 0);
				else if($lookup_type == LOOKUP_DOMAIN_WHOIS)
					add_to_lookup_queue($sid, $lookup_type, 0);
				else if($lookup_type == LOOKUP_GOOGLE_INDEX)
					add_to_lookup_queue($sid, $lookup_type, 0);
			}
		}
		if($status)
			$processed++;
	}
	
	// Nothing got processed trying preferred lookups, 
	// let us achieve something.
	if($processed < 3 && $prefer != "" && $count)
	{
		$maxc = ($max_count/2) - $processed;
		// Do we have the time for processing all?
		global $script_started_at;
		if(isset($script_started_at))
		{
			$set = microtime(true);
			$ext = round($set-$script_started_at);
			if(ext < 8)
				$maxc = $max_count-$processed;
		}
		if($maxc == 0)
			$maxc = 1;
		return process_lookup_queue($maxc, $start_from, "");
	}
	
	if($count)
	{
		log_queue_lookup_timestamp();
	}
	
	$sqlCount = "SELECT COUNT(*) AS count from " . $db_config_lookup_queue_table;
	$countResult = mysql_query( $sqlCount ) or die("Couldn't execute your query.".mysql_error());
	$existing = mysql_fetch_array($countResult);  
	
	$existing['processed'] = $processed;
	return $existing;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

?>
