<?php

error_reporting( E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# The license code.

if(!isset($license_key_code))
	$license_key_code = "u2WyiYiv0ainYq20dmKLil93iZikfQ==";
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////

# This is valid only for Professional Edition with multiple servers. Set it to false if you want each
# server to use unique settings. For example, you can use one server to do only whois lookups, another
# to do only IP lookups etc.

if(!isset($multi_server_global_settings))
	$multi_server_global_settings = true;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Default Lookup Types
# When you add domains to the DB, they are automatically queued to do domain whois and DNS (to find the
# domains's default IP address). You can change the default behaviour by specifying what to lookup.
# The entry can be a comma separated list containing one or more of dw,ipw,gpr,mx,ping,alexa,ip,http,gi
# dw = domain whois, ipw = ip whois, ip = main ip of domain etc.
# Example: "dw,ipw,ip"
# Leaving it empty, will default to "dw,ip" (domain whois and IP)

if(!isset($default_lookup_types))
	$default_lookup_types 	= "";
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Default Sub Domains
# When you add domains to the DB, the application can automatically attach a set of sub-domains also
# Specify something like "www,mail" to attach two sub domains "mail" and "www". The entries should be
# comma separated.

if(!isset($default_sub_domains))
	$default_sub_domains = "";

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Do DNS Record Lookups in addition to finding the base IP
# The "DNS/SSL Records" tab in the lower pane will show the domain's root DNS records if this is
# set to true. This is useful for quickly checking all the base DNS entries for the domain. 
# Only the A, NS, and MX record types (along with TTL) are shown.

if(!isset($do_dns_record_lookup))
	$do_dns_record_lookup   = true;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# The application processes lookup queue in a FIFO manner (First-In First-Out). This means that if you 
# first queue 1000 domains for MX lookup and then queue the same domains for IP Whois, the IP Whois will
# happen only after all the MX Lookups are done. 
# This option tells the app that certain types of queued lookups should be always done first.
# The entry can be a comma separated list containing one or more of dw,sdw,ipw,gpr,mx,ping,alexa,ip,
# http,gi
# sdw = secondary domain whois (registrar whois lookups for com, net, etc)
# Example: "dw,mx" will tell the app to do all domain whois and MX lookups first and then the rest.
# Leaving it empty, will default to FIFO.

if(!isset($high_preference_lookups))
	$high_preference_lookups = "dw,ip";

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# At times, some whois servers simply return an empty result on lookup. You can make the application 
# requeue those lookups by setting the variable below to true. Setting this to true can cause the
# application to continuously retry lookups on whois servers that are blocking you and not sending
# any feedback.

if(!isset($requeue_on_empty_whois))
	$requeue_on_empty_whois  = false;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# For the app to work, proper domain names should be entered (example.com and not www.exaple.com)
# Use $fix_host_domain_names to try and fix domain whois when host names are entered instead of actual 
# domain names. If this is set to true and www.example.com is entered, the app will try to find the 
# domain  name (example.com) before a whois. This can cause problems for second level country code  
# domains like www.net.uk. So it is better to leave the default as it is.

if(!isset($fix_host_domain_names))
	$fix_host_domain_names = false;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# The application can add a subdomain to the start of the domain name before doing home page checks,
# web visibility, ip check and ping. By default this is "". You can change it to the normal "www".

if(!isset($config_subdomain_entry))
	$config_subdomain_entry = "";

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Specify the maximum redirects the application should follow when doing home page checks. Please 
# note that php::curl is required for this. The allowed values are 0-10.

if(!isset($home_page_max_redirs))
	$home_page_max_redirs = 3;
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Specify these two entries to enable authentication. Both the user name and password must be entered. 
# If any one of them is blank, the authentication system will be disabled. The password must be 
# at least 6 characters long. If the admin password is less than 6 characters long, the credentials 
# will not be accepted during login. Plain text admin password must not be longer than 24 characters.

# Please note that session support should be configured properly in PHP for authentication to work.

if(!isset($do_password_protect))
	$do_password_protect = false;

if(!isset($admin_user_name))
	$admin_user_name = "";
	
if(!isset($admin_password))
	$admin_password = "";

# Optionally you can use a salted & hashed password. Please see "lib/php/salt-hash.php"

# Note: Installation over SSL is strongly recommended.

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$admin_user_name_in_config = ($admin_user_name == "" ? false : true);
$admin_user_password_in_config = ($admin_password == "" ? false : true);

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Do you want to use re-CAPTCHA on the login screen? re-CAPTCHA helps prevent automated login atempts.
# Signup at http://www.google.com/recaptcha and get the two keys. Enter it here.

if(!isset($recaptcha_public_key))
	$recaptcha_public_key   = "";

if(!isset($recaptcha_private_key))
	$recaptcha_private_key  = "";

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Set the session timeout in minutes. Set it to 0 for no session timeouts.

if(!isset($auth_timeout_minutes))
	$auth_timeout_minutes	= 15;

# Specify the maximum number of login attempts before the user's IP is locked out. Set this to 0
# if you want to allow unlimited login attempts. Otherwise the user's IP will be locked out for
# a specific number of minutes as set in $login_lockout_minutes.

if(!isset($max_login_attempts))
	$max_login_attempts     = 8;
	
if(!isset($login_lockout_minutes))
	$login_lockout_minutes  = 10;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Visual Settings

# Supported themes are redmond, smoothness, sunny, le-frog, ui-darkness, pepper-grinder & black-tie
# flick and sed-start

if(!isset($ui_theme))
	$ui_theme = "redmond";  

if(!isset($recaptcha_theme))
	$recaptcha_theme = "red";      // Can be white, red or blackglass

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# IDNA Version (for International Domain Name Support)
#
# IDNA 2008 is a revision of IDNA 2003, approved in 2010. In most cases it produces the same results 
# as IDNA 2003. However, it disallows about eight thousand characters that used to be valid (uppercase 
# characters, full/half-width variants, symbols, punctuation etc.) It also interprets four characters 
# (U+00DF, U+03C2, U+200C, U+200D) differently
#
# To use the old IDNA 2003, set this to false.

if(!isset($use_idna_2008))
	$use_idna_2008 = true;

# Please note that the application will still allow you to enter domains like bcher.com 
# (xn--bcher-2pa.com in IDNA 2008) though it is has an invalid uppercase character that is disallowed
# in IDNA 2008. Just remember that you may not be able to registar domains that contain uppercase
# IDN characters.

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Customize the 'Online Tools' Tab (optional)

# Specify the relative path to a file that will be appended to the online tools display.
# This can contain any HTML with links and images. If you have {{domain}} anywhere in a link, it will
# be replaced with the currently selected domain name. You should probably put any file you
# create in the "lib/php/custom/" folder so that it will not be over-written on an app update.

if(!isset($custom_tools_file))
	$custom_tools_file = "lib/php/custom/domaintools-sample.php";

# Enable the search dialog in the domain table grid.

if(!isset($domain_grid_search))
	$domain_grid_search = false;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Specify the date format to use in the domain table.
# You can use formats like "d-M-Y", "Y-m-d", "M d Y", etc.

if(!isset($cell_date_format))
	$cell_date_format = "d-M-Y";

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Branding & Button links.
# Please note that you should modify these only after you have purchased a license.

# To remove any of these buttons from the interface, simply set it's value to "".

if(!isset($home_page_link))
	$home_page_link = "";
	
if(!isset($product_page_link))
	$product_page_link = "";
	
if(!isset($support_page_link))
	$support_page_link = "https://watchmy.domains/sed/guide/";

if(!isset($contact_page_link))
	$contact_page_link = "https://support.softnik.com/contactus/";

# The main logo image. It should be 300x36 or smaller and ideally should have a transparent background. 
# Remember to check it on all themes. You may need to clear the browser cache to see any changes you 
# make to the logo here.

if(!isset($main_logo_image))
	$main_logo_image = "";

# Enter the entity name the application is licensed to. This is valid only for professional version. 
# Leave it blank for standard version and demo / evaluation. For standard version, this will be ignored
# and the name from the license code will be automatically used.
# You can use unicode characters like 机, машина, etc. Make sure that you save this file in 
# UTF-8 (without BOM) encoding.

if(!isset($legal_licensee_name))
	$legal_licensee_name    = "";
	
if(!isset($cli_auth_key_code))
	$cli_auth_key_code = "";
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////
	
require_once("rc4two.php");
if(file_exists(realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR . "config/app.conf.php")))
	require_once("config/app.conf.php");
else
{
	$app_config	= Array(
	'id'							=> 1,
	'email_from_address'			=> "contact@example.com",
	'email_from_name'				=> "Company Name",
	'email_reply_address'			=> "",
	'email_reply_name'				=> "",
	'email_send_method'				=> "default",      // sendmail, qmail, default, smtp
	'email_smtp_server'				=> 'smtp.gmail.com',
	'email_smtp_secure' 			=> 'tls',		  // ssl, tls
	'email_smtp_port' 				=> 587, 
	'email_smtp_user'				=> "",  
	'email_smtp_password' 			=> "", 
	'interface_language'			=> "en",
	'email_word_wrap'				=> 50
	);
}
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////

function _get_install_server_id_()
{
	global $install_server_id;
	if(isset($install_server_id))
	{
		$install_id = strtolower(trim($install_server_id));
		if($install_id != "")
		{
			if($install_id == "auto")
				$install_id = strtolower(php_uname('n'));
		}
		if($install_id != "")
			return $install_id;
	}
	return "master";
}
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////

function get_string_value_or_set_default($pdo, $field_name, &$variable, $setit=true)
{
	global $multi_server_global_settings;
	$real_field_name = $field_name;
	if($multi_server_global_settings == false)
		$field_name = _get_install_server_id_() . "-" . $field_name;
	else
		$field_name = "master_" . $field_name;
			
	$str_entry = $pdo->getValue($field_name);
	if($str_entry !== false)
	{
		// If the config file contains a licensee name but the 
		// DB entry is blank, use the value from the config file
		// If the config file contains a value and is different 
		// from the DB entry, use the config file entry.
		// Otherwise use the value from DB.
		if($real_field_name == "legal_licensee_name")
		{
			if($variable == "" && $str_entry != "")
				$variable = $str_entry;
		}
		else if(($real_field_name == "email_smtp_password" || $real_field_name == "cli_auth_key_code") && $str_entry != "")
		{
			$variable = rc4two($str_entry, md5("160119661604199705011969"), false);
			$len = strlen($variable) - 25;
			$variable = substr($variable, 0, $len);
		}
		else
			$variable = $str_entry;
	}
	else
	{
		if($setit)
		{
			if($real_field_name == "admin_password")
			{
				if(strlen($variable) < 25 && strlen($variable) >= 6)
				{
					$salt = substr(md5(uniqid(rand(), true)), 0, 25);
					$variable = $salt . sha1($salt . $variable);
				}
			}
			if($real_field_name == "email_smtp_password" || $real_field_name == "cli_auth_key_code")
			{
				if($variable == "" && $real_field_name == "cli_auth_key_code")
					$variable = substr(md5(uniqid(rand(), true)), 0, 16);
				$salt = substr(md5(uniqid(rand(), true)), 0, 25);
				$variable = rc4two($variable . $salt, md5("160119661604199705011969"));
			}
			$pdo->setValue($field_name, $variable);
			if($real_field_name == "email_smtp_password" || $real_field_name == "cli_auth_key_code")
			{
				$variable = rc4two($variable, md5("160119661604199705011969"), false);
				$len = strlen($variable) - 25;
				$variable = substr($variable, 0, $len);
			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function get_num_value_or_set_default($pdo, $field_name, &$variable, $setit=true)
{
	if($field_name != "multi_server_global_settings")
	{
		global $multi_server_global_settings;
		if($multi_server_global_settings == false)
			$field_name = _get_install_server_id_() . "-" . $field_name;
		else
			$field_name = "master_" . $field_name;
	}
	else
		$field_name = "master_" . $field_name;
	
	$num_entry = $pdo->getNumber($field_name);
	if($num_entry !== false)
		$variable = $num_entry;
	else
	{
		if($setit)
		{
			if($variable === true)
				$varval = 1;
			else if($variable === false)
				$varval = 0;
			else
				$varval = $variable;
			$pdo->setNumber($field_name, $varval);
		}
	}
}
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////

function load_config_data_values_from_db()
{
	require_once("pdo/cppdo.php");
	require_once("preferences.php");
	
	global $db_config_host, $db_config_database, $db_config_username, $db_config_password, $db_table_prefix;
	global $multi_server_global_settings;
	global $license_key_code, $default_lookup_types, $high_preference_lookups, $config_subdomain_entry, $default_sub_domains;
	global $admin_user_name, $admin_password;
	global $recaptcha_public_key, $recaptcha_private_key, $ui_them, $recaptcha_theme;
	global $custom_tools_file, $cell_date_format, $home_page_link, $product_page_link;
	global $support_page_link, $contact_page_link, $main_logo_image, $legal_licensee_name, $cli_auth_key_code;
	
	global $do_dns_record_lookup, $requeue_on_empty_whois, $fix_host_domain_names, $home_page_max_redirs;
	global $do_password_protect, $auth_timeout_minutes, $max_login_attempts, $login_lockout_minutes;
	global $use_idna_2008, $domain_grid_search, $ui_theme;
	
	$pdo = new cpPreferences($db_table_prefix);
	$dbh = $pdo->openMySQL($db_config_host, $db_config_database, $db_config_username, $db_config_password);
	if($dbh)
	{
		$pdo->initTables();
		
		# Read the 'multi_server_global_settings' first. Rest of the settings are 
		# dependent on that.
		get_num_value_or_set_default($pdo, "multi_server_global_settings", $multi_server_global_settings);
		
		get_num_value_or_set_default($pdo, "do_dns_record_lookup", $do_dns_record_lookup);
		get_num_value_or_set_default($pdo, "requeue_on_empty_whois", $requeue_on_empty_whois);
		get_num_value_or_set_default($pdo, "fix_host_domain_names", $fix_host_domain_names);
		get_num_value_or_set_default($pdo, "home_page_max_redirs", $home_page_max_redirs);
		get_num_value_or_set_default($pdo, "do_password_protect", $do_password_protect);
		get_num_value_or_set_default($pdo, "auth_timeout_minutes", $auth_timeout_minutes);
		get_num_value_or_set_default($pdo, "max_login_attempts", $max_login_attempts);
		get_num_value_or_set_default($pdo, "login_lockout_minutes", $login_lockout_minutes);
		get_num_value_or_set_default($pdo, "use_idna_2008", $use_idna_2008);
		get_num_value_or_set_default($pdo, "domain_grid_search", $domain_grid_search);
		
		get_string_value_or_set_default($pdo, "license_key_code", $license_key_code);
		get_string_value_or_set_default($pdo, "default_lookup_types", $default_lookup_types);
		get_string_value_or_set_default($pdo, "high_preference_lookups", $high_preference_lookups);
		get_string_value_or_set_default($pdo, "config_subdomain_entry", $config_subdomain_entry);
		# If the config.php already has an admin username or password don't 
		# read from DB.
		if($admin_user_name == "")
			get_string_value_or_set_default($pdo, "admin_user_name", $admin_user_name, false);
		if($admin_password == "")
			get_string_value_or_set_default($pdo, "admin_password", $admin_password, false);
		get_string_value_or_set_default($pdo, "recaptcha_public_key", $recaptcha_public_key);
		get_string_value_or_set_default($pdo, "recaptcha_private_key", $recaptcha_private_key);
		get_string_value_or_set_default($pdo, "ui_theme", $ui_theme);
		get_string_value_or_set_default($pdo, "recaptcha_theme", $recaptcha_theme);
		get_string_value_or_set_default($pdo, "custom_tools_file", $custom_tools_file);
		get_string_value_or_set_default($pdo, "cell_date_format", $cell_date_format);
		get_string_value_or_set_default($pdo, "home_page_link", $home_page_link);
		get_string_value_or_set_default($pdo, "product_page_link", $product_page_link);
		get_string_value_or_set_default($pdo, "support_page_link", $support_page_link);
		get_string_value_or_set_default($pdo, "contact_page_link", $contact_page_link);
		get_string_value_or_set_default($pdo, "main_logo_image", $main_logo_image);
		get_string_value_or_set_default($pdo, "legal_licensee_name", $legal_licensee_name);
		
		// July 23, 2014
		get_string_value_or_set_default($pdo, "default_sub_domains", $default_sub_domains);
		//
		
		// Oct 11 2014
		get_string_value_or_set_default($pdo, "cli_auth_key_code", $cli_auth_key_code);
		global $app_config;
		get_string_value_or_set_default($pdo, "email_from_address", $app_config['email_from_address']);
		get_string_value_or_set_default($pdo, "email_from_name", $app_config['email_from_name']);
		get_string_value_or_set_default($pdo, "email_reply_address", $app_config['email_reply_address']);
		get_string_value_or_set_default($pdo, "email_reply_name", $app_config['email_reply_name']);
		get_string_value_or_set_default($pdo, "email_send_method", $app_config['email_send_method']);
		get_string_value_or_set_default($pdo, "email_smtp_server", $app_config['email_smtp_server']);
		get_string_value_or_set_default($pdo, "email_smtp_secure", $app_config['email_smtp_secure']);
		get_num_value_or_set_default($pdo, "email_smtp_port", $app_config['email_smtp_port']);
		get_string_value_or_set_default($pdo, "email_smtp_user", $app_config['email_smtp_user']);
		get_string_value_or_set_default($pdo, "email_smtp_password", $app_config['email_smtp_password']);
		get_string_value_or_set_default($pdo, "interface_language", $app_config['interface_language']);
		get_num_value_or_set_default($pdo, "email_word_wrap", $app_config['email_word_wrap']);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
 
load_config_data_values_from_db();

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
