<?php

/////////////////////////////////////////////////////////////////////////////////////////////////////////
require_once('idn/idna_convert.class.php');
/////////////////////////////////////////////////////////////////////////////////////////////////////////

function is_idn_2008()
{
	global $use_idna_2008;
	if(isset($use_idna_2008))
		return $use_idna_2008;
	else
		return false;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function idn_convert($domain)
{
	$IDN = new idna_convert(array('idn_version' => 2008));
	if(!is_idn_2008())
		$IDN->set_parameter('idn_version', 2003);
	return strtolower($IDN->encode($domain)); 
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function idn_reconvert($ascii_domain)
{
	$IDN = new idna_convert(array('idn_version' => 2008));
	if(!is_idn_2008())
		$IDN->set_parameter('idn_version', 2003);
	return $IDN->decode($ascii_domain); 
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function idn_convert_to_host_name($domain, $subdomain)
{
	$ascii_domain    = idn_convert($domain);
	$ascii_subdomain = idn_convert($subdomain);
	return ($subdomain == "" ? "" : ($ascii_subdomain . ".")) . $ascii_domain; 
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
