<?php
###############################################################################
	
require_once("config.check.php");
require_once("../../config.php");
require_once("base.php");

###############################################################################
# Only admin users can use this script.
# If user authentication is disabled, everyone is an admin user!

session_start();
check_authentication_login();
if(is_admin_user() == false)
{
	header("Location: " . get_base_path());
	exit;
}
doSessionSwipeIn();

###############################################################################

require_once("pdo/gridpdo.php");

###############################################################################

$responce = new stdClass();
$pdo = new gridPDO($db_table_prefix);
$dbh = $pdo->openMySQL($db_config_host, $db_config_database, $db_config_username, $db_config_password);
if($dbh)
{
	if(isset($_REQUEST['ecf']) && isset($_REQUEST['ecv']))
	{
		if($pdo->jqGridCount($db_config_data_history_table, "id", $responce))
		{
			$columns = "domain,fvalue,lookedup_at";
			$pdo->jqGridData($db_config_data_history_table, "id", $columns, $responce);
			if(isset($responce->rows))
			{
				$vparts = explode(",", $_REQUEST['ecv']);
				if(count($vparts) == 2)
				{
					for($i = 0; $i < count($responce->rows); $i++)
					{
						if(trim($vparts[1]) == "2")
						{
							$ip = $responce->rows[$i]['cell'][1];
							if($ip != -1)
								$ip = long2ip($ip);
							$responce->rows[$i]['cell'][1] = $ip;
						}
						else if(trim($vparts[1]) == "32")
						{
							$pr = $responce->rows[$i]['cell'][1];
							if($pr == "-1")
								$pr = "-";
							$responce->rows[$i]['cell'][1] = $pr;
						}
					}
				}
			}
		}
	}
	else
	{
		if($pdo->jqGridCount($db_config_domain_table, "sid", $responce))
		{
			$columns = "domain";
			$pdo->jqGridData($db_config_domain_table, "sid", $columns, $responce);
		}
	}
}
echo json_encode($responce);


###############################################################################
?>
