<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////

function GoogleBackLinks($domain)
{
	$url="http://ajax.googleapis.com/ajax/services/search/web?v=1.0&q=link:".$domain."&filter=0";
	if(is_callable('curl_init'))
	{
		$ch=curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_USERAGENT,$_SERVER['HTTP_USER_AGENT']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt ($ch, CURLOPT_HEADER, 0);
		curl_setopt ($ch, CURLOPT_NOBODY, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		$json = curl_exec($ch);
		curl_close($ch);
	}
	else
		$json = file_get_contents($url);
	$data=json_decode($json,true);
	if($data['responseStatus']==200)
		return $data['responseData']['cursor']['resultCount'];
	else
		return false;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function GoogleIndexCount($domain)
{
	$url="http://ajax.googleapis.com/ajax/services/search/web?v=1.0&q=site:".$domain."&filter=0";
	if(is_callable('curl_init'))
	{
		$ch=curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_USERAGENT,$_SERVER['HTTP_USER_AGENT']);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt ($ch, CURLOPT_HEADER, 0);
		curl_setopt ($ch, CURLOPT_NOBODY, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		$json = curl_exec($ch);
		curl_close($ch);
	}
	else
		$json = file_get_contents($url);
	$data=json_decode($json,true);
	if($data['responseStatus']==200)
	{
		$icount = $data['responseData']['cursor']['resultCount'];
		return intval(str_replace(',', '', $icount));
	}
	else
		return false;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function GoogleIndexCountFromRawSearch($domain)
{	
	set_last_connect_time_for_external_server("google.com");
	$url = "https://www.google.com/search?hl=en&q=site%3A$domain";
	$data = file_get_contents($url);
	
	if($data === false)
		return false;
		
	$bannedtext = get_bannedtext_from_whoisserver("google.com");
	if(strlen($data) > 0 && strlen($bannedtext) > 0)
	{
		if(stristr($data, $bannedtext) !== false)
		{
			set_stop_lookups_for_whoisserver("google.com", true);
			return false;
		}
	}
	
	$entry = get_string_between($data, "id=\"resultStats\">", "</div>");
	$entry = strip_tags($entry);
	$pieces = explode(" ", $entry);
	$numarray = array();
	foreach($pieces as $p)
	{
		$p = str_replace(",", "", $p);
		if(is_numeric($p))
			$numarray[] = intval($p);
	}
	if(count($numarray))
	{
		sort($numarray, SORT_NUMERIC);
		return $numarray[count($numarray)-1];
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function get_google_index($domain, $subdomain="www", $spit_out=false)
{
	if(!is_ok_to_connect_to_external_server("google.com"))
		return false;
		
	$host = idn_convert_to_host_name($domain, $subdomain);
	$gicount = GoogleIndexCountFromRawSearch($domain);
	
	if($gicount === false)
		return false;
	
	$data_array['google_index_checked_at'] = date("Y-m-d H:i:s");
	$data_array['google_index_count'] = $gicount;
	if(is_array($data_array))
		update_domain_table($data_array, $domain);
	if(is_data_history_enabled("gi"))
		update_data_history($domain,intval(LOOKUP_GOOGLE_INDEX), $gicount);
	if($spit_out)
	{
		echo "<pre>"; print_r($data_array); echo "</pre>";
	}
	return true;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
