<?php

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function do_ip_lookup($domain, $subdomain="www")
{
	$host = idn_convert_to_host_name($domain, $subdomain);
	
	$iplong = -1;
	$ip = gethostbyname($host);
	if($ip != $host)
	{
		$data_array['ip'] = $ip;
		$iplong = ip2long($ip);
		do_ip_asn_lookup($ip, $data_array);
	}
	else
		$data_array['ip'] = "error";
	$data_array['ip_checked_at'] = date("Y-m-d H:i:s");
	update_domain_table($data_array, $domain);
	if(is_data_history_enabled("ip"))
		update_data_history($domain,intval(LOOKUP_IP_ADDRESS), $iplong);
		
	global $do_dns_record_lookup;
	if(isset($do_dns_record_lookup))
	{
		if($do_dns_record_lookup == true)
			do_root_dns_record_check($domain);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function get_dns_record_for_type($hostname, $type, &$ip)
{
	$data_array = Array();
	$r = dns_get_record($hostname, $type);
	if(is_array($r))
	{
		foreach($r as $record)
		{
			if(isset($record['host']))
			{
				if($record['host'] == $hostname)
				{
					if(isset($record['ttl']))
						$data_array['ttl'] = $record['ttl'];
					if(isset($record['type']))
					{
						$data_array['record_type'] = $record['type'];
						if($record['type'] == "CNAME")
						{
							if(isset($record['target']))
								$data_array['record_value'] = $record['target'];
						}
						if($record['type'] == "A")
						{
							if(isset($record['ip']))
							{
								$data_array['record_value'] = $record['ip'];
								$data_array['ip'] = $record['ip'];
							}
						}
					}
					break;
				}
				if($record['type'] == "A" && $type = DNS_A)
				{
					if(isset($record['ip']))
						$ip = $record['ip'];
				}
			}
		}
	}
	return $data_array;
}
 

/////////////////////////////////////////////////////////////////////////////////////////

function do_subdomain_lookup($domain, $spit_out=false)
{
	$sid = get_sid_from_domain_name($domain);
	global $db_config_subdomain_table;
	$sql = "select hid,subdomain,record_type,record_value from " . $db_config_subdomain_table . " where sid = $sid";
	$idresults = mysql_query($sql) or die ("Error reading from database");  
	while($row = mysql_fetch_array($idresults,MYSQL_ASSOC)) 
	{
		$host = $row['subdomain'];
		$type = $row['record_type'];
		$target = $row['record_value'];
		$hid = $row['hid'];
		do_hostname_dns_lookup($host, $domain, $type, $target, $hid, $spit_out);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////

function do_hostname_dns_lookup($host, $domain, $type, $target, $hid, $spit_out=false)
{
	$subdomain = $host;
	$hostname = "";
	if($subdomain == "@")
	{
		if($type == "NS")
			$hostname = idn_convert_to_host_name($target, "");
		else if($type == "MX")
		{
			$parts = explode(" ", $target);
			if(count($parts) == 2)
				$hostname = idn_convert_to_host_name($parts[1], "");
		}
		else
			$subdomain = "";
	}
		
	$data_array = Array();
	if(($host != "" && $host != "@") || $type == "NS" || $type == "MX")
	{
		if($type != "NS" && $type != "MX")
			$hostname = idn_convert_to_host_name($domain, $subdomain);
		
		$ipa = "";
		$ipc = "";
		$r = get_dns_record_for_type($hostname, DNS_A, $ipa);
		if(!count($r))
		{
			$r = get_dns_record_for_type($hostname, DNS_CNAME, $ipc);
		}
		if(count($r))
		{
			if($ipa != "")
				$r['ip'] = $ipa;
			//$data_array = array_merge($data_array, $r);
			if(isset($r['ip']))
				$data_array['ip'] = $r['ip'];
			if(isset($r['record_type']) && $host != "@")
				$data_array['record_type'] = $r['record_type'];
			if(isset($r['record_value']) && $host != "@")
				$data_array['record_value'] = $r['record_value'];
			if(isset($r['ttl']) && $host != "@")
				$data_array['ttl'] = $r['ttl'];
		}
		if($spit_out)
			print_r($r);
	}
	if(count($data_array))
	{
		$data_array['id' ] = $hid;
		update_subdomain_table($data_array, $host, $domain);
		
		$domain_data['dns_checked_at'] = date("Y-m-d H:i:s");
		update_domain_table($domain_data, $domain);
		
		if($spit_out)
		{
			echo "<pre>"; print_r($data_array); echo"</pre>";
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////

function do_root_dns_record_check($domain, $spit_out=false)
{
	$sid = get_sid_from_domain_name($domain);
	global $db_config_subdomain_table;
	$hostname = idn_convert_to_host_name($domain, "");
	
	$rns = dns_get_record($hostname, DNS_NS);
	$ra = dns_get_record($hostname, DNS_A);
	$rmx = dns_get_record($hostname, DNS_MX);
	$rtxt = dns_get_record($hostname, DNS_TXT);
	$r = array_merge($ra, $rns);
	$r = array_merge($r, $rmx);
	$r = array_merge($r, $rtxt);
	
	if(is_array($r))
	{
		$sqlDelete = "delete from $db_config_subdomain_table where auto_added=1 AND sid=$sid";
		$result = mysql_query( $sqlDelete ) or die ("Error adding to database");  
		
		$index = 0;
		foreach($r as $record)
		{
			$data_array = Array();
			$type = "";
			$target = "";
			$ttl = "";
			$pri = "";
			$ip = "";
			$host = "";
			if(isset($record['type']))
				$type = $record['type'];
			if(isset($record['ttl']))
				$ttl = $record['ttl'];
			if(isset($record['pri']))
				$pri = $record['pri'];
			if(isset($record['target']))
				$target = $record['target'];
			if(isset($record['ip']))
				$ip = $record['ip'];
			if(isset($record['host']))
				$host = $record['host'];
			if(isset($record['txt']))
				$txtval = $record['txt'];
			if($type == "NS" || $type == "MX" || $type == "CNAME" || $type == "A" || $type == "TXT")
			{
				$data_array['auto_added'] = 1;
				$data_array['record_type'] = $type;
				$data_array['ttl'] = $ttl;
				if($type == "NS" || $type == "MX")
				{
					if($type == "MX")
						$data_array['record_value'] = $pri . " " . $target;
					else
						$data_array['record_value'] = $target;
				}
				else if($type == "A")
					$data_array['ip'] = $ip;
				else if($type == "CNAME")
					$data_array['target'] = $host;
				else if($type == "TXT")
					$data_array['record_value'] = $txtval;
					
				$sqlAdd = "insert into $db_config_subdomain_table (`subdomain`, `added_on`, `sid`) values ('@', now(), $sid)";
				$result = mysql_query( $sqlAdd ) or die ("Error adding to database");  
				$hid = mysql_insert_id();
				$data_array['id'] = $hid;
				
				update_subdomain_table($data_array, "@", $domain);
		
				if($spit_out)
				{
					echo "<pre>";
					print_r($data_array);
				}
			}	
		}
		
		//$domain_data['dns_checked_at'] = date("Y-m-d H:i:s");
		//update_domain_table($domain_data, $domain);
				
		if($spit_out)
			print_r($r);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function do_ip_asn_lookup($ip, &$data_array)
{
	$blocks = explode('.', trim($ip));
	if(is_array($blocks))
	{
		if(count($blocks) == 4)
		{
			$host = $blocks[3] . "." . $blocks[2] . "." . $blocks[1] . "." . $blocks[0] . ".origin.asn.cymru.com";
			$result = dns_get_record($host , DNS_TXT);
			//print_r($result);
			if(isset($result[0]['txt']))
			{
				$entries = $result[0]['txt']; 
				$blocks = explode('|', $entries);
				if(is_array($blocks))
				{
					$asnum = "AS" . trim($blocks[0]);
					$data_array['ip_asnumber'] = $asnum;
					$result = dns_get_record($asnum . ".asn.cymru.com", DNS_TXT);
					//print_r($result);
					if(isset($result[0]['txt']))
					{
						$blocks = explode("|", $result[0]['txt']); 
						$count = count($blocks);
						$asname = trim($blocks[$count-1]);
						$dashpos = strpos($asname, " - ");
						if($dashpos > 0)
						{
							$asname = substr($asname, 0, $dashpos);
						}
						$data_array['ip_asname'] = $asname;
						//echo $asname . "\n";
					}	
				}
			}
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
