<?php
/////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2010-2014 Softnik Technologies
// 
// Initial Version: SK
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////

require_once("config.check.php");
require_once("../../config.php");
require_once("base.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Ajax script. 
# Check authentication and quit with http error code if auth fails.

session_start();
check_authentication_error_quit();
doSessionSwipeIn();

///////////////////////////////////////////////////////////////////////////////////////////////////

if(is_user_auth_enabled())
{
	$access_rights = 1;
	$userinfo = get_userinfo_from_session();
	if(!is_admin_user_or_is_basic_version())
	{
		$access_rights = $userinfo['readwrite'];
	}
	if($access_rights == 0 || $access_rights == 2) // 2 = Only Edit
	{
		header("HTTP/1.0 403 Forbidden");
		echo "Permission Denied.";
		exit;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////

function is_admin_user_or_is_basic_version()
{
	return is_admin_user();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

if(isset($_POST['exportdata']))
{
	header('Content-Encoding: UTF-8');
	$csvdata = stripslashes($_POST['exportdata']);
	$filename = "domain-columns.csv";
	if(isset($_REQUEST['txt']))
	{
		$filename = "domain-names.txt";
		header('Content-type: text/txt; charset=UTF-8');
	}
	else
		header('Content-type: text/csv; charset=UTF-8');
	header('Content-Length: ' . strlen($csvdata));
	header('Content-Disposition: attachment; filename=' . $filename);
	header('Content-Transfer-Encoding: binary');
	echo $csvdata;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

else if(isset($_REQUEST['dnsdata']))
{
	connect_to_mysql_and_select_db();
	$csvdata = "domain,record,type,value,ttl,ip,notes A,notes B\n";
	if(isset($_REQUEST['rowid']))
	{
		$idarray = validate_request_data( trim($_REQUEST['rowid'], ","));
		$ids = explode(",", $idarray);
		foreach($ids as $id)
		{
			$csvdata .= get_sub_domain_data($id);
			$csvdata .= "\n";
		}
	}
	
	header('Content-Encoding: UTF-8');
	$filename = "domain-dns.csv";
	header('Content-type: text/csv; charset=UTF-8');
	header('Content-Length: ' . strlen($csvdata));
	header('Content-Disposition: attachment; filename=' . $filename);
	header('Content-Transfer-Encoding: binary');
	echo $csvdata;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

else if(isset($_REQUEST['ssldata']))
{
	connect_to_mysql_and_select_db();
	$csvdata = "domain,record,ssl_valid_from,ssl_valid_till,ssl_issued_to,ssl_issued_by,notes A,notes B\n";
	if(isset($_REQUEST['rowid']))
	{
		$idarray = validate_request_data( trim($_REQUEST['rowid'], ","));
		$ids = explode(",", $idarray);
		foreach($ids as $id)
		{
			$csvdata .= get_domain_ssl_data($id);
			$csvdata .= "\n";
		}
	}
	
	header('Content-Encoding: UTF-8');
	$filename = "domain-ssl.csv";
	header('Content-type: text/csv; charset=UTF-8');
	header('Content-Length: ' . strlen($csvdata));
	header('Content-Disposition: attachment; filename=' . $filename);
	header('Content-Transfer-Encoding: binary');
	echo $csvdata;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function get_sub_domain_data($sid)
{
	$rowtext = "";
	$domain_name = get_domain_name_from_sid($sid);
	global $db_config_subdomain_table;
	$sql = "select * from " . $db_config_subdomain_table . " where sid = $sid";
	$idresults = mysql_query($sql) or die ("Error reading from database");  
	while($row = mysql_fetch_array($idresults,MYSQL_ASSOC)) 
	{
		$host = $row['subdomain'];
		$type = $row['record_type'];
		$target = $row['record_value'];
		$ip = $row['ip'];
		$ttl = $row['ttl'];
		$notes_a = $row['notes_a'];
		$notes_b = $row['notes_b'];
		$notes_a = str_replace('"', '%^%^%', $notes_a);
		$notes_a = str_replace('%^%^%', '""', $notes_a);
		$notes_b = str_replace('"', '%^%^%', $notes_b);
		$notes_b = str_replace('%^%^%', '""', $notes_b);
		$rowtext .= "$domain_name,$host,$type,$target,$ttl,$ip,\"$notes_a\",\"$notes_b\"\n";
	}
	return $rowtext;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function get_domain_ssl_data($sid)
{
	$rowtext = "";
	$domain_name = get_domain_name_from_sid($sid);
	global $db_config_subdomain_table;
	$sql = "select * from " . $db_config_subdomain_table . " where sid = $sid";
	$idresults = mysql_query($sql) or die ("Error reading from database");  
	while($row = mysql_fetch_array($idresults,MYSQL_ASSOC)) 
	{
		$subdomain = $row['subdomain'];
		$ssl_from = $row['ssl_valid_from'];
		$ssl_to = $row['ssl_valid_to'];
		$ssl_issue = $row['ssl_issued_to'];
		$ssl_by = $row['ssl_issued_by'];
		$notes_a = $row['notes_a'];
		$notes_b = $row['notes_b'];
		$notes_a = str_replace('"', '%^%^%', $notes_a);
		$notes_a = str_replace('%^%^%', '""', $notes_a);
		$notes_b = str_replace('"', '%^%^%', $notes_b);
		$notes_b = str_replace('%^%^%', '""', $notes_b);
		if($ssl_from != "")
			$rowtext .= "$domain_name,$subdomain,$ssl_from,$ssl_to,$ssl_issue,$ssl_by,\"$notes_a\",\"$notes_b\"\n";
	}
	return $rowtext;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
