<?php
	
require_once(dirname(__FILE__) . "/../../../config.php");
require_once(dirname(__FILE__) . "/../base.php");

/////////////////////////////////////////////////////////////////////////////////////////////////////////

# Only admin users can use this script.
# If user authentication is disabled, everyone is an admin user!

session_start();
check_authentication_login();
if(is_admin_user() == false)
{
	header("Location: " . get_base_path());
	exit;
}
doSessionSwipeIn();

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function get_base_dir()
{
	return realpath(dirname(__FILE__)) . DIRECTORY_SEPARATOR;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	$jqtheme = get_theme_name("");
	$title = "";
	if($title == "")
		$title = "Domain Portfolio Manager - Data History";
	$panesjs = "cfgpanes.js";
	$grid_url_file = get_grid_base_file_name();

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
		<title><?php echo $title; ?></title>
		<meta http-equiv="Content-Language" content="en">
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<link rel="shortcut icon" type="image/x-icon" href="../../css/img/favicon.ico">
		
		<link type="text/css" href="../../css/jqueryui/<?php echo $jqtheme; ?>/jquery-ui-1.8.7.custom.css" rel="stylesheet">
		<link type="text/css" href="../../css/jqueryui/<?php echo $jqtheme; ?>/splitter.1.51.css" rel="stylesheet" media="screen">
		<link type="text/css" href="../../css/jqueryui/splitter.1.51.css" rel="stylesheet" media="screen">
		<link type="text/css" href="../../css/jqueryui/ui.jqgrid.css" rel="stylesheet" media="screen">

		<script type="text/javascript" src="../../js/jquery/jquery-1.5.1.min.js"></script>
		<script type="text/javascript" src="../../js/jquery/jquery.cookie.min.js"></script>
		<script type="text/javascript" src="../../js/jquery/jquery-ui-1.8.7.noeffects.min.js"></script>
		<script type="text/javascript" src="../../js/jquery/splitter.1.51.min.js"></script>
		<script type="text/javascript" src="../../js/jquery/i18n/grid.locale-en.js"></script>
		<script type="text/javascript" src="../../js/jquery/jquery.jqGrid.3.8.2.min.js"></script>
		
		<link type="text/css" href="../../css/default.css" rel="stylesheet" media="all">
		<link type="text/css" href="../../css/<?php echo $jqtheme; ?>.css" rel="stylesheet" media="all">
		<script type="text/javascript" src="../../js/<?php echo $panesjs; ?>"></script>
		<script type="text/javascript" src="../../js/historygrid.js"></script>
<?php
		if(get_main_logo_image() != "")
			echo "\t\t<style> .mainlogo {background-image: url('" . get_main_logo_image() . "');}</style>\n";
?>
		<script type="text/javascript">
			var grid_url_base = "../../php/<?php echo $grid_url_file; ?>";
			$(function() 
			{
				$('#menu').button({text: false, label:"Main Menu", icons: {primary: 'main-menu-button'}});
				$("#menu").click(function(){window.location="../../../menu.php";});
				$('#pfolio').button({text: false, label:"Domain Portfolio", icons: {primary: 'pfolio-column-button'}});
				$("#pfolio").click(function(){window.location="../../../index.php";});
				$('#report').button({text: false, label:"Simple Reports", icons: {primary: 'report-button'}});
				$("#report").click(function(){window.location = '../../../report.php';});
				$('#admin').button({text: false, label:"User Admin", icons: {primary: 'admin-button'}});
				$("#admin").click(function(){window.location = '../../../admin.php';});
				$('#appsetup').button({text: false, label:"Basic App Setup", icons: {primary: 'appsetup-button'}});
				$("#appsetup").click(function(){window.location = '../../../appsetup.php';});
				$('#logout').button({text: false, label:"Logout", icons: {primary: 'logout-button'}});
				$("#logout").click(function(){window.location = '../../php/login.php?logout';});
				$('#home').button({text: false, label:"Home Page", icons: {primary: 'home-button'}});
				$("#home").click(function(){window.open('../../php/links.php?r=home');});
				$('#products').button({text: false, label:"Products", icons: {primary: 'products-button'}});
				$("#products").click(function(){window.open('../../php/links.php?r=products');});
				$('#support').button({text: false, label:"Support", icons: {primary: 'support-button'}});
				$("#support").click(function(){window.open('../../php/links.php?r=support');});
				$('#contact').button({text: false, label:"Contact",  icons: {primary: 'contact-button'}});
				$("#contact").click(function(){window.open('../../php/links.php?r=contact');});
			});
		</script>
</head>

<body>
		<div id="header">
		<div class="mainlogo">&nbsp;</div>
		<div class="navbar">
			<button id="menu"></button>
			&nbsp;&nbsp;
			<button id="pfolio"></button>
			&nbsp;&nbsp;
		<?php
			if(is_admin_user())
			{
		?>
				<button id="report"></button>
				<button id="appsetup"></button>
				<button id="admin"></button>
		<?php
			}
			show_link_buttons();
			if(is_user_auth_enabled())
			{
		?>
				&nbsp;&nbsp;
				<button id="logout"></button>
		<?php
			}
		?>
		</div>
		<div class="clear">&nbsp;</div>
	</div>

	<div id="ConfigVSplitter">
		<div id="ControlPane">
			<div class="Padded10">
				<table id="DomainHistoryTable"></table>
				<div id="pagerDomainHistory"></div>
			</div>
		</div> <!-- #ControlPane -->
	  
		<div id="RightPane" style="overflow: auto;">
			<div id="ConfigPane">
				<div class="Padded10">
					<div id="DomainHistoryTabView">
						<div class="Padded10">
							<ul>
								<li><a href="#datahistory">Data History</a></li>
							</ul>
							<div id="daathistory">
								<div class="topbar" style="height:30px; border-radius:3px; border: 1px solid #AAA; margin-top: 20px; margin-bottom: 20px;">
									<div style="padding:5px;">
										Select the Data Type:
										<select id="lookup_type" name="lookup_type">
										  <option value="ip" selected>IP Address</option>
										  <option value="gi">Google Index</option>
										  <option value="gpr">Google PR</option>
										</select>
									</div>
								</div>
								<table id="HistoryDataTable"></table>
								<div id="pagerHistoryData"></div>
								<div id="csvdnload"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div> <!-- #RightPane -->
	</div> <!-- #ConfigVSplitter -->
	
</body>
</html>
<?php
?>
