<?php
#########################################################################################################
#  hidenavbar-sample.php
#
#  Copyright (C) Softnik Technologies. All rights reserved.
#
#  Sample PHP script that emits Javascript to hide specific toolbar buttons for non-admin users.  
#
#  Remember to copy and or rename this file before making changes. This will protect your modifications 
#  from getting over-written. The best place to keep custom scripts is the 'lib/php/custom/' folder. 
#
#  Step - 1
#
#  Open this file in a text editor and scroll to the end. Edit the entries to hide the required buttons.
#
#  Step - 2
#
#  Rename 'head.js-sample.php' in lib/php/custom/ folder to 'head.js.php'. Include your version of this 
#  file (hidenavbar-sample.php) in it.
#  
#
#########################################################################################################

/////////////////////////////////////////////////////////////////////////////////////////////////////////
require_once("../../../config.php");
/////////////////////////////////////////////////////////////////////////////////////////////////////////

function is_admin_user()
{
	if(is_user_auth_enabled() == false)
		return true;
	else
	{
		if(isset($_SESSION['user']))
		{
			$userinfo = $_SESSION['user'];
			if(is_array($userinfo))
				if($userinfo['admin'])
					return true;
		}
		return false;
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

function is_user_auth_enabled()
{
	global $admin_user_name, $admin_password;
	if(isset($admin_user_name) && isset($admin_password))
	{
		if($admin_user_name != "" && $admin_password != "")
			return true;
	}
	return false;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
// The various button ids are
// adddomains, importdomains, deldomains, bulkaction, dates, http, registrar, network, sitepop, notes
// ipinfo, cdisp01, cdisp02, runq, logout 

if(!is_admin_user())
{
	echo "$(function(){";
	
	####  Edit below to hide the buttons. 
	####  Uncomment the first entry to hide the entire toolbar.
	
	//echo "$('.navbar').hide();";
	echo "$('#runq').hide();";
	echo "$('#notes').hide();";
	echo "$('#sitepop').hide();";
	
	####

	echo "});";
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
