<?php

#########################################################################################################
#  db-backup-download-sample.php
#
#  Copyright (C) Softnik Technologies. All rights reserved.
#
#  PHP script to download the MySQL backup (required 'exec' to be enabled in PHP)
#
#  Use f=xxx  to specify the full file name. The actual file will be xxx.sql.gz
#  Use p=xxx to specify a prefix for the file name. The actual file name will be 
#  xxx-dd-mm-yyyy.sql.gz (date-stamped file name)
# 
#  Remember to copy and or rename this file before making changes. This will protect your modifications 
#  from getting over-written. The best place to keep custom scripts is the 'lib/php/custom/' folder.
#
#  Before using this
#  -----------------
#  The script will require that you login if you have password protected the application. However this
#  will be a problem when running this script from command line. To overcome this we use the
#  'CLI Authorization Key'. The 'CLI Authorization Key' is a unique string / password you set from the 
#  'Basic App Setup > Authentication' screen.
#  After you have specified the key, use it as follows.
#
#  php /path/to/script/mysql-backup.php key=xxxxxx
#  OR
#  wget http://server/path/mysql-backup.php?key=xxxxxx
#
#########################################################################################################
#
# This will work only if exec is permitted in PHP.
# Specify the path to mysqldump.
# Normally just mysqldump is enough, but in some cases (Mac OS X) you may need to specify the full path.
# $binpath = "/usr/local/mysql/bin/mysqldump";
# $binpath = "mysqldump";
# etc.

$binpath = "mysqldump";

#########################################################################################################
# You probably won't need to edit below this line.
#########################################################################################################

require_once(dirname(__FILE__) . "/../../../config.php");
require_once(dirname(__FILE__) . "/../base.php");
require_once(dirname(__FILE__) . "/../mailer.inc.php");

#########################################################################################################

# Parse command line if running in CLI
if(is_cli())
	parse_str(implode('&', array_slice($argv, 1)), $_REQUEST);

session_start();
cli_mode_authentication_check();

#########################################################################################################

$fileprefix = filter_var(getRequestVariable("p", "backup"), FILTER_SANITIZE_STRING);

$fn = getRequestVariable("f", "");
if($fn != "")
	$fn = filter_var($fn, FILTER_SANITIZE_STRING);

/////////////////////////////////////////////////////////////////////////////////////////////////////////

$command = $binpath . ' --opt -h' . $db_config_host . ' -u' . $db_config_username . ' -p' . $db_config_password . ' ' . $db_config_database; 
$command .= " | gzip --best";

if($fn != "")
	$filename = $fn . ".sql.gz";
else
	$filename = "$fileprefix-" . date("d-m-Y") . ".sql.gz";

$mime = "application/x-gzip";
header( "Content-Type: " . $mime );
header( 'Content-Disposition: attachment; filename="' . $filename . '"' );

passthru($command);
exit;

/////////////////////////////////////////////////////////////////////////////////////////////////////////

?>
