<div class="toolcontainer">
	<div class="ludefault">
		<h3>Default Lookup Types</h3>
		<div class="dotline"></div>
		<p>When you add domains, they can be automatically queued for certain types of lookups. Check the boxes
		corresponding to the lookups that should happen when a new domain is added to the database. Please avoid
		automatic lookups when not required. You can always do the lookups manually whenever needed.</p>
		<br>
<?php
	global $default_lookup_types, $home_page_max_redirs, $config_subdomain_entry, $default_sub_domains;
	global $do_dns_record_lookup, $requeue_on_empty_whois, $fix_host_domain_names;
	
	if($default_lookup_types == "")
		$default_lookup_types = "dw,ip";
	$sdw = ""; $sip = ""; $sipw = ""; $salexa = ""; $sping = "";
	$shttp = ""; $sgpr = ""; $sgi = ""; $smx = ""; $ssdom = ""; $sssl = "";
	$lutypes = strtolower($default_lookup_types) . ",";
	if(strstr($lutypes, "dw,") !== false)
		$sdw = "checked";
	if(strstr($lutypes, "ip,") !== false)
		$sip = "checked";
	if(strstr($lutypes, "ipw,") !== false)
		$sipw = "checked";
	if(strstr($lutypes, "mx,") !== false)
		$smx = "checked";
	if(strstr($lutypes, "http,") !== false)
		$shttp = "checked";
	if(strstr($lutypes, "ping,") !== false)
		$sping = "checked";
	if(strstr($lutypes, "alexa,") !== false)
		$salexa = "checked";
	if(strstr($lutypes, "gpr,") !== false)
		$sgpr = "checked";
	if(strstr($lutypes, "gi,") !== false)
		$sgi = "checked";
	if(strstr($lutypes, "dns,") !== false)
		$ssdom = "checked";
	if(strstr($lutypes, "ssl,") !== false)
		$sssl = "checked";
?>
		<div id="lookuplist">
			<ul class="ui-selectable" style="">
				<li><input id="cb-lu-dw" type="checkbox" <?php echo $sdw; ?>>Domain Whois</li>
				<li><input id="cb-lu-ipw" type="checkbox" <?php echo $sipw; ?>>IP Whois</li>
				<li><input id="cb-lu-ip" type="checkbox" <?php echo $sip; ?>>IP</li>
				<li><input id="cb-lu-mx" type="checkbox" <?php echo $smx; ?>>MX</li>
				<li><input id="cb-lu-http" type="checkbox" <?php echo $shttp; ?>>Home Page Check</li>
				<li><input id="cb-lu-ping" type="checkbox" <?php echo $sping; ?>>Ping</li>
				<li><input id="cb-lu-alexa" type="checkbox" <?php echo $salexa; ?>>Alexa</li>
				<li><input id="cb-lu-gpr" type="checkbox" <?php echo $sgpr; ?>>Google PR</li>
				<li><input id="cb-lu-gi" type="checkbox" <?php echo $sgi; ?>>Google Index</li>
				<li><input id="cb-lu-dns" type="checkbox" <?php echo $ssdom; ?>>Sub Domains</li>
				<li><input id="cb-lu-ssl" type="checkbox" <?php echo $sssl; ?>>SSL</li>
			</ul>
		</div>
	</div>
	<div class="lupreference">
		<h3>High Preference Lookups</h3>
		<div class="dotline"></div>
		<p>The application processes lookup queue in a FIFO manner (First-In First-Out). 
		This means that if you  first queue 1000 domains for MX lookup and then queue 
		the same domains for IP Whois, the IP Whois will happen only after all the MX 
		Lookups are done. You can override this behaviour by making certain types of 
		lookups to have a higher preference by checking the boxes below.</p>
		<br>
<?php
	global $high_preference_lookups;
	$hpsdw = ""; $hpsip = ""; $hpsipw = ""; $hpsalexa = ""; $hpsping = ""; $hpssdw = "";
	$hpshttp = ""; $hpsgpr = ""; $hpsgi = ""; $hpsmx = ""; $hpssl = ""; $hpsdom = "";
	$lutypes = "," . strtolower($high_preference_lookups) . ",";
	if(strstr($lutypes, ",dw,") !== false)
		$hpsdw = "checked";
	if(strstr($lutypes, "sdw,") !== false)
		$hpssdw = "checked";
	if(strstr($lutypes, "ip,") !== false)
		$hpsip = "checked";
	if(strstr($lutypes, "ipw,") !== false)
		$hpsipw = "checked";
	if(strstr($lutypes, "mx,") !== false)
		$hpsmx = "checked";
	if(strstr($lutypes, "http,") !== false)
		$hpshttp = "checked";
	if(strstr($lutypes, "ping,") !== false)
		$hpsping = "checked";
	if(strstr($lutypes, "alexa,") !== false)
		$hpsalexa = "checked";
	if(strstr($lutypes, "gpr,") !== false)
		$hpsgpr = "checked";
	if(strstr($lutypes, "gi,") !== false)
		$hpsgi = "checked";
	if(strstr($lutypes, "ssl,") !== false)
		$hpssl = "checked";
	if(strstr($lutypes, "dns,") !== false)
		$hpsdom = "checked";
?>
		<div id="lupreflist">
			<ul class="ui-selectable" style="">
				<li><input id="cb-luh-dw" type="checkbox" <?php echo $hpsdw; ?>>Registry Whois</li>
				<li><input id="cb-luh-sdw" type="checkbox" <?php echo $hpssdw; ?>>Registrar Whois</li>
				<li><input id="cb-luh-ipw" type="checkbox" <?php echo $hpsipw; ?>>IP Whois</li>
				<li><input id="cb-luh-ip" type="checkbox" <?php echo $hpsip; ?>>IP</li>
				<li><input id="cb-luh-mx" type="checkbox" <?php echo $hpsmx; ?>>MX</li>
				<li><input id="cb-luh-http" type="checkbox" <?php echo $hpshttp; ?>>Home Page Check</li>
				<li><input id="cb-luh-ping" type="checkbox" <?php echo $hpsping; ?>>Ping</li>
				<li><input id="cb-luh-alexa" type="checkbox" <?php echo $hpsalexa; ?>>Alexa</li>
				<li><input id="cb-luh-gpr" type="checkbox" <?php echo $hpsgpr; ?>>Google PR</li>
				<li><input id="cb-luh-gi" type="checkbox" <?php echo $hpsgi; ?>>Google Index</li>
				<li><input id="cb-luh-ssl" type="checkbox" <?php echo $hpssl; ?>>SSL</li>
				<li><input id="cb-luh-dns" type="checkbox" <?php echo $hpsdom; ?>>Sub Domains</li>
			</ul>
		</div>
	</div>
	
	<div class="lumiscbox">
		<h3>Other Lookup Options</h3>
		<div class="dotline"></div>
		<input type="checkbox" id="do_dns_record_lookup" <?php echo ($do_dns_record_lookup ? "checked" : ""); ?>><b>DNS Root Record Lookup</b><br><br>
		Lookup all available root records (A, NS, MX) when the domain IP is looked up.
		<div class="dotline"></div>
		<input type="checkbox" id="requeue_on_empty_whois" <?php echo ($requeue_on_empty_whois ? "checked" : ""); ?>><b>Re-queue on Empty Whois</b><br><br>
		At times, some whois servers simply return an empty result on lookup. You can make the application 
		automatically queue those lookups again.
		<div class="dotline"></div>
		<input type="checkbox" id="fix_host_domain_names" <?php echo ($fix_host_domain_names ? "checked" : ""); ?>><b>Fix Host Domain Names</b><br><br>
		Automatically attempt to lookup correct domain names when hostnames are entered (www.example.com instead of example.com).
		<div class="dotline"></div>
		<p><b>Default Host Name</b><br>
		<input type="text" id="config_subdomain_entry" name="config_subdomain_entry" value="<?php echo $config_subdomain_entry; ?>" style="width:180px;"><br><br>
		The application can add a subdomain to the start of the domain name before doing home page checks,
		web visibility, ip check and ping. You may want to set it to <i>www</i>.</p>
		<div class="dotline"></div>
		<p><b>Default Sub Domains</b><br>
		<input type="text" id="default_sub_domains" name="default_sub_domains" value="<?php echo $default_sub_domains; ?>" style="width:180px;"><br><br>
		The application can automatically add a set of subdomains to the domain. Specify a set of comma separated entries here. Eg. www,mail</p>
		<div class="dotline"></div>
		<p><b>Max Redirects (http check)</b><br>
		<input type="text" id="home_page_max_redirs" name="home_page_max_redirs" value="<?php echo $home_page_max_redirs; ?>" style="width:180px;"><br><br>
		Specify the maximum redirects the application should follow when doing home page checks.
		The allowed values are 0-10.</p>
	</div>
	
	<div style="clear:both;"></div>

</div>
