<?php

global $home_page_link, $product_page_link, $support_page_link, $contact_page_link;
global $cell_date_format, $main_logo_image, $custom_tools_file;
	
function echo_select($theme, $dtheme)
{
	global $ui_theme;
	if($theme == $ui_theme)
		echo "\t\t<option value=\"$theme\" selected>$dtheme</option>\n";
	else 
		echo "\t\t<option value=\"$theme\">$dtheme</option>\n";
}

?>
	<div class="toolcontainer">
		<div class="interfacebox">
			<h3>Select the interface theme</h3>

				<select id="ui_theme" name="ui_theme">
			<?php
				  echo_select("redmond", "Redmond");
				  echo_select("black-tie", "Black Tie");
				  echo_select("smoothness", "Smoothness");
				  echo_select("sunny", "Sunny");
				  echo_select("flick", "Flick");
				  echo_select("le-frog", "Le-Frog");
				  echo_select("ui-darkness", "UI-Darkness");
				  echo_select("pepper-grinder", "Pepper-Grinder");
				  echo_select("sed-start", "SED-Start");
				  echo_select("hot-sneaks", "Hot-Sneaks");
			?>
				</select>
			<br><br>
			<h3>Toolbar Links in Main Interface</h3>
			
			<p><img src="lib/css/img/ui-tb-sample.png"></p>
			
			<p>You can hide the buttons from the toolbar by removing the corresponding URL entry.</p>
			
			<p>Home Page<br>
			<input type="text" id="home_page_link" name="home_page_link" value="<?php echo $home_page_link; ?>" style="width:280px;"></p>
			
			<p>Product Page<br>
			<input type="text" id="product_page_link" name="product_page_link" value="<?php echo $product_page_link; ?>" style="width:280px;"></p>
			
			<p>Contact Page<br>
			<input type="text" id="contact_page_link" name="contact_page_link" value="<?php echo $contact_page_link; ?>" style="width:280px;"></p>
			
			<p>Support Page<br>
			<input type="text" id="support_page_link" name="support_page_link" value="<?php echo $support_page_link; ?>" style="width:280px;"></p>
			
		</div>
		
		<div class="miscdatabox">
			<h3>Other Interface Settings</h3>
			<div class="dotline"></div>
		
			<p style="text-align:left;"><b>Date Format in Domain Table</b>: Example formats include <i>d-M-Y</i>, <i>M-d-Y</i>.<br><br>
			<input type="text" id="cell_date_format" name="cell_date_format" value="<?php echo $cell_date_format; ?>" style="width:220px;"><br>
			<br><br>
			<input type="checkbox" id="domain_grid_search" <?php echo ($domain_grid_search ? "checked" : ""); ?>>
			<b>Enable Search in Domain Table</b> Enable the search dialog in the domain table grid. By default this is not enabled.<br><br>
			
			<p>Main Logo Image<br>
			<input type="text" id="main_logo_image" name="main_logo_image" value="<?php echo $main_logo_image; ?>" style="width:280px;"></p>
			
			<p>Custom Tools<br>
			<input type="text" id="custom_tools_file" name="custom_tools_file" value="<?php echo $custom_tools_file; ?>" style="width:280px;"></p>

			
		</div>
		
		<div class="interfaceinfobox">
			<h3>The Main Logo</h3>
			<p>The main logo can be customized. It should be 300x36 or smaller and ideally should have 
			a transparent background. Upload to lib/css/img folder and specify the relative path (lib/css/img/mylogo.png).
			Remember to check the logo under different themes. You may need to clear the 
			browser cache to see any changes you make to the logo here.</p>

			<h3>Custom Tools ('Online Tools' Tab)</h3>
			<p>Specify the relative path to a file that will be appended to the online tools display.
			This can contain any HTML with links and images. If you have {{domain}} anywhere in a link, it will
			be replaced with the currently selected domain name. You should probably put any file you
			create in the "lib/php/custom/" folder so that it will not be over-written on an app update.</p>
		</div>
		
		<div style="clear:both;"></div>
	</div>